/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.frameworks.internal;

import java.util.ArrayList;
import org.eclipse.wst.common.frameworks.internal.IWrappedException;

public class ExceptionHelper {
    private ExceptionHelper() {
    }

    public static String[] getAllMessages(IWrappedException exception) {
        ArrayList<String> messages = new ArrayList<String>(4);
        messages.add(exception.getMessage());
        Exception nested = exception.getNestedException();
        while (nested != null) {
            messages.add(nested.getMessage());
            nested = nested instanceof IWrappedException ? ((IWrappedException)((Object)nested)).getNestedException() : null;
        }
        return messages.toArray(new String[messages.size()]);
    }

    public static String getConcatenatedMessages(IWrappedException exception) {
        String[] messages = ExceptionHelper.getAllMessages(exception);
        StringBuffer sb = new StringBuffer(256);
        int i = 0;
        while (i < messages.length) {
            sb.append(messages[i]);
            if (i < messages.length - 1) {
                sb.append('\n');
            }
            ++i;
        }
        return sb.toString();
    }
}

