/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.remote.internal.ui.services.local;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import org.eclipse.remote.core.IRemoteConnection;
import org.eclipse.remote.core.IRemoteConnectionType;
import org.eclipse.remote.ui.IRemoteUIFileService;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;

public class LocalUIFileService
implements IRemoteUIFileService {
    private final IRemoteConnectionType connectionType;
    private IRemoteConnection connection = null;

    public LocalUIFileService(IRemoteConnectionType connectionType) {
        this.connectionType = connectionType;
    }

    public IRemoteConnectionType getConnectionType() {
        return this.connectionType;
    }

    @Override
    public String browseDirectory(Shell shell, String message, String filterPath, int flags) {
        Object path;
        DirectoryDialog dialog = new DirectoryDialog(shell);
        dialog.setText(message);
        if (filterPath != null && ((File)(path = new File(filterPath))).exists()) {
            dialog.setFilterPath(((File)path).isFile() ? ((File)path).getParent() : filterPath);
        }
        if ((path = dialog.open()) == null) {
            return null;
        }
        return path;
    }

    @Override
    public String browseFile(Shell shell, String message, String filterPath, int flags) {
        Object path;
        FileDialog dialog = new FileDialog(shell, 4);
        dialog.setText(message);
        if (filterPath != null && ((File)(path = new File(filterPath))).exists()) {
            dialog.setFilterPath(((File)path).isFile() ? ((File)path).getParent() : filterPath);
        }
        if ((path = dialog.open()) == null) {
            return null;
        }
        return path;
    }

    @Override
    public List<String> browseFiles(Shell shell, String message, String filterPath, int flags) {
        Object path;
        FileDialog dialog = new FileDialog(shell, 2);
        dialog.setText(message);
        if (filterPath != null && ((File)(path = new File(filterPath))).exists()) {
            dialog.setFilterPath(((File)path).isFile() ? ((File)path).getParent() : filterPath);
        }
        if ((path = dialog.open()) == null) {
            return null;
        }
        return Arrays.asList(dialog.getFileNames());
    }

    @Override
    public IRemoteConnection getConnection() {
        return this.connection;
    }

    @Override
    public void setConnection(IRemoteConnection connection) {
        this.connection = connection;
    }

    @Override
    public void showConnections(boolean enable) {
    }

    public static class Factory
    implements IRemoteConnectionType.Service.Factory {
        public <T extends IRemoteConnectionType.Service> T getService(IRemoteConnectionType connectionType, Class<T> service) {
            if (IRemoteUIFileService.class.equals(service)) {
                return (T)new LocalUIFileService(connectionType);
            }
            return null;
        }
    }
}

