/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.text;

import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWhitespaceDetector;
import org.eclipse.jface.text.rules.SingleLineRule;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WhitespaceRule;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.pde.internal.ui.editor.text.BasePDEScanner;
import org.eclipse.pde.internal.ui.editor.text.ExternalizedStringRule;
import org.eclipse.pde.internal.ui.editor.text.IColorManager;
import org.eclipse.pde.internal.ui.editor.text.XMLWhitespaceDetector;

public class XMLScanner
extends BasePDEScanner {
    private Token fProcInstr;
    private Token fExternalizedString;

    public XMLScanner(IColorManager manager) {
        super(manager);
    }

    @Override
    protected void initialize() {
        this.fProcInstr = new Token((Object)this.createTextAttribute("editor.color.instr"));
        this.fExternalizedString = new Token((Object)this.createTextAttribute("editor.color.externalized_string"));
        IRule[] rules = new IRule[]{new SingleLineRule("<?", "?>", (IToken)this.fProcInstr), new ExternalizedStringRule((IToken)this.fExternalizedString), new WhitespaceRule((IWhitespaceDetector)new XMLWhitespaceDetector())};
        this.setRules(rules);
        this.setDefaultReturnToken((IToken)new Token((Object)this.createTextAttribute("editor.color.default")));
    }

    @Override
    protected Token getTokenAffected(PropertyChangeEvent event) {
        if (event.getProperty().startsWith("editor.color.instr")) {
            return this.fProcInstr;
        }
        if (event.getProperty().startsWith("editor.color.externalized_string")) {
            return this.fExternalizedString;
        }
        return (Token)this.fDefaultReturnToken;
    }

    @Override
    public boolean affectsTextPresentation(String property) {
        return property.startsWith("editor.color.default") || property.startsWith("editor.color.instr") || property.startsWith("editor.color.externalized_string");
    }
}

