/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.core.compiler.ast.nodes;

import java.util.List;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.dltk.ast.references.TypeReference;
import org.eclipse.php.core.compiler.ast.nodes.FullyQualifiedReference;

public class DNFTypeReference
extends TypeReference {
    public static final int T_UNION = 1;
    public static final int T_INTERSECTION = 2;
    private final List<TypeReference> references;
    private final int type;

    public DNFTypeReference(int start, int end, List<TypeReference> references, int type) {
        super(start, end, DNFTypeReference.mergeNames(references, type));
        this.references = references;
        this.type = type;
    }

    public void traverse(ASTVisitor pVisitor) throws Exception {
        if (pVisitor.visit((Expression)this)) {
            for (TypeReference ref : this.references) {
                ref.traverse(pVisitor);
            }
            pVisitor.endvisit((Expression)this);
        }
    }

    public int getType() {
        return this.type;
    }

    public List<TypeReference> getReferences() {
        return this.references;
    }

    private static String mergeNames(List<TypeReference> list, int type) {
        StringBuilder sb = new StringBuilder();
        for (TypeReference ref : list) {
            if (!sb.isEmpty()) {
                switch (type) {
                    case 1: {
                        sb.append('|');
                        break;
                    }
                    case 2: {
                        sb.append('&');
                    }
                }
            }
            if (ref instanceof DNFTypeReference) {
                sb.append('(');
            }
            sb.append(ref instanceof FullyQualifiedReference ? ((FullyQualifiedReference)ref).getFullyQualifiedName() : ref.getName());
            if (!(ref instanceof DNFTypeReference)) continue;
            sb.append(')');
        }
        return sb.toString();
    }
}

