/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.debug.ui.display.internal;

import org.eclipse.dltk.debug.ui.display.IEvaluateConsole;
import org.eclipse.dltk.debug.ui.display.IEvaluateConsoleFactory;
import org.eclipse.dltk.debug.ui.display.ScriptDisplayView;
import org.eclipse.dltk.debug.ui.display.internal.ConsoleMessages;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.activities.WorkbenchActivityHelper;
import org.eclipse.ui.internal.console.ConsolePluginImages;

public class OpenConsoleAction
extends Action
implements IMenuCreator {
    private ScriptDisplayView view;
    private IEvaluateConsoleFactory[] fFactoryExtensions;
    private Menu fMenu;

    public OpenConsoleAction(ScriptDisplayView view, IEvaluateConsoleFactory[] factories) {
        this.view = view;
        this.fFactoryExtensions = factories;
        this.setText(ConsoleMessages.OpenConsoleAction_0);
        this.setToolTipText(ConsoleMessages.OpenConsoleAction_1);
        this.setImageDescriptor(ConsolePluginImages.getImageDescriptor((String)"IMG_ELCL_NEW_CON"));
        this.setMenuCreator(this);
    }

    public void dispose() {
        this.fFactoryExtensions = null;
    }

    public void runWithEvent(Event event) {
        if (event.widget instanceof ToolItem) {
            ToolItem toolItem = (ToolItem)event.widget;
            ToolBar control = toolItem.getParent();
            Menu menu = this.getMenu((Control)control);
            Rectangle bounds = toolItem.getBounds();
            Point topLeft = new Point(bounds.x, bounds.y + bounds.height);
            menu.setLocation(control.toDisplay(topLeft));
            menu.setVisible(true);
        }
    }

    public Menu getMenu(Control parent) {
        if (this.fMenu != null) {
            this.fMenu.dispose();
        }
        this.fMenu = new Menu(parent);
        int accel = 1;
        int i = 0;
        while (i < this.fFactoryExtensions.length) {
            IEvaluateConsoleFactory extension = this.fFactoryExtensions[i];
            if (!WorkbenchActivityHelper.filterItem((Object)extension) && extension.isEnabled()) {
                String label = extension.getLabel();
                ImageDescriptor image = extension.getImageDescriptor();
                this.addActionToMenu(this.fMenu, new ConsoleFactoryAction(label, image, extension), accel);
                ++accel;
            }
            ++i;
        }
        return this.fMenu;
    }

    private void addActionToMenu(Menu parent, Action action, int accelerator) {
        if (accelerator < 10) {
            StringBuffer label = new StringBuffer();
            label.append('&');
            label.append(accelerator);
            label.append(' ');
            label.append(action.getText());
            action.setText(label.toString());
        }
        ActionContributionItem item = new ActionContributionItem((IAction)action);
        item.fill(parent, -1);
    }

    public Menu getMenu(Menu parent) {
        return null;
    }

    private class ConsoleFactoryAction
    extends Action {
        private IEvaluateConsoleFactory fConfig;

        public ConsoleFactoryAction(String label, ImageDescriptor image, IEvaluateConsoleFactory extension) {
            this.setText(label);
            if (image != null) {
                this.setImageDescriptor(image);
            }
            this.fConfig = extension;
        }

        public void run() {
            IEvaluateConsole console = this.fConfig.create();
            if (console != null) {
                OpenConsoleAction.this.view.addConsole(console);
            }
        }

        public void runWithEvent(Event event) {
            this.run();
        }
    }
}

