/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.markdown.internal.block;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.mylyn.wikitext.markdown.internal.block.NestableBlock;
import org.eclipse.mylyn.wikitext.parser.Attributes;

public class HeadingBlock
extends NestableBlock {
    private static final Pattern pattern = Pattern.compile("(#{1,6})\\s*(.+?)\\s*(?:#*\\s*)?");
    private Matcher matcher;

    public boolean canStart(String line, int lineOffset) {
        this.matcher = pattern.matcher(line.substring(lineOffset));
        return this.matcher.matches();
    }

    protected int processLineContent(String line, int offset) {
        int level = this.matcher.group(1).length();
        Attributes attributes = new Attributes();
        int textStart = offset + this.matcher.start(2);
        int textEnd = offset + this.matcher.end(2);
        String lineExcludingClosingHash = line.substring(0, textEnd);
        attributes.setId(this.state.getIdGenerator().newId("h" + level, lineExcludingClosingHash));
        this.builder.beginHeading(level, attributes);
        this.markupLanguage.emitMarkupLine(this.getParser(), this.state, lineExcludingClosingHash, textStart);
        this.builder.endHeading();
        this.setClosed(true);
        return -1;
    }
}

