/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tips.core;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.eclipse.tips.core.TipAction;

public abstract class Tip {
    private final String providerId;
    private final List<TipAction> fActions = new ArrayList<TipAction>();

    public Tip(String providerId) {
        this.providerId = providerId;
    }

    public String getProviderId() {
        return this.providerId;
    }

    public List<TipAction> getActions() {
        return this.fActions;
    }

    public abstract Date getCreationDate();

    public abstract String getSubject();

    public int hashCode() {
        return Objects.hash(this.getCreationDate(), this.providerId, this.getSubject());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Tip other = (Tip)obj;
        return Objects.equals(this.getCreationDate(), other.getCreationDate()) && Objects.equals(this.providerId, other.providerId) && Objects.equals(this.getSubject(), other.getSubject());
    }
}

