/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.preferences.formatter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.cdt.core.formatter.DefaultCodeFormatterConstants;
import org.eclipse.cdt.internal.corext.util.Messages;
import org.eclipse.cdt.internal.ui.preferences.formatter.CPreview;
import org.eclipse.cdt.internal.ui.preferences.formatter.FormatterMessages;
import org.eclipse.cdt.internal.ui.preferences.formatter.FormatterTabPage;
import org.eclipse.cdt.internal.ui.preferences.formatter.ModifyDialog;
import org.eclipse.cdt.internal.ui.preferences.formatter.ModifyDialogTabPage;
import org.eclipse.cdt.internal.ui.preferences.formatter.TranslationUnitPreview;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;

public class LineWrappingTabPage
extends FormatterTabPage {
    private static final String PREF_CATEGORY_INDEX = "org.eclipse.cdt.uiformatter_page.line_wrapping_tab_page.last_category_index";
    protected static final String[] INDENT_NAMES = new String[]{FormatterMessages.LineWrappingTabPage_indentation_default, FormatterMessages.LineWrappingTabPage_indentation_on_column, FormatterMessages.LineWrappingTabPage_indentation_by_one};
    protected static final String[] WRAPPING_NAMES = new String[]{FormatterMessages.LineWrappingTabPage_splitting_do_not_split, FormatterMessages.LineWrappingTabPage_splitting_wrap_when_necessary, FormatterMessages.LineWrappingTabPage_splitting_always_wrap_first_others_when_necessary, FormatterMessages.LineWrappingTabPage_splitting_wrap_always, FormatterMessages.LineWrappingTabPage_splitting_wrap_always_indent_all_but_first, FormatterMessages.LineWrappingTabPage_splitting_wrap_always_except_first_only_if_necessary};
    private final Category fTypeDeclarationBaseClauseCategory = new Category("org.eclipse.cdt.core.formatter.alignment_for_base_clause_in_type_declaration", "class Example : public FooClass, virtual protected BarClass {};", FormatterMessages.LineWrappingTabPage_base_clause, FormatterMessages.LineWrappingTabPage_base_clause_lowercase);
    private final Category fMethodDeclarationsParametersCategory = new Category("org.eclipse.cdt.core.formatter.alignment_for_parameters_in_method_declaration", "class Example {void foo(int arg1, int arg2, int arg3, int arg4, int arg5, int arg6) {}};", FormatterMessages.LineWrappingTabPage_parameters, FormatterMessages.LineWrappingTabPage_parameters_lowercase);
    private final Category fMessageSendArgumentsCategory = new Category("org.eclipse.cdt.core.formatter.alignment_for_arguments_in_method_invocation", "class Other {static void bar(int arg1, int arg2, int arg3, int arg4, int arg5, int arg6, int arg7, int arg8, int arg9) {}};void foo() {Other::bar(100, 200, 300, 400, 500, 600, 700, 800, 900);}", FormatterMessages.LineWrappingTabPage_arguments, FormatterMessages.LineWrappingTabPage_arguments_lowercase);
    private final Category fMethodThrowsClauseCategory = new Category("org.eclipse.cdt.core.formatter.alignment_for_throws_clause_in_method_declaration", "class Example {int foo() throw(FirstException, SecondException, ThirdException) {  return Other::doSomething();}};", FormatterMessages.LineWrappingTabPage_throws_clause, FormatterMessages.LineWrappingTabPage_throws_clause_lowercase);
    private final Category fLambdaCategory = new Category("org.eclipse.cdt.core.formatter.alignment_for_lambda_expression", "int foo() {  auto f = [](){for(int c1 = 0; c1 < 3; c1 ++) {\n\t\t\tfor(int i = 0; i < 5; i ++) {\n\t\t\t\tfor(int c2 = 0; c2 < 3; c2 ++) {\n\t\t\t\t}\n\t\t\t}\n\t\t}};}", FormatterMessages.LineWrappingTabPage_lambda_expression, FormatterMessages.LineWrappingTabPage_lambda_expression_lowercase);
    private final Category fConstructorInitializerListCategory = new Category("org.eclipse.cdt.core.formatter.alignment_for_constructor_initializer_list", "class Point {public:Point(double x, double y) : x(x), y(y) {}\n\nprivate:double x;double y;};", FormatterMessages.LineWrappingTabPage_constructor_initializer_list, FormatterMessages.LineWrappingTabPage_constructor_initializer_list_lowercase);
    private final Category fInitializerListExpressionsCategory = new Category("org.eclipse.cdt.core.formatter.alignment_for_expressions_in_array_initializer", "int array[]= {1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17};", FormatterMessages.LineWrappingTabPage_initializer_list, FormatterMessages.LineWrappingTabPage_initializer_list_lowercase);
    private final Category fConditionalExpressionCategory = new Category("org.eclipse.cdt.core.formatter.alignment_for_conditional_expression", "int compare(int argument, int argument2) {return argument > argument2 ? 100000 : 200000;}", FormatterMessages.LineWrappingTabPage_conditionals, FormatterMessages.LineWrappingTabPage_conditionals_lowercase);
    private final Category fBinaryExpressionCategory = new Category("org.eclipse.cdt.core.formatter.alignment_for_binary_expression", "int foo() {  int sum= 100 + 200 + 300 + 400 + 500 + 600 + 700 + 800;  int product= 1 * 2 * 3 * 4 * 5 * 6 * 7 * 8 * 9 * 10;  bool val= true && false && true && false && true;  return product / sum;}", FormatterMessages.LineWrappingTabPage_binary_exprs, FormatterMessages.LineWrappingTabPage_binary_exprs_lowercase);
    private final Category fMemberAccessExpressionCategory = new Category("org.eclipse.cdt.core.formatter.alignment_for_member_access", "class TreeNode {public:TreeNode* getParent();TreeNode* getFirstChild();};\n\nTreeNode* firstUncle(TreeNode& node) {return node.getParent()->getParent()->getFirstChild();}", FormatterMessages.LineWrappingTabPage_member_access, FormatterMessages.LineWrappingTabPage_member_access_lowercase);
    private final Category fStreamOutputExpressionCategory = new Category("org.eclipse.cdt.core.formatter.alignment_for_overloaded_left_shift_chain", "namespace std {\nclass ostream {\n    ostream& operator<<(int);\n    ostream& operator<<(char);\n    ostream& operator<<(const char*);\n};\nint setfill(char);\nint setw(int);\nextern char endl;\nextern ostream cout;\n}", "#include <iostream>\n#include <iomanip>\n\nusing namespace std;\n\nvoid PrintDate(int year, int month, int day) {cout << setfill('0') << setw(4) << year << '/' << setw(2) << month << '/' << setw(2) << day << endl;}", FormatterMessages.LineWrappingTabPage_stream_output, FormatterMessages.LineWrappingTabPage_stream_output_lowercase);
    private final Category fEnumeratorsCategory = new Category("org.eclipse.cdt.core.formatter.alignment_for_enumerator_list", "enum Example {CANCELLED, RUNNING, WAITING, FINISHED };", FormatterMessages.LineWrappingTabPage_enumerator_list, FormatterMessages.LineWrappingTabPage_enumerator_list_lowercase);
    private final Category fAssignmentCategory = new Category("org.eclipse.cdt.core.formatter.alignment_for_assignment", "static char* string = \"text text text text\";class Example {void foo() {for (int i = 0; i < 10; i++) {}const char* character_string;character_string = \"text text text text\";}}", FormatterMessages.LineWrappingTabPage_assignment_alignment, FormatterMessages.LineWrappingTabPage_assignment_alignment_lowercase);
    private static int DEFAULT_PREVIEW_WINDOW_LINE_WIDTH = 40;
    private static final String PREF_PREVIEW_LINE_WIDTH = "org.eclipse.cdt.ui.codeformatter.line_wrapping_tab_page.preview_line_width";
    protected final IDialogSettings fDialogSettings = CUIPlugin.getDefault().getDialogSettings();
    protected TreeViewer fCategoriesViewer;
    protected Label fWrappingStylePolicy;
    protected Combo fWrappingStyleCombo;
    protected Label fIndentStylePolicy;
    protected Combo fIndentStyleCombo;
    protected Button fForceSplit;
    protected TranslationUnitPreview fPreview;
    protected Group fOptionsGroup;
    private final List<Category> fCategories;
    protected final CategoryListener fCategoryListener;
    protected IStructuredSelection fSelection;
    SelectionState fSelectionState;
    protected final Map<String, String> fPreviewPreferences;
    private final String LINE_SPLIT = "org.eclipse.cdt.core.formatter.lineSplit";

    public LineWrappingTabPage(ModifyDialog modifyDialog, Map<String, String> workingValues) {
        super(modifyDialog, workingValues);
        String previewLineWidth = this.fDialogSettings.get(PREF_PREVIEW_LINE_WIDTH);
        this.fPreviewPreferences = new HashMap<String, String>();
        this.fPreviewPreferences.put("org.eclipse.cdt.core.formatter.lineSplit", previewLineWidth != null ? previewLineWidth : String.valueOf(DEFAULT_PREVIEW_WINDOW_LINE_WIDTH));
        this.fCategories = this.createCategories();
        this.fCategoryListener = new CategoryListener(this.fCategories);
    }

    protected List<Category> createCategories() {
        Category classDeclarations = new Category(FormatterMessages.LineWrappingTabPage_class_decls, FormatterMessages.LineWrappingTabPage_class_decls_lowercase);
        classDeclarations.children.add(this.fTypeDeclarationBaseClauseCategory);
        Category methodDeclarations = new Category(null, null, FormatterMessages.LineWrappingTabPage_function_decls, FormatterMessages.LineWrappingTabPage_function_decls_lowercase);
        methodDeclarations.children.add(this.fMethodDeclarationsParametersCategory);
        methodDeclarations.children.add(this.fMethodThrowsClauseCategory);
        methodDeclarations.children.add(this.fConstructorInitializerListCategory);
        methodDeclarations.children.add(this.fLambdaCategory);
        Category enumDeclarations = new Category(FormatterMessages.LineWrappingTabPage_enum_decls, FormatterMessages.LineWrappingTabPage_enum_decls_lowercase);
        enumDeclarations.children.add(this.fEnumeratorsCategory);
        Category functionCalls = new Category(FormatterMessages.LineWrappingTabPage_function_calls, FormatterMessages.LineWrappingTabPage_function_calls_lowercase);
        functionCalls.children.add(this.fMessageSendArgumentsCategory);
        Category expressions = new Category(FormatterMessages.LineWrappingTabPage_expressions, FormatterMessages.LineWrappingTabPage_expressions_lowercase);
        expressions.children.add(this.fBinaryExpressionCategory);
        expressions.children.add(this.fConditionalExpressionCategory);
        expressions.children.add(this.fAssignmentCategory);
        expressions.children.add(this.fInitializerListExpressionsCategory);
        expressions.children.add(this.fStreamOutputExpressionCategory);
        expressions.children.add(this.fMemberAccessExpressionCategory);
        ArrayList<Category> root = new ArrayList<Category>();
        root.add(classDeclarations);
        root.add(methodDeclarations);
        root.add(enumDeclarations);
        root.add(functionCalls);
        root.add(expressions);
        return root;
    }

    @Override
    protected void doCreatePreferences(Composite composite, int numColumns) {
        Group lineWidthGroup = this.createGroup(numColumns, composite, FormatterMessages.LineWrappingTabPage_width_indent);
        this.createNumberPref((Composite)lineWidthGroup, numColumns, FormatterMessages.LineWrappingTabPage_width_indent_option_max_line_width, "org.eclipse.cdt.core.formatter.lineSplit", 0, 9999);
        this.createNumberPref((Composite)lineWidthGroup, numColumns, FormatterMessages.LineWrappingTabPage_width_indent_option_default_indent_wrapped, "org.eclipse.cdt.core.formatter.continuation_indentation", 0, 9999);
        this.createNumberPref((Composite)lineWidthGroup, numColumns, FormatterMessages.LineWrappingTabPage_width_indent_option_default_indent_array, "org.eclipse.cdt.core.formatter.continuation_indentation_for_array_initializer", 0, 9999);
        this.createCheckboxPref((Composite)lineWidthGroup, numColumns, FormatterMessages.LineWrappingTabPage_do_not_join_lines, "org.eclipse.cdt.core.formatter.join_wrapped_lines", TRUE_FALSE);
        this.fCategoriesViewer = new TreeViewer(composite, 2570);
        this.fCategoriesViewer.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public Object[] getElements(Object inputElement) {
                return ((Collection)inputElement).toArray();
            }

            public Object[] getChildren(Object parentElement) {
                return ((Category)parentElement).children.toArray();
            }

            public Object getParent(Object element) {
                return null;
            }

            public boolean hasChildren(Object element) {
                return !((Category)element).children.isEmpty();
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }
        });
        this.fCategoriesViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.fCategoriesViewer.setInput(this.fCategories);
        this.fCategoriesViewer.setExpandedElements(this.fCategories.toArray());
        GridData gd = LineWrappingTabPage.createGridData(numColumns, 1808, -1);
        this.fCategoriesViewer.getControl().setLayoutData((Object)gd);
        this.fOptionsGroup = this.createGroup(numColumns, composite, "");
        this.fWrappingStylePolicy = LineWrappingTabPage.createLabel(numColumns, (Composite)this.fOptionsGroup, FormatterMessages.LineWrappingTabPage_wrapping_policy_label_text);
        this.fWrappingStyleCombo = new Combo((Composite)this.fOptionsGroup, 12);
        this.fWrappingStyleCombo.setItems(WRAPPING_NAMES);
        this.fWrappingStyleCombo.setLayoutData((Object)LineWrappingTabPage.createGridData(numColumns, 256, 0));
        this.fForceSplit = new Button((Composite)this.fOptionsGroup, 32);
        this.fForceSplit.setLayoutData((Object)LineWrappingTabPage.createGridData(numColumns, 256, 0));
        this.fForceSplit.setText(FormatterMessages.LineWrappingTabPage_force_split_checkbox_text);
        this.fIndentStylePolicy = LineWrappingTabPage.createLabel(numColumns, (Composite)this.fOptionsGroup, FormatterMessages.LineWrappingTabPage_indentation_policy_label_text);
        this.fIndentStyleCombo = new Combo((Composite)this.fOptionsGroup, 12);
        this.fIndentStyleCombo.setItems(INDENT_NAMES);
        this.fIndentStyleCombo.setLayoutData((Object)LineWrappingTabPage.createGridData(numColumns, 256, 0));
        this.fSelectionState = new SelectionState();
    }

    @Override
    protected Composite doCreatePreviewPane(Composite composite, int numColumns) {
        super.doCreatePreviewPane(composite, numColumns);
        ModifyDialogTabPage.NumberPreference previewLineWidth = new ModifyDialogTabPage.NumberPreference(this, composite, numColumns / 2, this.fPreviewPreferences, "org.eclipse.cdt.core.formatter.lineSplit", 0, 9999, FormatterMessages.LineWrappingTabPage_line_width_for_preview_label_text);
        this.fDefaultFocusManager.add(previewLineWidth);
        previewLineWidth.addObserver(this.fUpdater);
        previewLineWidth.addObserver(new Observer(){

            @Override
            public void update(Observable o, Object arg) {
                LineWrappingTabPage.this.fDialogSettings.put(LineWrappingTabPage.PREF_PREVIEW_LINE_WIDTH, LineWrappingTabPage.this.fPreviewPreferences.get("org.eclipse.cdt.core.formatter.lineSplit"));
            }
        });
        Label label = new Label(composite, 64);
        label.setText(FormatterMessages.LineWrappingTabPage_line_width_for_preview_label_unit_text);
        return composite;
    }

    @Override
    protected CPreview doCreateCPreview(Composite parent) {
        this.fPreview = new TranslationUnitPreview(this.fWorkingValues, parent);
        return this.fPreview;
    }

    @Override
    protected void initializePage() {
        this.fCategoriesViewer.addSelectionChangedListener((ISelectionChangedListener)this.fCategoryListener);
        this.fCategoriesViewer.addDoubleClickListener((IDoubleClickListener)this.fCategoryListener);
        this.fForceSplit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LineWrappingTabPage.this.forceSplitChanged(LineWrappingTabPage.this.fForceSplit.getSelection());
            }
        });
        this.fIndentStyleCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LineWrappingTabPage.this.indentStyleChanged(((Combo)e.widget).getSelectionIndex());
            }
        });
        this.fWrappingStyleCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LineWrappingTabPage.this.wrappingStyleChanged(((Combo)e.widget).getSelectionIndex());
            }
        });
        this.fCategoryListener.restoreSelection();
        this.fDefaultFocusManager.add(this.fCategoriesViewer.getControl());
        this.fDefaultFocusManager.add((Control)this.fWrappingStyleCombo);
        this.fDefaultFocusManager.add((Control)this.fIndentStyleCombo);
        this.fDefaultFocusManager.add((Control)this.fForceSplit);
    }

    @Override
    protected void doUpdatePreview() {
        String normalSetting = (String)this.fWorkingValues.get("org.eclipse.cdt.core.formatter.lineSplit");
        this.fWorkingValues.put("org.eclipse.cdt.core.formatter.lineSplit", this.fPreviewPreferences.get("org.eclipse.cdt.core.formatter.lineSplit"));
        this.fPreview.update();
        this.fWorkingValues.put("org.eclipse.cdt.core.formatter.lineSplit", normalSetting);
    }

    void setPreviewText(String text) {
        this.setPreviewText(text, 0);
    }

    void setPreviewText(String text, int offset) {
        String normalSetting = (String)this.fWorkingValues.get("org.eclipse.cdt.core.formatter.lineSplit");
        this.fWorkingValues.put("org.eclipse.cdt.core.formatter.lineSplit", this.fPreviewPreferences.get("org.eclipse.cdt.core.formatter.lineSplit"));
        this.fPreview.setPreviewText(text, offset);
        this.fWorkingValues.put("org.eclipse.cdt.core.formatter.lineSplit", normalSetting);
    }

    protected void forceSplitChanged(boolean forceSplit) {
        Iterator<Category> iterator = this.fSelectionState.fElements.iterator();
        while (iterator.hasNext()) {
            String currentKey = iterator.next().key;
            try {
                this.changeForceSplit(currentKey, forceSplit);
            }
            catch (IllegalArgumentException e) {
                this.fWorkingValues.put(currentKey, DefaultCodeFormatterConstants.createAlignmentValue((boolean)forceSplit, (int)0, (int)0));
                CUIPlugin.log((IStatus)new Status(4, CUIPlugin.getPluginId(), 0, Messages.format(FormatterMessages.LineWrappingTabPage_error_invalid_value, currentKey), (Throwable)e));
            }
        }
        this.fSelectionState.refreshState(this.fSelection);
    }

    private void changeForceSplit(String currentKey, boolean forceSplit) throws IllegalArgumentException {
        String value = (String)this.fWorkingValues.get(currentKey);
        if ((value = DefaultCodeFormatterConstants.setForceWrapping((String)value, (boolean)forceSplit)) == null) {
            throw new IllegalArgumentException();
        }
        this.fWorkingValues.put(currentKey, value);
    }

    protected void wrappingStyleChanged(int wrappingStyle) {
        Iterator<Category> iterator = this.fSelectionState.fElements.iterator();
        while (iterator.hasNext()) {
            String currentKey = iterator.next().key;
            try {
                this.changeWrappingStyle(currentKey, wrappingStyle);
            }
            catch (IllegalArgumentException e) {
                this.fWorkingValues.put(currentKey, DefaultCodeFormatterConstants.createAlignmentValue((boolean)false, (int)wrappingStyle, (int)0));
                CUIPlugin.log((IStatus)new Status(4, CUIPlugin.getPluginId(), 0, Messages.format(FormatterMessages.LineWrappingTabPage_error_invalid_value, currentKey), (Throwable)e));
            }
        }
        this.fSelectionState.refreshState(this.fSelection);
    }

    private void changeWrappingStyle(String currentKey, int wrappingStyle) throws IllegalArgumentException {
        String value = (String)this.fWorkingValues.get(currentKey);
        if ((value = DefaultCodeFormatterConstants.setWrappingStyle((String)value, (int)wrappingStyle)) == null) {
            throw new IllegalArgumentException();
        }
        this.fWorkingValues.put(currentKey, value);
    }

    protected void indentStyleChanged(int indentStyle) {
        Iterator<Category> iterator = this.fSelectionState.fElements.iterator();
        while (iterator.hasNext()) {
            String currentKey = iterator.next().key;
            try {
                this.changeIndentStyle(currentKey, indentStyle);
            }
            catch (IllegalArgumentException e) {
                this.fWorkingValues.put(currentKey, DefaultCodeFormatterConstants.createAlignmentValue((boolean)false, (int)0, (int)indentStyle));
                CUIPlugin.log((IStatus)new Status(4, "org.eclipse.cdt.ui", 0, Messages.format(FormatterMessages.LineWrappingTabPage_error_invalid_value, currentKey), (Throwable)e));
            }
        }
        this.fSelectionState.refreshState(this.fSelection);
    }

    private void changeIndentStyle(String currentKey, int indentStyle) throws IllegalArgumentException {
        String value = (String)this.fWorkingValues.get(currentKey);
        if ((value = DefaultCodeFormatterConstants.setIndentStyle((String)value, (int)indentStyle)) == null) {
            throw new IllegalArgumentException();
        }
        this.fWorkingValues.put(currentKey, value);
    }

    protected void updateControlEnablement(boolean inhomogenous, int wrappingStyle) {
        boolean doSplit = wrappingStyle != 0;
        this.fIndentStylePolicy.setEnabled(true);
        this.fIndentStyleCombo.setEnabled(inhomogenous || doSplit);
        this.fForceSplit.setEnabled(inhomogenous || doSplit);
    }

    private static final class Category {
        public final String key;
        public final String name;
        public final String previewText;
        public final String prologue;
        public final String description;
        public final List<Category> children;
        public int index;

        public Category(String key, String prologue, String previewText, String name, String description) {
            this.key = key;
            this.name = name;
            this.prologue = prologue;
            this.previewText = previewText != null ? LineWrappingTabPage.createPreviewHeader(name) + previewText : null;
            this.description = description;
            this.children = new ArrayList<Category>();
        }

        public Category(String key, String previewText, String name, String description) {
            this(key, null, previewText, name, description);
        }

        public Category(String name, String description) {
            this(null, null, name, description);
        }

        public String toString() {
            return this.name;
        }
    }

    private final class CategoryListener
    implements ISelectionChangedListener,
    IDoubleClickListener {
        private final List<Category> fCategoriesList = new ArrayList<Category>();
        private int fIndex = 0;

        public CategoryListener(List<Category> categoriesTree) {
            this.flatten(this.fCategoriesList, categoriesTree);
        }

        private void flatten(List<Category> categoriesList, List<Category> categoriesTree) {
            Iterator<Category> iterator = categoriesTree.iterator();
            while (iterator.hasNext()) {
                Category category2;
                Category category = category2 = iterator.next();
                ++this.fIndex;
                category.index = category.index;
                categoriesList.add(category);
                this.flatten(categoriesList, category.children);
            }
        }

        public void selectionChanged(SelectionChangedEvent event) {
            if (event != null) {
                LineWrappingTabPage.this.fSelection = (IStructuredSelection)event.getSelection();
            }
            if (LineWrappingTabPage.this.fSelection.size() == 0) {
                this.disableAll();
                return;
            }
            if (!LineWrappingTabPage.this.fOptionsGroup.isEnabled()) {
                this.enableDefaultComponents(true);
            }
            LineWrappingTabPage.this.fSelectionState.refreshState(LineWrappingTabPage.this.fSelection);
            Category category = (Category)LineWrappingTabPage.this.fSelection.getFirstElement();
            LineWrappingTabPage.this.fDialogSettings.put(LineWrappingTabPage.PREF_CATEGORY_INDEX, category.index);
            LineWrappingTabPage.this.fOptionsGroup.setText(this.getGroupLabel(category));
        }

        private String getGroupLabel(Category category) {
            if (LineWrappingTabPage.this.fSelection.size() == 1) {
                if (LineWrappingTabPage.this.fSelectionState.getElements().size() == 1) {
                    return NLS.bind((String)FormatterMessages.LineWrappingTabPage_group, (Object)category.description);
                }
                return NLS.bind((String)FormatterMessages.LineWrappingTabPage_multi_group, (Object)category.description, (Object)String.valueOf(LineWrappingTabPage.this.fSelectionState.getElements().size()));
            }
            return NLS.bind((String)FormatterMessages.LineWrappingTabPage_multiple_selections, (Object)String.valueOf(LineWrappingTabPage.this.fSelectionState.getElements().size()));
        }

        private void disableAll() {
            this.enableDefaultComponents(false);
            LineWrappingTabPage.this.fIndentStyleCombo.setEnabled(false);
            LineWrappingTabPage.this.fForceSplit.setEnabled(false);
        }

        private void enableDefaultComponents(boolean enabled) {
            LineWrappingTabPage.this.fOptionsGroup.setEnabled(enabled);
            LineWrappingTabPage.this.fWrappingStyleCombo.setEnabled(enabled);
            LineWrappingTabPage.this.fWrappingStylePolicy.setEnabled(enabled);
        }

        public void restoreSelection() {
            int index;
            try {
                index = LineWrappingTabPage.this.fDialogSettings.getInt(LineWrappingTabPage.PREF_CATEGORY_INDEX);
            }
            catch (NumberFormatException e) {
                index = -1;
            }
            if (index < 0 || index > this.fCategoriesList.size() - 1) {
                index = 1;
            }
            Category category = this.fCategoriesList.get(index);
            LineWrappingTabPage.this.fCategoriesViewer.setSelection((ISelection)new StructuredSelection((Object[])new Category[]{category}));
        }

        public void doubleClick(DoubleClickEvent event) {
            ISelection selection = event.getSelection();
            if (selection instanceof IStructuredSelection) {
                Category node = (Category)((IStructuredSelection)selection).getFirstElement();
                LineWrappingTabPage.this.fCategoriesViewer.setExpandedState((Object)node, !LineWrappingTabPage.this.fCategoriesViewer.getExpandedState((Object)node));
            }
        }
    }

    private class SelectionState {
        private List<Category> fElements = new ArrayList<Category>();

        private SelectionState() {
        }

        public void refreshState(IStructuredSelection selection) {
            HashMap<Object, Integer> wrappingStyleMap = new HashMap<Object, Integer>();
            HashMap<Object, Integer> indentStyleMap = new HashMap<Object, Integer>();
            HashMap<Object, Integer> forceWrappingMap = new HashMap<Object, Integer>();
            this.fElements.clear();
            this.evaluateElements(selection.iterator());
            this.evaluateMaps(wrappingStyleMap, indentStyleMap, forceWrappingMap);
            this.evaluatePreviewText();
            this.refreshControls(wrappingStyleMap, indentStyleMap, forceWrappingMap);
        }

        public List<Category> getElements() {
            return this.fElements;
        }

        private void evaluateElements(Iterator<?> iterator) {
            while (iterator.hasNext()) {
                Object next = iterator.next();
                if (!(next instanceof Category)) continue;
                Category category = (Category)next;
                String value = (String)LineWrappingTabPage.this.fWorkingValues.get(category.key);
                if (value != null) {
                    if (this.fElements.contains(category)) continue;
                    this.fElements.add(category);
                    continue;
                }
                this.evaluateElements(category.children.iterator());
            }
        }

        private void evaluateMaps(Map<Object, Integer> wrappingStyleMap, Map<Object, Integer> indentStyleMap, Map<Object, Integer> forceWrappingMap) {
            for (Category category : this.fElements) {
                this.insertIntoMap(wrappingStyleMap, indentStyleMap, forceWrappingMap, category);
            }
        }

        private void evaluatePreviewText() {
            StringBuilder previewText = new StringBuilder();
            for (Category category : this.fElements) {
                if (category.prologue == null) continue;
                previewText.append(category.prologue);
                previewText.append("\n\n");
            }
            int offset = previewText.length();
            for (Category category : this.fElements) {
                previewText.append(category.previewText);
                previewText.append("\n\n");
            }
            LineWrappingTabPage.this.setPreviewText(previewText.toString(), offset);
        }

        private void insertIntoMap(Map<Object, Integer> wrappingMap, Map<Object, Integer> indentMap, Map<Object, Integer> forceMap, Category category) {
            Boolean forceWrapping;
            Integer indentStyle;
            Integer wrappingStyle;
            String value = (String)LineWrappingTabPage.this.fWorkingValues.get(category.key);
            try {
                wrappingStyle = DefaultCodeFormatterConstants.getWrappingStyle((String)value);
                indentStyle = DefaultCodeFormatterConstants.getIndentStyle((String)value);
                forceWrapping = DefaultCodeFormatterConstants.getForceWrapping((String)value);
            }
            catch (IllegalArgumentException e) {
                forceWrapping = Boolean.FALSE;
                indentStyle = 0;
                wrappingStyle = 0;
            }
            this.increaseMapEntry(wrappingMap, wrappingStyle);
            this.increaseMapEntry(indentMap, indentStyle);
            this.increaseMapEntry(forceMap, forceWrapping);
        }

        private void increaseMapEntry(Map<Object, Integer> map, Object type) {
            Integer count = map.get(type);
            if (count == null) {
                map.put(type, 1);
            } else {
                map.put(type, count + 1);
            }
        }

        private void refreshControls(Map<Object, Integer> wrappingStyleMap, Map<Object, Integer> indentStyleMap, Map<Object, Integer> forceWrappingMap) {
            this.updateCombos(wrappingStyleMap, indentStyleMap);
            this.updateButton(forceWrappingMap);
            Integer wrappingStyleMax = this.getWrappingStyleMax(wrappingStyleMap);
            boolean isInhomogeneous = this.fElements.size() != wrappingStyleMap.get(wrappingStyleMax).intValue();
            LineWrappingTabPage.this.updateControlEnablement(isInhomogeneous, wrappingStyleMax);
            LineWrappingTabPage.this.doUpdatePreview();
            LineWrappingTabPage.this.notifyValuesModified();
        }

        private Integer getWrappingStyleMax(Map<Object, Integer> wrappingStyleMap) {
            int maxCount = 0;
            int maxStyle = 0;
            int i = 0;
            while (i < WRAPPING_NAMES.length) {
                Integer count = wrappingStyleMap.get(i);
                if (count != null && count > maxCount) {
                    maxCount = count;
                    maxStyle = i;
                }
                ++i;
            }
            return maxStyle;
        }

        private void updateButton(Map<Object, Integer> forceWrappingMap) {
            Integer nrOfTrue = forceWrappingMap.get(Boolean.TRUE);
            Integer nrOfFalse = forceWrappingMap.get(Boolean.FALSE);
            if (nrOfTrue == null || nrOfFalse == null) {
                LineWrappingTabPage.this.fForceSplit.setSelection(nrOfTrue != null);
            } else {
                LineWrappingTabPage.this.fForceSplit.setSelection(nrOfTrue > nrOfFalse);
            }
            int max = this.getMax(nrOfTrue, nrOfFalse);
            String label = FormatterMessages.LineWrappingTabPage_force_split_checkbox_multi_text;
            LineWrappingTabPage.this.fForceSplit.setText(this.getLabelText(label, max, this.fElements.size()));
        }

        private String getLabelText(String label, int count, int nElements) {
            if (nElements == 1 || count == 0) {
                return label;
            }
            return Messages.format(FormatterMessages.LineWrappingTabPage_occurences, new String[]{label, String.valueOf(count), String.valueOf(nElements)});
        }

        private int getMax(Integer nrOfTrue, Integer nrOfFalse) {
            if (nrOfTrue == null) {
                return nrOfFalse;
            }
            if (nrOfFalse == null) {
                return nrOfTrue;
            }
            if (nrOfTrue.compareTo(nrOfFalse) >= 0) {
                return nrOfTrue;
            }
            return nrOfFalse;
        }

        private void updateCombos(Map<Object, Integer> wrappingStyleMap, Map<Object, Integer> indentStyleMap) {
            this.updateCombo(LineWrappingTabPage.this.fWrappingStyleCombo, wrappingStyleMap, WRAPPING_NAMES);
            this.updateCombo(LineWrappingTabPage.this.fIndentStyleCombo, indentStyleMap, INDENT_NAMES);
        }

        private void updateCombo(Combo combo, Map<Object, Integer> map, String[] items) {
            String[] newItems = new String[items.length];
            int maxCount = 0;
            int maxStyle = 0;
            int i = 0;
            while (i < items.length) {
                int val;
                Integer count = map.get(i);
                int n = val = count == null ? 0 : count;
                if (val > maxCount) {
                    maxCount = val;
                    maxStyle = i;
                }
                newItems[i] = this.getLabelText(items[i], val, this.fElements.size());
                ++i;
            }
            combo.setItems(newItems);
            combo.setText(newItems[maxStyle]);
        }
    }
}

