/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.lsp;

import java.util.Objects;
import java.util.Optional;
import org.eclipse.cdt.lsp.config.ConfigurationMetadata;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.PreferenceMetadata;

public abstract class PreferredOptions {
    protected final ConfigurationMetadata metadata;
    protected final String qualifier;
    protected final IScopeContext[] scopes;

    public PreferredOptions(ConfigurationMetadata metadata, String qualifier, IScopeContext[] scopes) {
        this.metadata = Objects.requireNonNull(metadata);
        this.qualifier = Objects.requireNonNull(qualifier);
        this.scopes = Objects.requireNonNull(scopes);
    }

    private String commonValue(PreferenceMetadata<?> meta) {
        String actual = String.valueOf(meta.defaultValue());
        int i = this.scopes.length - 1;
        while (i >= 0) {
            IScopeContext scope = this.scopes[i];
            String previous = actual;
            actual = scope.getNode(this.qualifier).get(meta.identifer(), previous);
            --i;
        }
        return actual;
    }

    protected final boolean booleanValue(PreferenceMetadata<Boolean> predefined) {
        PreferenceMetadata<Boolean> customized = this.metadata.defined(predefined.identifer(), Boolean.class).orElse(predefined);
        return Optional.of(customized).map(this::commonValue).map(Boolean::valueOf).orElseGet(() -> customized.defaultValue());
    }

    protected final String stringValue(PreferenceMetadata<String> predefined) {
        PreferenceMetadata<String> customized = this.metadata.defined(predefined.identifer(), String.class).orElse(predefined);
        return Optional.of(customized).map(this::commonValue).orElseGet(() -> customized.defaultValue());
    }
}

