/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.core;

import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.internal.tasks.core.Category;
import org.eclipse.mylyn.internal.tasks.core.IRepositoryChangeListener;
import org.eclipse.mylyn.internal.tasks.core.LocalTask;
import org.eclipse.mylyn.internal.tasks.core.TaskRepositoriesExternalizer;
import org.eclipse.mylyn.internal.tasks.core.TaskRepositoryChangeEvent;
import org.eclipse.mylyn.internal.tasks.core.TaskRepositoryDelta;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryMigrator;
import org.eclipse.mylyn.tasks.core.IRepositoryListener;
import org.eclipse.mylyn.tasks.core.IRepositoryManager;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.TaskRepository;

public class TaskRepositoryManager
implements IRepositoryManager {
    public static final String OLD_REPOSITORIES_FILE = "repositories.xml";
    public static final String DEFAULT_REPOSITORIES_FILE = "repositories.xml.zip";
    public static final String PREF_REPOSITORIES = "org.eclipse.mylyn.tasklist.repositories.";
    private final Map<String, AbstractRepositoryConnector> repositoryConnectors = new HashMap<String, AbstractRepositoryConnector>();
    private final Map<String, Set<TaskRepository>> repositoryMap = new HashMap<String, Set<TaskRepository>>();
    private final Set<IRepositoryListener> listeners = new CopyOnWriteArraySet<IRepositoryListener>();
    private final Set<TaskRepository> orphanedRepositories = new HashSet<TaskRepository>();
    public static final String PREFIX_LOCAL = "local-";
    private static final Map<String, Category> repositoryCategories = new HashMap<String, Category>();
    private final PropertyChangeListener PROPERTY_CHANGE_LISTENER = evt -> this.notifyRepositorySettingsChanged((TaskRepository)((Object)((Object)evt.getSource())), new TaskRepositoryDelta(TaskRepositoryDelta.Type.PROPERTY, evt.getPropertyName()));
    private final TaskRepositoriesExternalizer externalizer = new TaskRepositoriesExternalizer();
    private List<AbstractRepositoryMigrator> migrators = Collections.emptyList();

    public TaskRepositoryManager() {
        Category catTasks = new Category("org.eclipse.mylyn.category.tasks", "Tasks", 0);
        repositoryCategories.put(catTasks.getId(), catTasks);
        Category catBugs = new Category("org.eclipse.mylyn.category.bugs", "Bugs", 100);
        repositoryCategories.put(catBugs.getId(), catBugs);
        Category catBuild = new Category("org.eclipse.mylyn.category.build", "Builds", 200);
        repositoryCategories.put(catBuild.getId(), catBuild);
        Category catReview = new Category("org.eclipse.mylyn.category.review", "Reviews", 300);
        repositoryCategories.put(catReview.getId(), catReview);
        Category catOther = new Category("org.eclipse.mylyn.category.other", "Other", 400);
        repositoryCategories.put(catOther.getId(), catOther);
    }

    @Override
    public synchronized Collection<AbstractRepositoryConnector> getRepositoryConnectors() {
        return new ArrayList<AbstractRepositoryConnector>(this.repositoryConnectors.values());
    }

    @Override
    public synchronized AbstractRepositoryConnector getRepositoryConnector(String connectorKind) {
        return this.repositoryConnectors.get(connectorKind);
    }

    public synchronized AbstractRepositoryConnector removeRepositoryConnector(String connectorKind) {
        return this.repositoryConnectors.remove(connectorKind);
    }

    public synchronized void addRepositoryConnector(AbstractRepositoryConnector repositoryConnector) {
        if (!this.repositoryConnectors.containsValue(repositoryConnector)) {
            this.repositoryConnectors.put(repositoryConnector.getConnectorKind(), repositoryConnector);
        }
    }

    public synchronized boolean hasUserManagedRepositoryConnectors() {
        for (AbstractRepositoryConnector connector : this.repositoryConnectors.values()) {
            if (!connector.isUserManaged()) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addRepository(final TaskRepository repository) {
        TaskRepositoryManager taskRepositoryManager = this;
        synchronized (taskRepositoryManager) {
            Set<TaskRepository> repositories = this.repositoryMap.get(repository.getConnectorKind());
            if (repositories == null) {
                repositories = new HashSet<TaskRepository>();
                this.repositoryMap.put(repository.getConnectorKind(), repositories);
            }
            if (!repositories.add(repository)) {
                return;
            }
            repository.addChangeListener(this.PROPERTY_CHANGE_LISTENER);
        }
        for (final IRepositoryListener listener : this.listeners) {
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void handleException(Throwable e) {
                    StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.core", "Listener failed: " + String.valueOf(listener.getClass()), e));
                }

                public void run() throws Exception {
                    listener.repositoryAdded(repository);
                }
            });
        }
    }

    @Deprecated
    public void removeRepository(TaskRepository repository, String repositoryFilePath) {
        this.removeRepository(repository);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRepository(final TaskRepository repository) {
        TaskRepositoryManager taskRepositoryManager = this;
        synchronized (taskRepositoryManager) {
            Set<TaskRepository> repositories = this.repositoryMap.get(repository.getConnectorKind());
            if (repositories == null || !repositories.remove((Object)repository)) {
                return;
            }
            repository.flushAuthenticationCredentials();
            repository.removeChangeListener(this.PROPERTY_CHANGE_LISTENER);
        }
        for (final IRepositoryListener listener : this.listeners) {
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void handleException(Throwable e) {
                    StatusHandler.log((IStatus)new Status(2, "org.eclipse.mylyn.tasks.core", "Listener failed: " + String.valueOf(listener.getClass()), e));
                }

                public void run() throws Exception {
                    listener.repositoryRemoved(repository);
                }
            });
        }
    }

    @Override
    public void addListener(IRepositoryListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(IRepositoryListener listener) {
        this.listeners.remove(listener);
    }

    public static String stripSlashes(String url) {
        Assert.isNotNull((Object)url);
        StringBuilder sb = new StringBuilder(url.trim());
        while (sb.length() > 0 && sb.charAt(sb.length() - 1) == '/') {
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }

    public Category getCategory(String id) {
        Category category = repositoryCategories.get("org.eclipse.mylyn.category.other");
        Category cat = repositoryCategories.get(id);
        if (cat != null) {
            category = cat;
        }
        return category;
    }

    public Collection<Category> getCategories() {
        return Collections.unmodifiableCollection(repositoryCategories.values());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TaskRepository getRepository(String kind, String urlString) {
        Assert.isNotNull((Object)kind);
        Assert.isNotNull((Object)urlString);
        urlString = TaskRepositoryManager.stripSlashes(urlString);
        TaskRepositoryManager taskRepositoryManager = this;
        synchronized (taskRepositoryManager) {
            if (this.repositoryMap.containsKey(kind)) {
                for (TaskRepository repository : this.repositoryMap.get(kind)) {
                    if (!TaskRepositoryManager.stripSlashes(repository.getRepositoryUrl()).equals(urlString)) continue;
                    return repository;
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TaskRepository getRepository(String urlString) {
        Assert.isNotNull((Object)urlString);
        urlString = TaskRepositoryManager.stripSlashes(urlString);
        TaskRepositoryManager taskRepositoryManager = this;
        synchronized (taskRepositoryManager) {
            for (String kind : this.repositoryMap.keySet()) {
                for (TaskRepository repository : this.repositoryMap.get(kind)) {
                    if (!TaskRepositoryManager.stripSlashes(repository.getRepositoryUrl()).equals(urlString)) continue;
                    return repository;
                }
            }
        }
        return null;
    }

    public AbstractRepositoryConnector getConnectorForRepositoryTaskUrl(String url) {
        Assert.isNotNull((Object)url);
        for (AbstractRepositoryConnector connector : this.getRepositoryConnectors()) {
            String repositoryUrl = connector.getRepositoryUrlFromTaskUrl(url);
            if (repositoryUrl == null) continue;
            for (TaskRepository repository : this.getRepositories(connector.getConnectorKind())) {
                if (!repositoryUrl.startsWith(repository.getRepositoryUrl())) continue;
                return connector;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<TaskRepository> getRepositories(String connectorKind) {
        Set<TaskRepository> result;
        Assert.isNotNull((Object)connectorKind);
        TaskRepositoryManager taskRepositoryManager = this;
        synchronized (taskRepositoryManager) {
            result = this.repositoryMap.get(connectorKind);
        }
        if (result == null) {
            return Collections.emptySet();
        }
        return new HashSet<TaskRepository>(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<TaskRepository> getAllRepositories() {
        ArrayList<TaskRepository> repositories = new ArrayList<TaskRepository>();
        TaskRepositoryManager taskRepositoryManager = this;
        synchronized (taskRepositoryManager) {
            for (AbstractRepositoryConnector repositoryConnector : this.repositoryConnectors.values()) {
                if (!this.repositoryMap.containsKey(repositoryConnector.getConnectorKind())) continue;
                repositories.addAll((Collection<TaskRepository>)this.repositoryMap.get(repositoryConnector.getConnectorKind()));
            }
        }
        return repositories;
    }

    @Deprecated
    public synchronized TaskRepository getDefaultRepository(String kind) {
        if (this.repositoryMap.containsKey(kind)) {
            Iterator<TaskRepository> iterator = this.repositoryMap.get(kind).iterator();
            if (iterator.hasNext()) {
                TaskRepository repository = iterator.next();
                return repository;
            }
        } else {
            Collection<Set<TaskRepository>> values = this.repositoryMap.values();
            if (!values.isEmpty()) {
                Set<TaskRepository> repoistorySet = values.iterator().next();
                return repoistorySet.iterator().next();
            }
        }
        return null;
    }

    Map<String, Set<TaskRepository>> readRepositories(String repositoriesFilePath) {
        this.repositoryMap.clear();
        this.orphanedRepositories.clear();
        this.loadRepositories(repositoriesFilePath);
        return this.repositoryMap;
    }

    private void loadRepositories(String repositoriesFilePath) {
        boolean migration = false;
        File repositoriesFile = new File(repositoriesFilePath);
        for (AbstractRepositoryConnector repositoryConnector : this.repositoryConnectors.values()) {
            this.repositoryMap.put(repositoryConnector.getConnectorKind(), new HashSet());
        }
        if (repositoriesFile.exists()) {
            Set<TaskRepository> repositories = this.externalizer.readRepositoriesFromXML(repositoriesFile);
            if (repositories != null && repositories.size() > 0) {
                for (TaskRepository repository : repositories) {
                    if (this.removeHttpAuthMigration(repository)) {
                        migration = true;
                    }
                    if (this.applyMigrators(repository)) {
                        migration = true;
                    }
                    if (this.repositoryMap.containsKey(repository.getConnectorKind())) {
                        this.repositoryMap.get(repository.getConnectorKind()).add(repository);
                        repository.addChangeListener(this.PROPERTY_CHANGE_LISTENER);
                        continue;
                    }
                    this.orphanedRepositories.add(repository);
                }
            }
            if (migration) {
                this.saveRepositories(repositoriesFilePath);
            }
        }
    }

    public boolean applyMigrators(final TaskRepository repository) {
        final boolean[] result = new boolean[1];
        for (AbstractRepositoryMigrator migrator : this.migrators) {
            if (!migrator.getConnectorKind().equals(repository.getConnectorKind())) continue;
            final AbstractRepositoryMigrator finalRepositoryMigrator = migrator;
            result[0] = false;
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void handleException(Throwable e) {
                    StatusHandler.log((IStatus)new Status(2, "org.eclipse.mylyn.tasks.core", "Repository migration failed for repository \"" + repository.getUrl() + "\"", e));
                }

                public void run() throws Exception {
                    if (finalRepositoryMigrator.migrateRepository(repository)) {
                        result[0] = true;
                    }
                }
            });
            break;
        }
        return result[0];
    }

    private boolean removeHttpAuthMigration(TaskRepository repository) {
        String httpusername = repository.getProperty("org.eclipse.mylyn.tasklist.repositories.httpauth.username");
        String httppassword = repository.getProperty("org.eclipse.mylyn.tasklist.repositories.httpauth.password");
        if (httpusername != null && httppassword != null) {
            repository.removeProperty("org.eclipse.mylyn.tasklist.repositories.httpauth.username");
            repository.removeProperty("org.eclipse.mylyn.tasklist.repositories.httpauth.password");
            if (httpusername.length() > 0 && httppassword.length() > 0) {
                repository.setHttpAuthenticationCredentials(httpusername, httppassword);
            }
            return true;
        }
        return false;
    }

    protected synchronized boolean saveRepositories(String destinationPath) {
        HashSet<TaskRepository> repositoriesToWrite = new HashSet<TaskRepository>(this.getAllRepositories());
        for (TaskRepository repository : this.orphanedRepositories) {
            if (repositoriesToWrite.contains((Object)repository)) continue;
            repositoriesToWrite.add(repository);
        }
        try {
            File repositoriesFile = new File(destinationPath);
            this.externalizer.writeRepositoriesToXML(repositoriesToWrite, repositoriesFile);
        }
        catch (Throwable t) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.core", "Could not save repositories", t));
            return false;
        }
        return true;
    }

    @Deprecated
    public void clearRepositories(String repositoriesFilePath) {
        this.clearRepositories();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearRepositories() {
        List<TaskRepository> repositories = this.getAllRepositories();
        for (TaskRepository repository : repositories) {
            this.removeRepository(repository);
        }
        TaskRepositoryManager taskRepositoryManager = this;
        synchronized (taskRepositoryManager) {
            this.repositoryMap.clear();
            this.orphanedRepositories.clear();
        }
    }

    public void notifyRepositorySettingsChanged(TaskRepository repository) {
        this.notifyRepositorySettingsChanged(repository, new TaskRepositoryDelta(TaskRepositoryDelta.Type.ALL));
    }

    public void notifyRepositorySettingsChanged(final TaskRepository repository, TaskRepositoryDelta delta) {
        final TaskRepositoryChangeEvent event = new TaskRepositoryChangeEvent(this, repository, delta);
        for (final IRepositoryListener listener : this.listeners) {
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void handleException(Throwable e) {
                    StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.core", "Listener failed: " + String.valueOf(listener.getClass()), e));
                }

                public void run() throws Exception {
                    if (listener instanceof IRepositoryChangeListener) {
                        ((IRepositoryChangeListener)((Object)listener)).repositoryChanged(event);
                    }
                    listener.repositorySettingsChanged(repository);
                }
            });
        }
    }

    @Deprecated
    public void insertRepositories(Set<TaskRepository> repositories, String repositoryFilePath) {
        for (TaskRepository repository : repositories) {
            if (this.getRepository(repository.getConnectorKind(), repository.getRepositoryUrl()) != null) continue;
            this.addRepository(repository);
        }
    }

    public boolean isOwnedByUser(ITask task) {
        TaskRepository repository;
        if (task instanceof LocalTask) {
            return true;
        }
        AbstractRepositoryConnector connector = this.getRepositoryConnector(task.getConnectorKind());
        if (connector != null && (repository = this.getRepository(task.getConnectorKind(), task.getRepositoryUrl())) != null) {
            return connector.isOwnedByUser(repository, task);
        }
        return false;
    }

    public void notifyRepositoryUrlChanged(final TaskRepository repository, final String oldUrl) {
        for (final IRepositoryListener listener : this.listeners) {
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void handleException(Throwable e) {
                    StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.core", "Listener failed: " + String.valueOf(listener.getClass()), e));
                }

                public void run() throws Exception {
                    listener.repositoryUrlChanged(repository, oldUrl);
                }
            });
        }
    }

    public Category getCategory(TaskRepository repository) {
        return this.getCategory(repository.getCategory());
    }

    public void initialize(List<AbstractRepositoryMigrator> repositoryMigrators) {
        this.migrators = repositoryMigrators;
    }
}

