/*
 * Decompiled with CFR 0.152.
 */
package de.pdark.decentxml;

import de.pdark.decentxml.Node;
import de.pdark.decentxml.XMLTokenizer;

public class XMLUtils {
    public static String escapeXMLText(String text) {
        if (text == null) {
            return null;
        }
        return text.replaceAll("&", "&amp;").replaceAll("<", "&lt;").replaceAll(">", "&gt;");
    }

    public static String unescapeXMLText(String text) {
        if (text == null) {
            return null;
        }
        return text.replaceAll("&amp;", "&").replaceAll("&lt;", "<").replaceAll("&gt;", ">");
    }

    public static String unescapeXMLAttributeValue(String text) {
        if (text == null) {
            return null;
        }
        return XMLUtils.unescapeXMLText(text).replaceAll("&quot;", "\"").replaceAll("&apos;", "'");
    }

    public static boolean isElement(Node n) {
        return n == null ? false : XMLUtils.isElementType(n.getType());
    }

    public static boolean isElementType(XMLTokenizer.Type t) {
        return t == XMLTokenizer.Type.ELEMENT || t == XMLTokenizer.Type.CUSTOM_ELEMENT;
    }

    public static boolean isAttribute(Node n) {
        return n == null ? false : XMLUtils.isAttributeType(n.getType());
    }

    public static boolean isAttributeType(XMLTokenizer.Type t) {
        return t == XMLTokenizer.Type.ATTRIBUTE || t == XMLTokenizer.Type.CUSTOM_ATTRIBUTE;
    }

    public static boolean isText(Node n) {
        return n == null ? false : XMLUtils.isTextType(n.getType());
    }

    public static boolean isTextType(XMLTokenizer.Type t) {
        return t == XMLTokenizer.Type.TEXT || t == XMLTokenizer.Type.CDATA || t == XMLTokenizer.Type.DTD_WHITESPACE;
    }
}

