/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tea.library.build.p2;

import java.io.File;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.equinox.frameworkadmin.BundleInfo;
import org.eclipse.equinox.internal.p2.publisher.eclipse.IProductDescriptor;
import org.eclipse.equinox.internal.provisional.frameworkadmin.ConfigData;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IVersionedId;
import org.eclipse.equinox.p2.publisher.IPublisherAction;
import org.eclipse.equinox.p2.publisher.IPublisherAdvice;
import org.eclipse.equinox.p2.publisher.IPublisherInfo;
import org.eclipse.equinox.p2.publisher.IPublisherResult;
import org.eclipse.equinox.p2.publisher.PublisherInfo;
import org.eclipse.equinox.p2.publisher.PublisherResult;
import org.eclipse.equinox.p2.publisher.eclipse.ConfigAdvice;
import org.eclipse.equinox.p2.publisher.eclipse.ProductAction;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.pde.internal.build.IPDEBuildConstants;
import org.eclipse.tea.library.build.p2.TeaApplicationLauncherAction;

public class TeaProductAction
extends ProductAction
implements IPDEBuildConstants {
    private final File platformExecutables;
    private final File overrideExecutables;

    public TeaProductAction(IProductDescriptor product, File executables, File overrideExecutables) {
        super(null, product, "tooling", executables);
        this.platformExecutables = executables;
        this.overrideExecutables = overrideExecutables;
    }

    public IStatus perform(IPublisherInfo info, IPublisherResult results, IProgressMonitor monitor) {
        PublisherResult innerResult = new PublisherResult();
        PublisherInfo innerInfo = new PublisherInfo();
        innerInfo.setConfigurations(info.getConfigurations());
        innerInfo.setArtifactOptions(info.getArtifactOptions());
        innerInfo.setArtifactRepository(info.getArtifactRepository());
        innerInfo.setMetadataRepository(info.getMetadataRepository());
        innerInfo.setContextArtifactRepository(info.getContextArtifactRepository());
        innerInfo.setContextMetadataRepository(info.getContextMetadataRepository());
        Map<String, BundleInfo> defaultBundles = TeaProductAction.getDefaultBundles();
        Map<String, BundleInfo> productBundleInfos = TeaProductAction.getBundleInfos(this.product);
        ConfigData defaultStartInfos = new ConfigData(null, null, null, null);
        for (IInstallableUnit iu : results.getIUs(null, "root")) {
            BundleInfo productBundle;
            String symbolicId = iu.getId();
            if (symbolicId.startsWith("org.eclipse.equinox.launcher")) {
                innerResult.addIU(iu, "root");
                continue;
            }
            BundleInfo defaultBundle = defaultBundles.get(symbolicId);
            if (defaultBundle != null) {
                innerResult.addIU(iu, "root");
                defaultStartInfos.addBundle(defaultBundle);
            }
            if ((productBundle = productBundleInfos.get(symbolicId)) == null) continue;
            innerResult.addIU(iu, "root");
        }
        for (IVersionedId feature : this.product.getFeatures()) {
            String featureId = feature.getId() + ".feature.group";
            IQuery iuQuery = QueryUtil.createIUQuery((String)featureId);
            Iterator itor = results.query(iuQuery, monitor).iterator();
            while (itor.hasNext()) {
                innerResult.addIU((IInstallableUnit)itor.next(), "root");
            }
        }
        Assert.isLegal((defaultStartInfos.getBundles().length > 0 ? 1 : 0) != 0, (String)"Default bundles not found");
        String[] stringArray = innerInfo.getConfigurations();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String configSpec = stringArray[n2];
            innerInfo.addAdvice((IPublisherAdvice)new ConfigAdvice(defaultStartInfos, configSpec));
            ++n2;
        }
        IStatus status = super.perform((IPublisherInfo)innerInfo, (IPublisherResult)innerResult, monitor);
        if (status.getSeverity() != 4) {
            results.merge((IPublisherResult)innerResult, 0);
        }
        return status;
    }

    protected IPublisherAction createApplicationExecutableAction(String[] configSpecs) {
        return new TeaApplicationLauncherAction(this.id, this.version, this.flavor, this.executableName, this.platformExecutables, configSpecs, this.overrideExecutables);
    }

    private static Map<String, BundleInfo> getDefaultBundles() {
        TreeMap<String, BundleInfo> bundles = new TreeMap<String, BundleInfo>();
        String bundleId = "org.eclipse.equinox.simpleconfigurator";
        bundles.put(bundleId, new BundleInfo(bundleId, null, null, 1, true));
        bundleId = "org.eclipse.equinox.common";
        bundles.put(bundleId, new BundleInfo(bundleId, null, null, 2, true));
        bundleId = "org.eclipse.osgi";
        bundles.put(bundleId, new BundleInfo(bundleId, null, null, -1, true));
        bundleId = "org.eclipse.core.runtime";
        bundles.put(bundleId, new BundleInfo(bundleId, null, null, 4, true));
        bundleId = "org.eclipse.equinox.ds";
        bundles.put(bundleId, new BundleInfo(bundleId, null, null, 2, true));
        return bundles;
    }

    private static Map<String, BundleInfo> getBundleInfos(IProductDescriptor product) {
        TreeMap<String, BundleInfo> bundles = new TreeMap<String, BundleInfo>();
        for (BundleInfo bundleInfo : product.getBundleInfos()) {
            bundles.put(bundleInfo.getSymbolicName(), bundleInfo);
        }
        return bundles;
    }
}

