/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.workspace.loading;

import java.util.Collection;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sphinx.emf.metamodel.IMetaModelDescriptor;
import org.eclipse.sphinx.emf.model.IModelDescriptor;
import org.eclipse.sphinx.emf.workspace.internal.loading.ModelLoadJob;
import org.eclipse.sphinx.emf.workspace.internal.messages.Messages;
import org.eclipse.sphinx.emf.workspace.loading.operations.IFileLoadOperation;
import org.eclipse.sphinx.emf.workspace.loading.operations.IFileReloadOperation;
import org.eclipse.sphinx.emf.workspace.loading.operations.IFileUnloadOperation;
import org.eclipse.sphinx.emf.workspace.loading.operations.ILoadOperation;
import org.eclipse.sphinx.emf.workspace.loading.operations.IModelLoadOperation;
import org.eclipse.sphinx.emf.workspace.loading.operations.IModelUnloadOperation;
import org.eclipse.sphinx.emf.workspace.loading.operations.IProjectLoadOperation;
import org.eclipse.sphinx.emf.workspace.loading.operations.IProjectReloadOperation;
import org.eclipse.sphinx.platform.IExtendedPlatformConstants;

public class LoadJobScheduler {
    public void scheduleModelLoadJob(ILoadOperation operation) {
        if (operation instanceof IFileLoadOperation) {
            this.scheduleModelLoadJob((IFileLoadOperation)operation);
        } else if (operation instanceof IProjectLoadOperation) {
            this.scheduleModelLoadJob((IProjectLoadOperation)operation);
        } else if (operation instanceof IModelLoadOperation) {
            this.scheduleModelLoadJob((IModelLoadOperation)operation);
        } else if (operation instanceof IFileReloadOperation) {
            this.scheduleModelLoadJob((IFileReloadOperation)operation);
        } else if (operation instanceof IProjectReloadOperation) {
            this.scheduleModelLoadJob((IProjectReloadOperation)operation);
        } else if (operation instanceof IFileUnloadOperation) {
            this.scheduleModelLoadJob((IFileUnloadOperation)operation);
        } else if (operation instanceof IModelUnloadOperation) {
            this.scheduleModelLoadJob((IModelUnloadOperation)operation);
        } else {
            throw new UnsupportedOperationException(NLS.bind((String)Messages.error_unsupportedLoadOperation, (Object)operation.getClass().getSimpleName()));
        }
    }

    protected void scheduleModelLoadJob(IFileLoadOperation fileLoadOperation) {
        if (this.coveredByExistingLoadJob(fileLoadOperation)) {
            return;
        }
        if (!this.addToExistingLoadJob(fileLoadOperation)) {
            Job job = this.createModelLoadJob(fileLoadOperation);
            job.setPriority(40);
            job.setRule(fileLoadOperation.getRule());
            job.schedule();
        }
    }

    protected void scheduleModelLoadJob(IProjectLoadOperation prjLoadOperation) {
        if (this.coveredByExistingLoadJob(prjLoadOperation)) {
            return;
        }
        if (!this.addToExistingLoadJob(prjLoadOperation)) {
            Job job = this.createModelLoadJob(prjLoadOperation);
            job.setPriority(40);
            job.setRule(prjLoadOperation.getRule());
            job.schedule();
        }
    }

    protected void scheduleModelLoadJob(IModelLoadOperation modelLoadOperation) {
        if (this.coveredByExistingLoadJob(modelLoadOperation)) {
            return;
        }
        Job job = this.createModelLoadJob(modelLoadOperation);
        job.setPriority(40);
        job.setRule(modelLoadOperation.getRule());
        job.schedule();
    }

    protected void scheduleModelLoadJob(IFileReloadOperation fileReloadOperation) {
        if (this.coveredByExistingReloadJob(fileReloadOperation)) {
            return;
        }
        if (!this.addToExistingReLoadJob(fileReloadOperation)) {
            Job job = this.createModelLoadJob(fileReloadOperation);
            job.setPriority(40);
            job.setRule(fileReloadOperation.getRule());
            job.schedule();
        }
    }

    protected void scheduleModelLoadJob(IProjectReloadOperation projectReloadOperation) {
        if (this.coveredByExistingReloadJob(projectReloadOperation)) {
            return;
        }
        if (!this.addToExistingReLoadJob(projectReloadOperation)) {
            Job job = this.createModelLoadJob(projectReloadOperation);
            job.setPriority(40);
            job.setRule(projectReloadOperation.getRule());
            job.schedule();
        }
    }

    protected void scheduleModelLoadJob(IFileUnloadOperation fileUnloadOperation) {
        Job job = this.createModelLoadJob(fileUnloadOperation);
        job.setPriority(40);
        job.setRule(fileUnloadOperation.getRule());
        job.schedule();
    }

    protected void scheduleModelLoadJob(IModelUnloadOperation modelUnloadOperation) {
        Job job = this.createModelLoadJob(modelUnloadOperation);
        job.setPriority(40);
        job.setRule(modelUnloadOperation.getRule());
        job.schedule();
    }

    public boolean coveredByExistingLoadJob(IFileLoadOperation fileLoadOperation) {
        if (fileLoadOperation != null) {
            Collection<IFile> files = fileLoadOperation.getFiles();
            IMetaModelDescriptor metaModelDescriptor = fileLoadOperation.getMetaModelDescriptor();
            Job[] jobArray = Job.getJobManager().find(IExtendedPlatformConstants.FAMILY_MODEL_LOADING);
            int n = jobArray.length;
            int n2 = 0;
            while (n2 < n) {
                ModelLoadJob loadJob;
                Object operation;
                Job job = jobArray[n2];
                if (job instanceof ModelLoadJob && ((operation = (loadJob = (ModelLoadJob)job).getOperation()) instanceof IFileLoadOperation || operation instanceof IProjectLoadOperation) && loadJob.covers(files, metaModelDescriptor)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public boolean coveredByExistingLoadJob(IProjectLoadOperation prjLoadOperation) {
        if (prjLoadOperation != null) {
            Collection<IProject> projects = prjLoadOperation.getProjects();
            boolean includeReferencedProjects = prjLoadOperation.isIncludeReferencedProjects();
            IMetaModelDescriptor metaModelDescriptor = prjLoadOperation.getMetaModelDescriptor();
            Job[] jobArray = Job.getJobManager().find(IExtendedPlatformConstants.FAMILY_MODEL_LOADING);
            int n = jobArray.length;
            int n2 = 0;
            while (n2 < n) {
                ModelLoadJob loadJob;
                Object operation;
                Job job = jobArray[n2];
                if (job instanceof ModelLoadJob && (operation = (loadJob = (ModelLoadJob)job).getOperation()) instanceof IProjectLoadOperation && loadJob.covers(projects, includeReferencedProjects, metaModelDescriptor)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public boolean coveredByExistingLoadJob(IModelLoadOperation modelLoadOperation) {
        if (modelLoadOperation != null) {
            IModelDescriptor modelDescriptor = modelLoadOperation.getModelDescriptor();
            boolean includeReferencedProjects = modelLoadOperation.isIncludeReferencedScopes();
            Collection persistedFiles = modelDescriptor.getPersistedFiles(includeReferencedProjects);
            IMetaModelDescriptor metaModelDescriptor = modelLoadOperation.getMetaModelDescriptor();
            Job[] jobArray = Job.getJobManager().find(IExtendedPlatformConstants.FAMILY_MODEL_LOADING);
            int n = jobArray.length;
            int n2 = 0;
            while (n2 < n) {
                ModelLoadJob loadJob;
                Object operation;
                Job job = jobArray[n2];
                if (job instanceof ModelLoadJob && (operation = (loadJob = (ModelLoadJob)job).getOperation()) instanceof IModelLoadOperation && loadJob.covers(persistedFiles, metaModelDescriptor)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public boolean coveredByExistingReloadJob(IFileReloadOperation fileReloadOperation) {
        if (fileReloadOperation != null) {
            Collection<IFile> files = fileReloadOperation.getFiles();
            IMetaModelDescriptor metaModelDescriptor = fileReloadOperation.getMetaModelDescriptor();
            Job[] jobArray = Job.getJobManager().find(IExtendedPlatformConstants.FAMILY_MODEL_LOADING);
            int n = jobArray.length;
            int n2 = 0;
            while (n2 < n) {
                ModelLoadJob loadJob;
                Object operation;
                Job job = jobArray[n2];
                if (job instanceof ModelLoadJob && ((operation = (loadJob = (ModelLoadJob)job).getOperation()) instanceof IFileReloadOperation || operation instanceof IProjectReloadOperation) && loadJob.covers(files, metaModelDescriptor)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public boolean coveredByExistingReloadJob(IProjectReloadOperation projectReloadOperation) {
        if (projectReloadOperation != null) {
            Collection<IProject> projects = projectReloadOperation.getProjects();
            boolean includeReferencedProjects = projectReloadOperation.isIncludeReferencedProjects();
            IMetaModelDescriptor metaModelDescriptor = projectReloadOperation.getMetaModelDescriptor();
            Job[] jobArray = Job.getJobManager().find(IExtendedPlatformConstants.FAMILY_MODEL_LOADING);
            int n = jobArray.length;
            int n2 = 0;
            while (n2 < n) {
                ModelLoadJob loadJob;
                Object operation;
                Job job = jobArray[n2];
                if (job instanceof ModelLoadJob && (operation = (loadJob = (ModelLoadJob)job).getOperation()) instanceof IProjectReloadOperation && loadJob.covers(projects, includeReferencedProjects, metaModelDescriptor)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    private boolean addToExistingLoadJob(IFileLoadOperation fileLoadOperation) {
        Job[] jobArray = Job.getJobManager().find(IExtendedPlatformConstants.FAMILY_MODEL_LOADING);
        int n = jobArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object operation;
            Job job = jobArray[n2];
            if (job instanceof ModelLoadJob && job.getState() != 4 && (operation = ((ModelLoadJob)job).getOperation()) instanceof IFileLoadOperation) {
                ((IFileLoadOperation)operation).addFiles(fileLoadOperation.getFiles());
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean addToExistingLoadJob(IProjectLoadOperation prjLoadOperation) {
        Job[] jobArray = Job.getJobManager().find(IExtendedPlatformConstants.FAMILY_MODEL_LOADING);
        int n = jobArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object operation;
            Job job = jobArray[n2];
            if (job instanceof ModelLoadJob && job.getState() != 4 && (operation = ((ModelLoadJob)job).getOperation()) instanceof IProjectLoadOperation) {
                ((IProjectLoadOperation)operation).addProjects(prjLoadOperation.getProjects());
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean addToExistingReLoadJob(IFileReloadOperation fileReloadOperation) {
        Job[] jobArray = Job.getJobManager().find(IExtendedPlatformConstants.FAMILY_MODEL_LOADING);
        int n = jobArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object operation;
            Job job = jobArray[n2];
            if (job instanceof ModelLoadJob && (operation = ((ModelLoadJob)job).getOperation()) instanceof IFileReloadOperation && job.getState() != 4) {
                ((IFileReloadOperation)operation).addFiles(fileReloadOperation.getFiles());
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean addToExistingReLoadJob(IProjectReloadOperation projectReloadOperation) {
        Job[] jobArray = Job.getJobManager().find(IExtendedPlatformConstants.FAMILY_MODEL_LOADING);
        int n = jobArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object operation;
            Job job = jobArray[n2];
            if (job instanceof ModelLoadJob && job.getState() != 4 && (operation = ((ModelLoadJob)job).getOperation()) instanceof IProjectReloadOperation) {
                ((IProjectReloadOperation)operation).addProjects(projectReloadOperation.getProjects());
                return true;
            }
            ++n2;
        }
        return false;
    }

    private <T extends ILoadOperation> Job createModelLoadJob(T operation) {
        return new ModelLoadJob<T>(operation);
    }
}

