/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.workspace.internal.saving;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.sphinx.emf.model.IModelDescriptor;
import org.eclipse.sphinx.emf.saving.IModelSaveIndicator;
import org.eclipse.sphinx.emf.saving.IResourceSaveIndicator;
import org.eclipse.sphinx.emf.saving.SaveIndicatorUtil;
import org.eclipse.sphinx.emf.util.EcorePlatformUtil;

public class ModelSaveIndicator
implements IModelSaveIndicator {
    public boolean isDirty(IModelDescriptor modelDescriptor) {
        Assert.isNotNull((Object)modelDescriptor);
        IResourceSaveIndicator resourceSaveIndicator = SaveIndicatorUtil.getResourceSaveIndicator((EditingDomain)modelDescriptor.getEditingDomain());
        if (resourceSaveIndicator != null) {
            HashSet dirtyResources = new HashSet(resourceSaveIndicator.getDirtyResources());
            Collection modelResources = EcorePlatformUtil.getResourcesInModel((IModelDescriptor)modelDescriptor, (boolean)true);
            dirtyResources.retainAll(modelResources);
            return !dirtyResources.isEmpty();
        }
        return false;
    }

    public void setSaved(IModelDescriptor modelDescriptor) {
        Assert.isNotNull((Object)modelDescriptor);
        IResourceSaveIndicator resourceSaveIndicator = SaveIndicatorUtil.getResourceSaveIndicator((EditingDomain)modelDescriptor.getEditingDomain());
        if (resourceSaveIndicator != null) {
            ArrayList dirtyResources = new ArrayList(resourceSaveIndicator.getDirtyResources());
            Collection modelResources = EcorePlatformUtil.getResourcesInModel((IModelDescriptor)modelDescriptor, (boolean)true);
            dirtyResources.retainAll(modelResources);
            resourceSaveIndicator.setSaved(dirtyResources);
        }
    }
}

