/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.sequence.business.internal.util;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.diagram.sequence.business.api.util.Range;
import org.eclipse.sirius.diagram.sequence.business.internal.RangeHelper;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.AbstractFrame;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.AbstractNodeEvent;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.CombinedFragment;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.Execution;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.ISequenceElementAccessor;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.ISequenceEvent;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.ISequenceNode;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.Lifeline;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.Message;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.Operand;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.SequenceDiagram;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.State;
import org.eclipse.sirius.diagram.sequence.business.internal.ordering.EventEndHelper;
import org.eclipse.sirius.diagram.sequence.business.internal.query.ISequenceEventQuery;
import org.eclipse.sirius.diagram.sequence.business.internal.util.CacheHelper;
import org.eclipse.sirius.diagram.sequence.business.internal.util.EventFinder;
import org.eclipse.sirius.ext.base.Option;

public final class SubEventsHelper {
    private static Collection<Class<?>> types = new ArrayList();
    private ISequenceEvent parentEvent;
    private Range parentRange;
    private final Multimap<ISequenceEvent, Lifeline> coverage;

    public SubEventsHelper(ISequenceEvent event) {
        types.add(Execution.class);
        types.add(Lifeline.class);
        types.add(Operand.class);
        this.coverage = LinkedHashMultimap.create();
        Preconditions.checkArgument((boolean)types.contains(event.getClass()));
        Objects.requireNonNull(event);
        this.parentEvent = event;
        this.parentRange = event.getVerticalRange();
    }

    public List<ISequenceEvent> getSubEvents() {
        Collection<ISequenceEvent> subEvents = CacheHelper.getSubEventsCache().get(this.parentEvent);
        if (subEvents != null) {
            return new ArrayList<ISequenceEvent>(subEvents);
        }
        List<ISequenceEvent> result = this.getValidSubEvents();
        Collections.sort(result, RangeHelper.lowerBoundOrdering().onResultOf(ISequenceEvent.VERTICAL_RANGE));
        if (CacheHelper.isStructuralCacheEnabled()) {
            CacheHelper.getSubEventsCache().put(this.parentEvent, new ArrayList<ISequenceEvent>(result));
        }
        return result;
    }

    private List<ISequenceEvent> getValidSubEvents() {
        ArrayList<ISequenceEvent> childrenEvents = new ArrayList<ISequenceEvent>();
        LinkedHashSet<ISequenceEvent> localParents = new LinkedHashSet<ISequenceEvent>();
        LinkedHashSet<Lifeline> coveredLifelines = new LinkedHashSet<Lifeline>();
        if (this.parentEvent instanceof AbstractNodeEvent || this.parentEvent instanceof Lifeline) {
            localParents.add(this.parentEvent);
            coveredLifelines.add((Lifeline)this.parentEvent.getLifeline().get());
        } else if (this.parentEvent instanceof Operand) {
            Operand op = (Operand)this.parentEvent;
            CombinedFragment parentCombinedFragment = op.getCombinedFragment();
            coveredLifelines.addAll(this.getCoverage(parentCombinedFragment));
            localParents.addAll(this.getCarryingParents(parentCombinedFragment, coveredLifelines));
        }
        Set<ISequenceEvent> hierarchicalChildren = this.getNotationDirectChildrenInParentRange(localParents);
        Set<ISequenceEvent> frameChildren = this.getFrameChildrenInParentRange(coveredLifelines);
        childrenEvents.addAll(this.getTopLevelEvents(hierarchicalChildren, frameChildren, coveredLifelines));
        childrenEvents.addAll(this.getTopLevelEvents(frameChildren, childrenEvents, coveredLifelines));
        return childrenEvents;
    }

    private Collection<Lifeline> getCoverage(ISequenceEvent ise) {
        if (this.coverage.containsKey((Object)ise)) {
            return this.coverage.get((Object)ise);
        }
        Option<Lifeline> lifeline = ise.getLifeline();
        LinkedHashSet<Lifeline> coveredLifelines = new LinkedHashSet<Lifeline>();
        if (lifeline.some()) {
            coveredLifelines.add((Lifeline)lifeline.get());
        } else if (ise instanceof Operand) {
            coveredLifelines.addAll(this.getCoverage(((Operand)ise).getCombinedFragment()));
        } else if (ise instanceof AbstractFrame) {
            coveredLifelines.addAll(((AbstractFrame)ise).computeCoveredLifelines());
        } else if (ise instanceof Message) {
            Option<Lifeline> targetLifeline;
            Message msg = (Message)ise;
            Option<Lifeline> sourceLifeline = msg.getSourceLifeline();
            if (sourceLifeline.some()) {
                coveredLifelines.add((Lifeline)sourceLifeline.get());
            }
            if ((targetLifeline = msg.getTargetLifeline()).some()) {
                coveredLifelines.add((Lifeline)targetLifeline.get());
            }
        }
        this.coverage.putAll((Object)ise, coveredLifelines);
        return coveredLifelines;
    }

    private Collection<ISequenceEvent> getCarryingParents(AbstractFrame frame, Set<Lifeline> coveredLifelines) {
        LinkedHashSet<ISequenceEvent> coveredEvents = new LinkedHashSet<ISequenceEvent>();
        for (Lifeline lifeline : coveredLifelines) {
            EventFinder localParentFinder = new EventFinder(lifeline);
            localParentFinder.setReparent(true);
            localParentFinder.setEventsToIgnore((Predicate<ISequenceEvent>)Predicates.equalTo((Object)frame));
            ISequenceEvent localParent = localParentFinder.findMostSpecificEvent(frame.getVerticalRange());
            if (localParent == null) continue;
            coveredEvents.add(localParent);
        }
        return coveredEvents;
    }

    private Set<ISequenceEvent> getNotationDirectChildrenInParentRange(Collection<ISequenceEvent> localParents) {
        LinkedHashSet childViews = new LinkedHashSet();
        HashSet parentConnections = new HashSet();
        LinkedHashSet<ISequenceEvent> childrenEvents = new LinkedHashSet<ISequenceEvent>();
        for (ISequenceEvent ise : localParents) {
            View notationView = ise.getNotationView();
            childViews.addAll(Lists.newArrayList((Iterable)Iterables.filter((Iterable)notationView.getChildren(), View.class)));
            ArrayList sourceEdges = Lists.newArrayList((Iterable)Iterables.filter((Iterable)notationView.getSourceEdges(), View.class));
            ArrayList targetEdges = Lists.newArrayList((Iterable)Iterables.filter((Iterable)notationView.getTargetEdges(), View.class));
            childViews.addAll(sourceEdges);
            childViews.addAll(targetEdges);
            if (ise != this.parentEvent) continue;
            parentConnections.addAll(sourceEdges);
            parentConnections.addAll(targetEdges);
        }
        for (View view : childViews) {
            Option<ISequenceEvent> iSequenceEvent = ISequenceElementAccessor.getISequenceEvent(view);
            if (!iSequenceEvent.some()) continue;
            ISequenceEvent ise = (ISequenceEvent)iSequenceEvent.get();
            if (!parentConnections.contains(view) && !this.parentRange.includes(ise.getVerticalRange())) continue;
            childrenEvents.add((ISequenceEvent)iSequenceEvent.get());
        }
        return Sets.newLinkedHashSet(EventEndHelper.getIndependantEvents(this.parentEvent, childrenEvents));
    }

    private Set<ISequenceEvent> getFrameChildrenInParentRange(Set<Lifeline> coveredLifelines) {
        HashSet<ISequenceEvent> childrenEvents = new HashSet<ISequenceEvent>();
        SequenceDiagram diagram = this.parentEvent.getDiagram();
        HashSet<AbstractFrame> frames = new HashSet<AbstractFrame>();
        frames.addAll(diagram.getAllFrames());
        for (AbstractFrame frame : frames) {
            Range frameRange = frame.getVerticalRange();
            if (frameRange == null || !this.parentRange.includes(frameRange) || !this.validCoverage(frame, coveredLifelines)) continue;
            childrenEvents.add(frame);
        }
        return this.getTopLevelEvents(childrenEvents, childrenEvents, coveredLifelines);
    }

    private Set<ISequenceEvent> getTopLevelEvents(Set<ISequenceEvent> events, Collection<ISequenceEvent> potentialParents, Set<Lifeline> coveredLifelines) {
        LinkedHashSet<ISequenceEvent> topLevel = new LinkedHashSet<ISequenceEvent>();
        boolean parentFrames = Iterables.size((Iterable)Iterables.filter(potentialParents, AbstractFrame.class)) != 0;
        for (ISequenceEvent event : events) {
            ISequenceEvent potentialChild;
            final Range verticalRange = event.getVerticalRange();
            Predicate<ISequenceEvent> isParentOfCurrent = new Predicate<ISequenceEvent>(potentialChild = event){
                private final /* synthetic */ ISequenceEvent val$potentialChild;
                {
                    this.val$potentialChild = iSequenceEvent;
                }

                public boolean apply(ISequenceEvent input) {
                    Range inputRange = input.getVerticalRange();
                    boolean isParent = inputRange.includes(verticalRange);
                    return isParent && input != this.val$potentialChild;
                }
            };
            Iterable parents = Iterables.filter(potentialParents, (Predicate)isParentOfCurrent);
            if (Iterables.isEmpty((Iterable)parents)) {
                topLevel.add(potentialChild);
                continue;
            }
            if (!(potentialChild instanceof AbstractFrame) || parentFrames) continue;
            ArrayList<ISequenceEvent> carriers = new ArrayList<ISequenceEvent>(this.getCarryingParents((AbstractFrame)potentialChild, coveredLifelines));
            ArrayList parentsList = Lists.newArrayList((Iterable)parents);
            Iterables.removeAll(carriers, (Collection)parentsList);
            if (carriers.isEmpty()) continue;
            topLevel.add(potentialChild);
        }
        return topLevel;
    }

    private boolean validCoverage(AbstractFrame frame, Set<Lifeline> parentCoveredLifelines) {
        boolean result = false;
        Collection<Lifeline> coveredLifelines = this.getCoverage(frame);
        result = this.parentEvent instanceof Operand ? parentCoveredLifelines.containsAll(coveredLifelines) : coveredLifelines.contains(this.parentEvent.getLifeline().get());
        return result;
    }

    public boolean canChildOccupy(ISequenceEvent child, Range range) {
        return this.canChildOccupy(child, range, null, child == null ? this.getCoverage(this.parentEvent) : this.getCoverage(child));
    }

    public boolean canChildOccupy(ISequenceEvent child, Range range, List<ISequenceEvent> eventsToIgnore, Collection<Lifeline> lifelines) {
        boolean result = true;
        if (!this.parentEvent.getValidSubEventsRange().includes(range)) {
            result = false;
        } else {
            for (ISequenceEvent event : this.getSequenceEventsToFilter(this.parentEvent, child, range, lifelines)) {
                Range eventRange = event.getVerticalRange();
                if (eventsToIgnore != null && eventsToIgnore.contains(event)) continue;
                if (event instanceof Message) {
                    Message msg = (Message)event;
                    if (this.checkOverlapWithSiblingMessage(child, range, msg, eventRange)) continue;
                    result = false;
                    break;
                }
                if (!eventRange.intersects(range) && range.validatesBoundsAreDifferent(eventRange)) continue;
                result = false;
                break;
            }
        }
        return result;
    }

    private boolean checkOverlapWithSiblingMessage(ISequenceEvent child, Range childRange, Message msg, Range msgRange) {
        boolean result = true;
        if (child instanceof State) {
            result = !childRange.includesAtLeastOneBound(msgRange);
        } else if (msg.isReflective()) {
            if (msgRange.intersects(childRange) && (childRange.getLowerBound() <= msgRange.getLowerBound() || childRange.getUpperBound() >= msgRange.getUpperBound())) {
                result = false;
            }
        } else {
            Execution targetExec;
            Execution sourceExec;
            ISequenceNode sourceEvent = msg.getSourceElement();
            ISequenceNode targetEvent = msg.getTargetElement();
            AbstractNodeEvent parentExecEvent = null;
            if (sourceEvent instanceof Execution && msg.equals((sourceExec = (Execution)sourceEvent).getEndMessage().get())) {
                parentExecEvent = sourceExec;
            }
            if (targetEvent instanceof Execution && msg.equals((targetExec = (Execution)targetEvent).getStartMessage().get())) {
                parentExecEvent = targetExec;
            }
            if (parentExecEvent != null) {
                Range verticalRange = parentExecEvent.getVerticalRange();
                if (!(child == null || childRange.validatesBoundsAreDifferent(verticalRange) && (childRange.includes(verticalRange) || verticalRange.includes(childRange)))) {
                    result = false;
                }
            }
        }
        return result;
    }

    private Iterable<ISequenceEvent> getSequenceEventsToFilter(ISequenceEvent self, ISequenceEvent child, final Range range, final Collection<Lifeline> lifelines) {
        HashSet<ISequenceEvent> result = new HashSet<ISequenceEvent>(self.getSubEvents());
        Predicate<ISequenceEvent> inRangePredicate = new Predicate<ISequenceEvent>(){

            public boolean apply(ISequenceEvent input) {
                Range inputRange = input.getVerticalRange();
                return range.includesAtLeastOneBound(inputRange) || new ISequenceEventQuery(input).isReflectiveMessage() && inputRange.includesAtLeastOneBound(range);
            }
        };
        Predicate<ISequenceEvent> inCoverage = new Predicate<ISequenceEvent>(){

            public boolean apply(ISequenceEvent input) {
                ArrayList<Lifeline> inputCoverage = new ArrayList<Lifeline>(SubEventsHelper.this.getCoverage(input));
                return Iterables.removeAll(inputCoverage, (Collection)lifelines);
            }
        };
        Predicate predicateFilter = Predicates.and((Predicate[])new Predicate[]{Predicates.not((Predicate)Predicates.equalTo((Object)child)), inRangePredicate, inCoverage});
        return Iterables.filter(result, (Predicate)predicateFilter);
    }
}

