/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.core.service;

import com.google.inject.Injector;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.elk.core.service.IDiagramLayoutConnector;
import org.eclipse.elk.core.service.ILayoutListener;
import org.eclipse.elk.core.service.ILayoutSetup;
import org.eclipse.elk.core.service.LayoutMapping;
import org.eclipse.elk.core.service.internal.DefaultModule;
import org.eclipse.elk.core.util.IElkProgressMonitor;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.statushandlers.StatusManager;

public class LayoutConnectorsService {
    protected static final String EXTP_ID_LAYOUT_CONNECTORS = "org.eclipse.elk.core.service.layoutConnectors";
    protected static final String ELEMENT_SETUP = "setup";
    protected static final String ATTRIBUTE_CLASS = "class";
    protected static final String ATTRIBUTE_PRIORITY = "priority";
    private static LayoutConnectorsService instance;
    private final List<SetupEntry> entries = new LinkedList<SetupEntry>();
    private final List<ILayoutListener> layoutListeners = new LinkedList<ILayoutListener>();

    public static synchronized LayoutConnectorsService getInstance() {
        if (instance == null) {
            instance = new LayoutConnectorsService();
        }
        return instance;
    }

    protected static synchronized void unload() {
        if (instance != null) {
            instance = null;
        }
    }

    public LayoutConnectorsService() {
        if (Platform.isRunning()) {
            this.loadLayoutSetupExtensions();
        }
    }

    public final Injector getInjector(IWorkbenchPart workbenchPart, Object diagramPart) {
        for (SetupEntry entry : this.entries) {
            if (!(workbenchPart == null ? entry.setup.supports(diagramPart) : entry.setup.supports(workbenchPart) && (diagramPart == null || entry.setup.supports(diagramPart)))) continue;
            return this.getInjector(entry);
        }
        return null;
    }

    private Injector getInjector(SetupEntry entry) {
        if (entry.injector == null) {
            entry.injector = entry.setup.createInjector(new DefaultModule());
        }
        return entry.injector;
    }

    public final IDiagramLayoutConnector getConnector(IWorkbenchPart workbenchPart, Object diagramPart) {
        Injector injector = this.getInjector(workbenchPart, diagramPart);
        if (injector != null) {
            return (IDiagramLayoutConnector)injector.getInstance(IDiagramLayoutConnector.class);
        }
        return null;
    }

    public void addLayoutListener(ILayoutListener listener) {
        this.layoutListeners.add(listener);
    }

    public void removeLayoutListener(ILayoutListener listener) {
        this.layoutListeners.remove(listener);
    }

    protected void fireLayoutAboutToStart(LayoutMapping mapping, IElkProgressMonitor progressMonitor) {
        for (ILayoutListener listener : this.layoutListeners) {
            listener.layoutAboutToStart(mapping, progressMonitor);
        }
    }

    protected void fireLayoutDone(LayoutMapping mapping, IElkProgressMonitor progressMonitor) {
        for (ILayoutListener listener : this.layoutListeners) {
            listener.layoutDone(mapping, progressMonitor);
        }
    }

    private void loadLayoutSetupExtensions() {
        IConfigurationElement[] extensions;
        IConfigurationElement[] iConfigurationElementArray = extensions = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTP_ID_LAYOUT_CONNECTORS);
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            block6: {
                IConfigurationElement element = iConfigurationElementArray[n2];
                try {
                    ILayoutSetup setup;
                    if (!ELEMENT_SETUP.equals(element.getName()) || (setup = (ILayoutSetup)element.createExecutableExtension(ATTRIBUTE_CLASS)) == null) break block6;
                    SetupEntry entry = new SetupEntry();
                    entry.setup = setup;
                    String prioEntry = element.getAttribute(ATTRIBUTE_PRIORITY);
                    if (prioEntry != null) {
                        try {
                            entry.priority = Integer.parseInt(prioEntry);
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                    this.insertSorted(entry);
                }
                catch (CoreException exception) {
                    StatusManager.getManager().handle(exception, "org.eclipse.elk.core.service");
                }
            }
            ++n2;
        }
    }

    private void insertSorted(SetupEntry entry) {
        ListIterator<SetupEntry> iter = this.entries.listIterator();
        while (iter.hasNext()) {
            SetupEntry next = iter.next();
            if (next.priority > entry.priority) continue;
            iter.previous();
            break;
        }
        iter.add(entry);
    }

    private static class SetupEntry {
        private int priority;
        private ILayoutSetup setup;
        private Injector injector;

        private SetupEntry() {
        }
    }
}

