/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.model.siteplan;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum SignalSystem implements Enumerator
{
    HL(0, "HL", "HL"),
    HV(1, "HV", "HV"),
    KS(2, "KS", "KS"),
    SV(3, "SV", "SV"),
    NONE(4, "None", "None");

    public static final int HL_VALUE = 0;
    public static final int HV_VALUE = 1;
    public static final int KS_VALUE = 2;
    public static final int SV_VALUE = 3;
    public static final int NONE_VALUE = 4;
    private static final SignalSystem[] VALUES_ARRAY;
    public static final List<SignalSystem> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new SignalSystem[]{HL, HV, KS, SV, NONE};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static SignalSystem get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            SignalSystem result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static SignalSystem getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            SignalSystem result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static SignalSystem get(int value) {
        switch (value) {
            case 0: {
                return HL;
            }
            case 1: {
                return HV;
            }
            case 2: {
                return KS;
            }
            case 3: {
                return SV;
            }
            case 4: {
                return NONE;
            }
        }
        return null;
    }

    private SignalSystem(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

