/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.model.siteplan;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ControlStationType implements Enumerator
{
    DEFAULT_CONTROL(0, "DefaultControl", "DefaultControl"),
    EMERGENCY_CONTROL(1, "EmergencyControl", "EmergencyControl"),
    EMERGENCY_CONTROL_DISPOSE(2, "EmergencyControlDispose", "EmergencyControlDispose"),
    DEFAULT_CONTROL_DISPOSE(3, "DefaultControlDispose", "DefaultControlDispose"),
    OTHER(4, "Other", "Other"),
    WITHOUT_CONTROL(5, "WithoutControl", "WithoutControl"),
    ONLY_REMOTE_CONTROL(6, "OnlyRemoteControl", "OnlyRemoteControl");

    public static final int DEFAULT_CONTROL_VALUE = 0;
    public static final int EMERGENCY_CONTROL_VALUE = 1;
    public static final int EMERGENCY_CONTROL_DISPOSE_VALUE = 2;
    public static final int DEFAULT_CONTROL_DISPOSE_VALUE = 3;
    public static final int OTHER_VALUE = 4;
    public static final int WITHOUT_CONTROL_VALUE = 5;
    public static final int ONLY_REMOTE_CONTROL_VALUE = 6;
    private static final ControlStationType[] VALUES_ARRAY;
    public static final List<ControlStationType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ControlStationType[]{DEFAULT_CONTROL, EMERGENCY_CONTROL, EMERGENCY_CONTROL_DISPOSE, DEFAULT_CONTROL_DISPOSE, OTHER, WITHOUT_CONTROL, ONLY_REMOTE_CONTROL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ControlStationType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ControlStationType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ControlStationType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ControlStationType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ControlStationType get(int value) {
        switch (value) {
            case 0: {
                return DEFAULT_CONTROL;
            }
            case 1: {
                return EMERGENCY_CONTROL;
            }
            case 2: {
                return EMERGENCY_CONTROL_DISPOSE;
            }
            case 3: {
                return DEFAULT_CONTROL_DISPOSE;
            }
            case 4: {
                return OTHER;
            }
            case 5: {
                return WITHOUT_CONTROL;
            }
            case 6: {
                return ONLY_REMOTE_CONTROL;
            }
        }
        return null;
    }

    private ControlStationType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

