/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.feature.projectdata.ppimport;

import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.ReplaceCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.set.basis.IModelSession;
import org.eclipse.set.basis.Pair;
import org.eclipse.set.basis.files.ToolboxFile;
import org.eclipse.set.basis.guid.Guid;
import org.eclipse.set.core.fileservice.ToolboxIDResolver;
import org.eclipse.set.feature.projectdata.ppimport.ContainerComboSelection;
import org.eclipse.set.feature.projectdata.ppimport.SubworkComboSelection;
import org.eclipse.set.feature.projectdata.ppimport.control.ImportModelControl;
import org.eclipse.set.feature.projectdata.utils.ImportComboFileField;
import org.eclipse.set.feature.projectdata.utils.ServiceProvider;
import org.eclipse.set.model.planpro.Basisobjekte.Anhang;
import org.eclipse.set.model.planpro.Basisobjekte.BasisobjekteFactory;
import org.eclipse.set.model.planpro.Basisobjekte.BasisobjektePackage;
import org.eclipse.set.model.planpro.Basisobjekte.Ur_Objekt;
import org.eclipse.set.model.planpro.PlanPro.Ausgabe_Fachdaten;
import org.eclipse.set.model.planpro.PlanPro.ENUMUntergewerkArt;
import org.eclipse.set.model.planpro.PlanPro.LST_Zustand;
import org.eclipse.set.model.planpro.PlanPro.PlanProFactory;
import org.eclipse.set.model.planpro.PlanPro.PlanProPackage;
import org.eclipse.set.model.planpro.PlanPro.PlanPro_Schnittstelle;
import org.eclipse.set.model.planpro.PlanPro.Planung_Einzel;
import org.eclipse.set.model.planpro.PlanPro.Planung_Gruppe;
import org.eclipse.set.model.planpro.PlanPro.Planung_Projekt;
import org.eclipse.set.model.planpro.PlanPro.Untergewerk_Art_TypeClass;
import org.eclipse.set.ppmodel.extensions.AusgabeFachdatenExtensions;
import org.eclipse.set.ppmodel.extensions.PlanProSchnittstelleExtensions;
import org.eclipse.set.ppmodel.extensions.PlanungEinzelExtensions;
import org.eclipse.set.ppmodel.extensions.PlanungGruppeExtensions;
import org.eclipse.set.ppmodel.extensions.utils.IterableExtensions;
import org.eclipse.set.utils.widgets.MultiSelectionCombo;
import org.eclipse.set.utils.widgets.SelectionCombo;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportModelHandler {
    static final Logger logger = LoggerFactory.getLogger(ImportModelHandler.class);
    private final ImportComboFileField comboField;
    private final PlanPro_Schnittstelle modelToImport;
    private final ImportModelControl.ImportTarget target;
    private final MultiSelectionCombo<SubworkComboSelection> subworkCombo;
    private final SelectionCombo<ContainerComboSelection> containerCombo;
    private final ServiceProvider serviceProvider;

    public ImportModelHandler(ImportComboFileField comboField, PlanPro_Schnittstelle modelToImport, ImportModelControl.ImportTarget target, ServiceProvider serviceProvider) {
        this.comboField = comboField;
        this.modelToImport = modelToImport;
        this.target = target;
        this.subworkCombo = comboField.getSubworkCombo();
        this.containerCombo = comboField.getContainerCombo();
        this.serviceProvider = serviceProvider;
    }

    public boolean doImport(IModelSession modelSession, Map<String, byte[]> mediaToImport, Shell shell) {
        if (this.modelToImport == null) {
            return false;
        }
        PlanPro_Schnittstelle source = modelSession.getPlanProSchnittstelle();
        EditingDomain editingDomain = modelSession.getEditingDomain();
        Optional sourcePlanungGruppes = PlanProSchnittstelleExtensions.getLSTPlanungGruppe((PlanPro_Schnittstelle)source);
        if (sourcePlanungGruppes.isEmpty()) {
            return false;
        }
        ArrayList<Pair<Planung_Gruppe, Ausgabe_Fachdaten>> importDatas = new ArrayList<Pair<Planung_Gruppe, Ausgabe_Fachdaten>>();
        if (!PlanProSchnittstelleExtensions.isPlanning((PlanPro_Schnittstelle)this.modelToImport)) {
            importDatas.add(this.getImportData(shell));
        } else {
            importDatas.addAll(this.getImportDatas());
        }
        return importDatas.stream().filter(Objects::nonNull).filter(data -> {
            ENUMUntergewerkArt subworkType = ((Ausgabe_Fachdaten)data.getSecond()).getUntergewerkArt().getWert();
            Optional sourceGruppe = PlanungGruppeExtensions.getPlanungGruppe((PlanPro_Schnittstelle)source, (ENUMUntergewerkArt)subworkType);
            Optional sourceSubwork = sourceGruppe.isEmpty() ? AusgabeFachdatenExtensions.getAusgabeFachdaten((PlanPro_Schnittstelle)source, (ENUMUntergewerkArt)subworkType) : AusgabeFachdatenExtensions.getAusgabeFachdaten((PlanPro_Schnittstelle)source, (Optional)sourceGruppe);
            Optional<LST_Zustand> sourceContainer = this.getSourceContainer(sourceSubwork);
            if ((sourceGruppe.isPresent() || sourceSubwork.isPresent() || sourceContainer.isPresent() && !sourceContainer.get().getContainer().eContents().isEmpty()) && !this.serviceProvider.dialogService.confirmOverwriteOperationalData(shell)) {
                return false;
            }
            this.importPlaningGroup(source, sourceGruppe, (Planung_Gruppe)EcoreUtil.copy((EObject)((Planung_Gruppe)data.getFirst())), editingDomain);
            this.importSubwork(source, sourceSubwork, sourceContainer, (Ausgabe_Fachdaten)EcoreUtil.copy((EObject)((Ausgabe_Fachdaten)data.getSecond())), editingDomain);
            if (modelSession.getToolboxFile().getFormat().isZippedPlanPro()) {
                ImportModelHandler.importAttachment(modelSession.getToolboxFile(), ImportModelHandler.getImportAttachments((Pair<Planung_Gruppe, Ausgabe_Fachdaten>)data), mediaToImport);
            }
            this.updateGuidAfterImport(source, (Pair<Planung_Gruppe, Ausgabe_Fachdaten>)data, editingDomain);
            return true;
        }).count() > 0L;
    }

    private void importPlaningGroup(PlanPro_Schnittstelle source, Optional<Planung_Gruppe> sourceGroup, Planung_Gruppe importGroup, EditingDomain editingDomian) {
        if (this.target != ImportModelControl.ImportTarget.ALL && sourceGroup.isPresent()) {
            return;
        }
        ImportModelHandler.doImportCommand(editingDomian, sourceGroup.orElse(null), importGroup, (EObject)source.getLSTPlanung().getObjektmanagement().getLSTPlanungProjekt().getFirst(), PlanProPackage.eINSTANCE.getPlanung_Projekt_LSTPlanungGruppe());
    }

    private void importSubwork(PlanPro_Schnittstelle source, Optional<Ausgabe_Fachdaten> sourceSubwork, Optional<LST_Zustand> sourceState, Ausgabe_Fachdaten importSubwork, EditingDomain editingDomain) {
        if (this.target == ImportModelControl.ImportTarget.ALL || sourceSubwork.isEmpty() || sourceState.isEmpty()) {
            ImportModelHandler.doImportCommand(editingDomain, sourceSubwork.orElse(null), importSubwork, (EObject)source.getLSTPlanung().getFachdaten(), PlanProPackage.eINSTANCE.getFachdaten_AttributeGroup_AusgabeFachdaten());
            return;
        }
        LST_Zustand importState = importSubwork.getLSTZustandStart();
        if (!importState.getContainer().eAllContents().hasNext()) {
            importState = importSubwork.getLSTZustandZiel();
        }
        ImportModelHandler.doImportCommand(editingDomain, sourceState.get().getContainer(), importState.getContainer(), (EObject)sourceState.get(), PlanProPackage.eINSTANCE.getLST_Zustand_Container());
    }

    private static List<Anhang> getImportAttachments(Pair<Planung_Gruppe, Ausgabe_Fachdaten> importData) {
        ArrayList importAttachments = Lists.newArrayList((Iterator)Iterators.filter((Iterator)((Planung_Gruppe)importData.getFirst()).eAllContents(), Anhang.class));
        importAttachments.addAll(Lists.newArrayList((Iterator)Iterators.filter((Iterator)((Ausgabe_Fachdaten)importData.getSecond()).eAllContents(), Anhang.class)));
        return Lists.newArrayList((Iterable)IterableExtensions.distinctBy((Iterable)importAttachments, attachment -> attachment.getIdentitaet().getWert()));
    }

    private static void importAttachment(ToolboxFile sourceToolboxfile, List<Anhang> importAttachments, Map<String, byte[]> importAttachmentSource) {
        importAttachments.forEach(attachment -> {
            String guid = attachment.getIdentitaet().getWert();
            byte[] value = (byte[])importAttachmentSource.get(guid);
            if (guid == null || value == null) {
                return;
            }
            try {
                sourceToolboxfile.createMedia(Guid.create((String)guid), value);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    private Optional<LST_Zustand> getSourceContainer(Optional<Ausgabe_Fachdaten> sourceSubwork) {
        if (sourceSubwork.isEmpty()) {
            return Optional.empty();
        }
        switch (this.target) {
            case INITIAL: {
                return Optional.of(sourceSubwork.get().getLSTZustandStart());
            }
            case FINAL: {
                return Optional.of(sourceSubwork.get().getLSTZustandZiel());
            }
        }
        return Optional.empty();
    }

    private Pair<Planung_Gruppe, Ausgabe_Fachdaten> getImportData(Shell shell) {
        ENUMUntergewerkArt untergewerkArt = this.chooseSubworkType(shell);
        if (untergewerkArt == null) {
            return null;
        }
        PlanPro_Schnittstelle newSchnitStelle = PlanProSchnittstelleExtensions.transformSingleState((PlanPro_Schnittstelle)this.modelToImport);
        ToolboxIDResolver.resolveIDReferences((PlanPro_Schnittstelle)newSchnitStelle);
        Ausgabe_Fachdaten ausgabeFachdaten = (Ausgabe_Fachdaten)newSchnitStelle.getLSTPlanung().getFachdaten().getAusgabeFachdaten().get(0);
        Planung_Gruppe planungGruppe = (Planung_Gruppe)((Planung_Projekt)newSchnitStelle.getLSTPlanung().getObjektmanagement().getLSTPlanungProjekt().get(0)).getLSTPlanungGruppe().get(0);
        try {
            ImportModelHandler.setSubworkType((EObject)planungGruppe, List.of(PlanProPackage.eINSTANCE.getPlanung_Gruppe_PlanungGAllg(), PlanProPackage.eINSTANCE.getPlanung_G_Allg_AttributeGroup_UntergewerkArt()), untergewerkArt);
            ImportModelHandler.setSubworkType((EObject)ausgabeFachdaten, List.of(PlanProPackage.eINSTANCE.getAusgabe_Fachdaten_UntergewerkArt()), untergewerkArt);
            return new Pair((Object)planungGruppe, (Object)ausgabeFachdaten);
        }
        catch (NullPointerException e) {
            throw new RuntimeException();
        }
    }

    private List<Pair<Planung_Gruppe, Ausgabe_Fachdaten>> getImportDatas() {
        List selectedSubworks = this.subworkCombo.getSelectionValues();
        if (selectedSubworks.isEmpty()) {
            return Collections.emptyList();
        }
        return selectedSubworks.stream().map(subwork -> {
            Optional planungGruppe = PlanungGruppeExtensions.getPlanungGruppe((PlanPro_Schnittstelle)this.modelToImport, (String)subwork.getLiteral());
            if (planungGruppe.isEmpty()) {
                throw new IllegalArgumentException(String.format("The model not contain sub work type: %s", subwork.getLiteral()));
            }
            Planung_Einzel planungEinzel = ((Planung_Gruppe)planungGruppe.get()).getLSTPlanungEinzel();
            Ausgabe_Fachdaten ausgabeFachdaten = PlanungEinzelExtensions.getAusgabeFachdaten((Planung_Einzel)planungEinzel);
            return new Pair((Object)((Planung_Gruppe)planungGruppe.get()), (Object)this.filterImportContainer(ausgabeFachdaten));
        }).toList();
    }

    private ENUMUntergewerkArt chooseSubworkType(Shell shell) {
        List<String> subworkTypes = Arrays.stream(ENUMUntergewerkArt.values()).map(e -> e.getLiteral()).toList();
        String selectedType = this.serviceProvider.dialogService.selectValueDialog(shell, this.getImportDialogTilte(), this.serviceProvider.messages.PlanProImportPart_SelectSubworkMessage, this.serviceProvider.messages.PlanProImportPart_SelectSubworkLabel, subworkTypes);
        return ENUMUntergewerkArt.get((String)selectedType);
    }

    private static void setSubworkType(EObject parent, List<EReference> referencesToGetSubworkType, ENUMUntergewerkArt type) {
        EObject containerObject = parent;
        int i = 0;
        while (i < referencesToGetSubworkType.size()) {
            EReference reference = referencesToGetSubworkType.get(i);
            EClass eClass = reference.getEReferenceType();
            Optional<EObject> object = Optional.ofNullable((EObject)containerObject.eGet((EStructuralFeature)reference));
            if (object.isEmpty()) {
                EObject eObject = PlanProFactory.eINSTANCE.create(eClass);
                containerObject.eSet((EStructuralFeature)reference, (Object)eObject);
                containerObject = eObject;
            } else {
                containerObject = object.get();
            }
            if (i == referencesToGetSubworkType.size() - 1 && containerObject instanceof Untergewerk_Art_TypeClass) {
                Untergewerk_Art_TypeClass untergewerkArtTyeClass = (Untergewerk_Art_TypeClass)containerObject;
                untergewerkArtTyeClass.setWert(type);
            }
            ++i;
        }
    }

    private Ausgabe_Fachdaten filterImportContainer(Ausgabe_Fachdaten subwork) {
        if (this.target == ImportModelControl.ImportTarget.ALL) {
            return subwork;
        }
        if (this.containerCombo.isDisposed() || this.comboField.isNotSelected((Combo)this.containerCombo)) {
            return subwork;
        }
        ContainerComboSelection selectionValue = (ContainerComboSelection)((Object)this.containerCombo.getSelectionValue());
        Ausgabe_Fachdaten newSubwork = (Ausgabe_Fachdaten)EcoreUtil.copy((EObject)subwork);
        LST_Zustand emptyZustand = PlanProFactory.eINSTANCE.createLST_Zustand();
        emptyZustand.setContainer(PlanProFactory.eINSTANCE.createContainer_AttributeGroup());
        emptyZustand.setIdentitaet(BasisobjekteFactory.eINSTANCE.createIdentitaet_TypeClass());
        emptyZustand.getIdentitaet().setWert(Guid.create().toString());
        switch (selectionValue) {
            case START: 
            case ZUSTAND_INFORMATION: {
                newSubwork.setLSTZustandZiel(emptyZustand);
                break;
            }
            case ZIEL: {
                newSubwork.setLSTZustandStart(emptyZustand);
                break;
            }
            default: {
                logger.error("Unexpected value: {}", (Object)selectionValue);
                throw new IllegalArgumentException();
            }
        }
        return newSubwork;
    }

    private static <T> void doImportCommand(EditingDomain editingDomain, T oldValue, T newValue, EObject owner, EReference feature) {
        if (newValue == null) {
            return;
        }
        Command command = null;
        command = owner.eGet((EStructuralFeature)feature) instanceof Collection ? (oldValue == null ? AddCommand.create((EditingDomain)editingDomain, (Object)owner, (Object)feature, newValue) : ReplaceCommand.create((EditingDomain)editingDomain, (Object)owner, (Object)feature, oldValue, Collections.singleton(newValue))) : SetCommand.create((EditingDomain)editingDomain, (Object)owner, (Object)feature, newValue);
        if (command != null) {
            editingDomain.getCommandStack().execute(command);
        }
    }

    private void updateGuidAfterImport(PlanPro_Schnittstelle source, Pair<Planung_Gruppe, Ausgabe_Fachdaten> dataToImport, EditingDomain editingDomain) {
        boolean importSubworkSuccess;
        ENUMUntergewerkArt untergewerkArt = PlanungGruppeExtensions.getUntergewerkArt((Planung_Gruppe)((Planung_Gruppe)dataToImport.getFirst()));
        Optional newPlaningGroup = this.target == ImportModelControl.ImportTarget.ALL ? PlanungGruppeExtensions.getPlanungGruppe((PlanPro_Schnittstelle)source, (ENUMUntergewerkArt)untergewerkArt, (String)((Planung_Gruppe)dataToImport.getFirst()).getIdentitaet().getWert()) : PlanungGruppeExtensions.getPlanungGruppe((PlanPro_Schnittstelle)source, (ENUMUntergewerkArt)untergewerkArt);
        Optional newSubwork = newPlaningGroup.isEmpty() ? AusgabeFachdatenExtensions.getAusgabeFachdaten((PlanPro_Schnittstelle)source, (ENUMUntergewerkArt)untergewerkArt) : AusgabeFachdatenExtensions.getAusgabeFachdaten((PlanPro_Schnittstelle)source, (Planung_Gruppe)((Planung_Gruppe)newPlaningGroup.get()));
        boolean bl = importSubworkSuccess = this.target == ImportModelControl.ImportTarget.ALL && newSubwork.isPresent() && !((Ausgabe_Fachdaten)newSubwork.get()).getIdentitaet().getWert().equals(((Ausgabe_Fachdaten)dataToImport.getSecond()).getIdentitaet().getWert());
        if (newPlaningGroup.isEmpty() || newSubwork.isEmpty() || importSubworkSuccess) {
            logger.error("The Import process wasn't successfull");
            throw new IllegalArgumentException();
        }
        String seriNumberStr = PlanProSchnittstelleExtensions.getLaufendeNummerAusgabe((PlanPro_Schnittstelle)source).orElse("0");
        int serNumberInt = 0;
        try {
            serNumberInt = Integer.parseInt(seriNumberStr);
        }
        catch (NumberFormatException e) {
            logger.error("LaufendeNummerAusgabe={} is no number. Zero is assumed for updateForImport.", (Object)seriNumberStr);
        }
        Command setSeriNumberCommand = SetCommand.create((EditingDomain)editingDomain, (Object)((Planung_Gruppe)newPlaningGroup.get()).getLSTPlanungEinzel().getPlanungEAllg().getLaufendeNummerAusgabe(), (Object)PlanProPackage.eINSTANCE.getLaufende_Nummer_Ausgabe_TypeClass_Wert(), (Object)String.format("%02d", ++serNumberInt));
        editingDomain.getCommandStack().execute(setSeriNumberCommand);
        editingDomain.getCommandStack().execute(ImportModelHandler.createSetGuidCommand(editingDomain, (Ur_Objekt)((Planung_Projekt)((Planung_Gruppe)newPlaningGroup.get()).eContainer())));
        editingDomain.getCommandStack().execute(ImportModelHandler.createSetGuidCommand(editingDomain, (Ur_Objekt)newPlaningGroup.get()));
        editingDomain.getCommandStack().execute(ImportModelHandler.createSetGuidCommand(editingDomain, (Ur_Objekt)((Planung_Gruppe)newPlaningGroup.get()).getLSTPlanungEinzel()));
        Planung_Einzel lstPlanungEinzel = ((Planung_Gruppe)newPlaningGroup.get()).getLSTPlanungEinzel();
        if (this.target == ImportModelControl.ImportTarget.ALL || this.target == ImportModelControl.ImportTarget.INITIAL) {
            editingDomain.getCommandStack().execute(ImportModelHandler.createSetGuidCommand(editingDomain, (Ur_Objekt)PlanungEinzelExtensions.LSTZustandStart((Planung_Einzel)lstPlanungEinzel)));
        }
        if (this.target == ImportModelControl.ImportTarget.ALL || this.target == ImportModelControl.ImportTarget.FINAL) {
            editingDomain.getCommandStack().execute(ImportModelHandler.createSetGuidCommand(editingDomain, (Ur_Objekt)PlanungEinzelExtensions.LSTZustandZiel((Planung_Einzel)lstPlanungEinzel)));
        }
    }

    private static Command createSetGuidCommand(EditingDomain editingDomain, Ur_Objekt owner) {
        return SetCommand.create((EditingDomain)editingDomain, (Object)owner.getIdentitaet(), (Object)BasisobjektePackage.eINSTANCE.getIdentitaet_TypeClass_Wert(), (Object)Guid.create().toString());
    }

    private String getImportDialogTilte() {
        return switch (this.target) {
            case ImportModelControl.ImportTarget.ALL -> this.serviceProvider.messages.PlanProImportPart_ImportDialog_Title_ALL;
            case ImportModelControl.ImportTarget.INITIAL -> this.serviceProvider.messages.PlanProImportPart_ImportDialog_Title_INITIAL;
            case ImportModelControl.ImportTarget.FINAL -> this.serviceProvider.messages.PlanProImportPart_ImportDialog_Title_FINAL;
            default -> this.serviceProvider.messages.PlanProImportDescriptionService_ViewName;
        };
    }
}

