/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.ppmodel.extensions;

import java.math.BigDecimal;
import java.util.List;
import java.util.Objects;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.set.basis.geometry.GeoPosition;
import org.eclipse.set.model.planpro.BasisTypen.ENUMWirkrichtung;
import org.eclipse.set.model.planpro.Basisobjekte.Basis_Objekt;
import org.eclipse.set.model.planpro.Geodaten.GEO_Kante;
import org.eclipse.set.model.planpro.Geodaten.GEO_Knoten;
import org.eclipse.set.model.planpro.Geodaten.Strecke;
import org.eclipse.set.model.planpro.Geodaten.Strecke_Punkt;
import org.eclipse.set.model.planpro.Verweise.ID_GEO_Art_TypeClass;
import org.eclipse.set.model.planpro.Verweise.ID_Strecke_TypeClass;
import org.eclipse.set.ppmodel.extensions.BasisAttributExtensions;
import org.eclipse.set.ppmodel.extensions.BasisObjektExtensions;
import org.eclipse.set.ppmodel.extensions.GeoKnotenExtensions;
import org.eclipse.set.ppmodel.extensions.StreckePunktExtensions;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class StreckeExtensions
extends BasisObjektExtensions {
    public static List<GEO_Kante> getGeoKanten(Strecke strecke) {
        Functions.Function1 _function = k -> {
            ID_GEO_Art_TypeClass _iDGEOArt = k.getIDGEOArt();
            String _wert = null;
            if (_iDGEOArt != null) {
                _wert = _iDGEOArt.getWert();
            }
            String _wert_1 = strecke.getIdentitaet().getWert();
            return Objects.equals(_wert, _wert_1);
        };
        return IterableExtensions.toList((Iterable)IterableExtensions.filter((Iterable)BasisAttributExtensions.getContainer((EObject)strecke).getGEOKante(), (Functions.Function1)_function));
    }

    public static Iterable<Strecke_Punkt> getStreckenPunkte(Strecke strecke) {
        Functions.Function1 _function = k -> {
            ID_Strecke_TypeClass _iDStrecke = k.getIDStrecke();
            String _wert = null;
            if (_iDStrecke != null) {
                _wert = _iDStrecke.getWert();
            }
            String _wert_1 = strecke.getIdentitaet().getWert();
            return Objects.equals(_wert, _wert_1);
        };
        return IterableExtensions.filter((Iterable)BasisAttributExtensions.getContainer((EObject)strecke).getStreckePunkt(), (Functions.Function1)_function);
    }

    public static GeoPosition getKilometerCoordinate(Strecke strecke, BigDecimal kilometer) {
        Strecke_Punkt[] startEnd = StreckeExtensions.getStartEnd(strecke);
        if (startEnd == null) {
            return null;
        }
        Strecke_Punkt start = startEnd[0];
        GEO_Knoten _geoKnoten = StreckePunktExtensions.getGeoKnoten(start);
        BigDecimal _wert = start.getStreckeMeter().getWert();
        BigDecimal _minus = kilometer.subtract(_wert);
        return GeoKnotenExtensions.getCoordinate(_geoKnoten, null, (Basis_Objekt)strecke, _minus, BigDecimal.ZERO, ENUMWirkrichtung.ENUM_WIRKRICHTUNG_IN);
    }

    public static Strecke_Punkt[] getStartEnd(Strecke strecke) {
        BigDecimal _wert_1;
        boolean _lessThan_1;
        boolean _lessThan;
        Functions.Function1 _function = sp -> {
            Iterable<GEO_Kante> edges;
            GEO_Knoten _geoKnoten = null;
            if (sp != null) {
                _geoKnoten = StreckePunktExtensions.getGeoKnoten(sp);
            }
            Iterable<GEO_Kante> _geoKanten = null;
            if (_geoKnoten != null) {
                _geoKanten = GeoKnotenExtensions.getGeoKanten(_geoKnoten);
            }
            return (edges = _geoKanten) != null && IterableExtensions.size(edges) == 1;
        };
        Iterable startEnd = IterableExtensions.filter(StreckeExtensions.getStreckenPunkte(strecke), (Functions.Function1)_function);
        int _size = IterableExtensions.size((Iterable)startEnd);
        boolean bl = _lessThan = _size < 2;
        if (_lessThan) {
            return null;
        }
        Strecke_Punkt pointA = ((Strecke_Punkt[])Conversions.unwrapArray((Object)startEnd, Strecke_Punkt.class))[0];
        Strecke_Punkt pointB = ((Strecke_Punkt[])Conversions.unwrapArray((Object)startEnd, Strecke_Punkt.class))[1];
        BigDecimal _wert = pointA.getStreckeMeter().getWert();
        boolean bl2 = _lessThan_1 = _wert.compareTo(_wert_1 = pointB.getStreckeMeter().getWert()) < 0;
        if (_lessThan_1) {
            return (Strecke_Punkt[])Conversions.unwrapArray((Object)startEnd, Strecke_Punkt.class);
        }
        return new Strecke_Punkt[]{pointB, pointA};
    }

    public static BigDecimal getStreckeLength(Strecke strecke) {
        Functions.Function1 _function = it -> {
            BigDecimal _wert = it.getBegrenzungB().getWert();
            BigDecimal _wert_1 = it.getBegrenzungA().getWert();
            return _wert.subtract(_wert_1);
        };
        Functions.Function2 _function_1 = (p1, p2) -> p1.add((BigDecimal)p2);
        return (BigDecimal)IterableExtensions.reduce((Iterable)ListExtensions.map((List)strecke.getBereichObjektTeilbereich(), (Functions.Function1)_function), (Functions.Function2)_function_1);
    }
}

