/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.ppmodel.extensions;

import java.math.BigDecimal;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.set.model.planpro.Balisentechnik_ETCS.ETCS_Knoten;
import org.eclipse.set.model.planpro.Balisentechnik_ETCS.Knoten_Auf_TOP_Kante_AttributeGroup;
import org.eclipse.set.model.planpro.Geodaten.TOP_Kante;
import org.eclipse.set.model.planpro.Geodaten.TOP_Knoten;
import org.eclipse.set.ppmodel.extensions.BasisObjektExtensions;
import org.eclipse.set.ppmodel.extensions.EObjectExtensions;
import org.eclipse.set.ppmodel.extensions.TopKanteExtensions;
import org.eclipse.set.ppmodel.extensions.TopKnotenExtensions;

public class ETCSKnotenExtensions
extends BasisObjektExtensions {
    public static Map<TOP_Kante, BigDecimal> getKnotenPosition(ETCS_Knoten etcsNode) {
        TOP_Knoten topNode = EObjectExtensions.getNullableObject(etcsNode, node -> node.getIDTOPKnoten().getValue()).orElse(null);
        if (topNode != null) {
            return TopKnotenExtensions.getTopKanten(topNode).stream().map(topEdge -> {
                if (topNode == TopKanteExtensions.getTOPKnotenA(topEdge)) {
                    return Map.entry(topEdge, BigDecimal.ZERO);
                }
                if (topNode == TopKanteExtensions.getTOPKnotenB(topEdge)) {
                    return Map.entry(topEdge, topEdge.getTOPKanteAllg().getTOPLaenge().getWert());
                }
                throw new IllegalArgumentException(String.format("The TOP_Knoten %s isn't start or end node of TOP_Kante %s", topNode.getIdentitaet().getWert(), topEdge.getIdentitaet().getWert()));
            }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        }
        Knoten_Auf_TOP_Kante_AttributeGroup positionOnTopEdge = EObjectExtensions.getNullableObject(etcsNode, ETCS_Knoten::getKnotenAufTOPKante).orElse(null);
        if (positionOnTopEdge == null) {
            throw new IllegalArgumentException(String.format("Can't find position of ETCS_Knoten %s on TOP_Kante", etcsNode.getIdentitaet().getWert()));
        }
        return positionOnTopEdge.getPunktObjektTOPKante().stream().collect(Collectors.toMap(potk -> potk.getIDTOPKante().getValue(), potk -> potk.getAbstand().getWert()));
    }
}

