/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.model.tablemodel.format;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum TextAlignment implements Enumerator
{
    CENTER(0, "CENTER", "center"),
    LEFT(1, "LEFT", "left"),
    RIGHT(2, "RIGHT", "right");

    public static final int CENTER_VALUE = 0;
    public static final int LEFT_VALUE = 1;
    public static final int RIGHT_VALUE = 2;
    private static final TextAlignment[] VALUES_ARRAY;
    public static final List<TextAlignment> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new TextAlignment[]{CENTER, LEFT, RIGHT};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static TextAlignment get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            TextAlignment result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static TextAlignment getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            TextAlignment result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static TextAlignment get(int value) {
        switch (value) {
            case 0: {
                return CENTER;
            }
            case 1: {
                return LEFT;
            }
            case 2: {
                return RIGHT;
            }
        }
        return null;
    }

    private TextAlignment(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

