/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.feature.table.abstracttableview;

import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.config.CellConfigAttributes;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.data.IDataProvider;
import org.eclipse.nebula.widgets.nattable.grid.layer.GridLayer;
import org.eclipse.nebula.widgets.nattable.layer.AbstractLayer;
import org.eclipse.nebula.widgets.nattable.layer.DataLayer;
import org.eclipse.nebula.widgets.nattable.painter.cell.decorator.LineBorderDecorator;
import org.eclipse.nebula.widgets.nattable.style.BorderStyle;
import org.eclipse.nebula.widgets.nattable.style.CellStyleAttributes;
import org.eclipse.nebula.widgets.nattable.style.DisplayMode;
import org.eclipse.nebula.widgets.nattable.style.Style;
import org.eclipse.nebula.widgets.nattable.ui.action.IKeyAction;
import org.eclipse.nebula.widgets.nattable.ui.matcher.IKeyEventMatcher;
import org.eclipse.nebula.widgets.nattable.ui.matcher.KeyEventMatcher;
import org.eclipse.set.core.services.dialog.DialogService;
import org.eclipse.set.feature.table.abstracttableview.CsvExportAction;
import org.eclipse.set.model.tablemodel.ColumnDescriptor;
import org.eclipse.set.nattable.utils.PlanProTableThemeConfiguration;
import org.eclipse.set.utils.Colors;
import org.eclipse.set.utils.ToolboxConfiguration;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;

public class ToolboxTableModelThemeConfiguration
extends PlanProTableThemeConfiguration {
    private static final RGB TOPOLOGICAL_CELL_BG_COLOR = new RGB(232, 232, 232);
    private static final float SCALE_CM_TO_PIXEL = ToolboxConfiguration.getTablesScaleFactor();
    private final Style topologicalCellStyle;

    public static int toPixel(float length) {
        return Math.round(length * SCALE_CM_TO_PIXEL);
    }

    public ToolboxTableModelThemeConfiguration(NatTable natTable, AbstractLayer headerLayer, DataLayer dataLayer, GridLayer gridLayer, ColumnDescriptor heading, AbstractLayer bodyLayer, IDataProvider bodyDataProvider, DialogService dialogService) {
        super(natTable, headerLayer, dataLayer, gridLayer, heading, bodyLayer, bodyDataProvider);
        natTable.getUiBindingRegistry().registerKeyBinding((IKeyEventMatcher)new KeyEventMatcher(SWT.MOD1, 114), (IKeyAction)new CsvExportAction(dialogService));
        this.topologicalCellStyle = new Style();
        this.topologicalCellStyle.setAttributeValue(CellStyleAttributes.BACKGROUND_COLOR, (Object)new Color(TOPOLOGICAL_CELL_BG_COLOR));
    }

    public void configureRegistry(IConfigRegistry configRegistry) {
        super.configureRegistry(configRegistry);
        this.registerCompareTableCellStyle(configRegistry);
        this.registerTopologicalTableCellStyle(configRegistry);
    }

    private void registerCompareTableCellStyle(IConfigRegistry configRegistry) {
        LineBorderDecorator lineBorderDecorator = new LineBorderDecorator(this.defaultCellPainter, new BorderStyle(1, new Color(Colors.parseHexCode((String)"#0066FF")), BorderStyle.LineStyleEnum.SOLID));
        configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, (Object)lineBorderDecorator, DisplayMode.NORMAL, "tableCompareCell");
    }

    private void registerTopologicalTableCellStyle(IConfigRegistry configRegistry) {
        configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, (Object)this.topologicalCellStyle, DisplayMode.NORMAL, "topologicalCell");
    }
}

