/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.feature.table.abstracttableview;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.Optional;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.command.ILayerCommand;
import org.eclipse.nebula.widgets.nattable.export.ExportConfigAttributes;
import org.eclipse.nebula.widgets.nattable.export.command.ExportCommand;
import org.eclipse.nebula.widgets.nattable.ui.action.IKeyAction;
import org.eclipse.set.core.services.Services;
import org.eclipse.set.core.services.dialog.DialogService;
import org.eclipse.set.nattable.utils.ReferenceTableExporter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.widgets.Shell;

public class CsvExportAction
implements IKeyAction {
    private static final String DEFAULT_FILENAME = "csv_reference.csv";
    private final DialogService dialogService;

    public CsvExportAction(DialogService dialogService) {
        this.dialogService = dialogService;
    }

    public void run(NatTable natTable, KeyEvent event) {
        ReferenceTableExporter exporter = new ReferenceTableExporter(){

            public OutputStream getOutputStream(Shell shell) {
                Optional path;
                block3: {
                    try {
                        path = CsvExportAction.this.dialogService.saveFileDialog(shell, CsvExportAction.this.dialogService.getCsvFileFilters(), Services.getUserConfigurationService().getLastExportPath(), CsvExportAction.DEFAULT_FILENAME);
                        if (!path.isEmpty()) break block3;
                        return null;
                    }
                    catch (FileNotFoundException e) {
                        throw new RuntimeException(e);
                    }
                }
                return new FileOutputStream(((Path)path.get()).toString());
            }
        };
        Shell shell = natTable.getShell();
        exporter.setExportEnd(s -> {
            this.dialogService.reportExported(shell);
            return null;
        });
        natTable.getConfigRegistry().registerConfigAttribute(ExportConfigAttributes.EXPORTER, (Object)exporter);
        natTable.doCommand((ILayerCommand)new ExportCommand(natTable.getConfigRegistry(), shell));
    }
}

