/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.basis.graph;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.set.basis.graph.Digraph;
import org.eclipse.set.basis.graph.DirectedEdge;

public abstract class AbstractDigraph<E, N, P>
implements Digraph<E, N, P> {
    @Override
    public Set<DirectedEdge<E, N, P>> getDirectPredecessors(DirectedEdge<E, N, P> edge) {
        HashSet result = new HashSet();
        for (DirectedEdge e : this.getEdges()) {
            if (e.getHead() != edge.getTail()) continue;
            result.add(e);
        }
        return result;
    }

    @Override
    public Set<N> getDirectPredecessors(N node) {
        HashSet result = new HashSet();
        for (DirectedEdge e : this.getEdges()) {
            if (e.getHead() != node) continue;
            result.add(e.getTail());
        }
        return result;
    }

    @Override
    public Set<DirectedEdge<E, N, P>> getDirectSuccessors(DirectedEdge<E, N, P> edge) {
        HashSet result = new HashSet();
        for (DirectedEdge e : this.getEdges()) {
            if (e.getTail() != edge.getHead()) continue;
            result.add(e);
        }
        return result;
    }

    @Override
    public Set<N> getDirectSuccessors(N node) {
        HashSet result = new HashSet();
        for (DirectedEdge e : this.getEdges()) {
            if (e.getTail() != node) continue;
            result.add(e.getHead());
        }
        return result;
    }

    @Override
    public DirectedEdge<E, N, P> getEdge(N tail, N head) {
        Set<DirectedEdge<E, N, P>> result = this.getEdges(tail, head);
        if (result.size() == 1) {
            return result.iterator().next();
        }
        return null;
    }

    @Override
    public Set<DirectedEdge<E, N, P>> getEdges(N tail, N head) {
        HashSet result = new HashSet();
        for (DirectedEdge edge : this.getEdges()) {
            if (!edge.getTail().equals(tail) || !edge.getHead().equals(head)) continue;
            result.add(edge);
        }
        return result;
    }

    @Override
    public Set<N> getNodes() {
        HashSet result = new HashSet();
        for (DirectedEdge e : this.getEdges()) {
            result.add(e.getTail());
            result.add(e.getHead());
        }
        return result;
    }
}

