/*
 * Decompiled with CFR 0.152.
 */
package org.apfloat;

import org.apfloat.Apfloat;
import org.apfloat.ApfloatHelper;
import org.apfloat.ApfloatMath;
import org.apfloat.ApfloatRuntimeException;

class EulerHelper {
    private static final double ALPHA = 3.591121476668622;
    private final Apfloat n2;
    private final long precision;
    private final int radix;

    private EulerHelper(Apfloat n2, long precision, int radix) throws ApfloatRuntimeException {
        this.n2 = n2;
        this.precision = precision;
        this.radix = radix;
    }

    public static Apfloat euler(long precision, int radix) throws ApfloatRuntimeException {
        ApfloatMath.ApfloatHolder Q = new ApfloatMath.ApfloatHolder();
        ApfloatMath.ApfloatHolder R = new ApfloatMath.ApfloatHolder();
        ApfloatMath.ApfloatHolder S = new ApfloatMath.ApfloatHolder();
        ApfloatMath.ApfloatHolder U = new ApfloatMath.ApfloatHolder();
        long workingPrecision = ApfloatHelper.extendPrecision(precision);
        long n = ApfloatHelper.extendPrecision((long)((double)precision * Math.log(radix) / 4.0));
        long terms = (long)(3.591121476668622 * (double)n);
        Apfloat nn = new Apfloat(n, workingPrecision, radix);
        Apfloat n2 = nn.multiply(nn);
        new EulerHelper(n2, workingPrecision, radix).euler(0L, terms, null, Q, R, S, null, U, null);
        return U.getApfloat().divide(Q.getApfloat().multiply(R.getApfloat().add(S.getApfloat()))).subtract(ApfloatMath.log(nn)).precision(precision);
    }

    private void euler(long a, long b, ApfloatMath.ApfloatHolder P, ApfloatMath.ApfloatHolder Q, ApfloatMath.ApfloatHolder R, ApfloatMath.ApfloatHolder S, ApfloatMath.ApfloatHolder T, ApfloatMath.ApfloatHolder U, ApfloatMath.ApfloatHolder V) throws ApfloatRuntimeException {
        assert (a < b);
        if (b - a == 1L) {
            Apfloat bb = new Apfloat(b, this.precision, this.radix);
            Apfloat b2 = bb.multiply(bb);
            if (P != null) {
                P.setApfloat(new Apfloat(1L, this.precision, this.radix));
            }
            Q.setApfloat(bb);
            R.setApfloat(this.n2);
            S.setApfloat(b2);
            if (T != null) {
                T.setApfloat(this.n2);
            }
            U.setApfloat(this.n2);
            if (V != null) {
                V.setApfloat(b2.multiply(bb));
            }
        } else {
            long m = a + b >>> 1;
            ApfloatMath.ApfloatHolder LP = new ApfloatMath.ApfloatHolder();
            ApfloatMath.ApfloatHolder LQ = new ApfloatMath.ApfloatHolder();
            ApfloatMath.ApfloatHolder LR = new ApfloatMath.ApfloatHolder();
            ApfloatMath.ApfloatHolder LS = new ApfloatMath.ApfloatHolder();
            ApfloatMath.ApfloatHolder LT = new ApfloatMath.ApfloatHolder();
            ApfloatMath.ApfloatHolder LU = new ApfloatMath.ApfloatHolder();
            ApfloatMath.ApfloatHolder LV = new ApfloatMath.ApfloatHolder();
            ApfloatMath.ApfloatHolder RP = new ApfloatMath.ApfloatHolder();
            ApfloatMath.ApfloatHolder RQ = new ApfloatMath.ApfloatHolder();
            ApfloatMath.ApfloatHolder RR = new ApfloatMath.ApfloatHolder();
            ApfloatMath.ApfloatHolder RS = new ApfloatMath.ApfloatHolder();
            ApfloatMath.ApfloatHolder RT = new ApfloatMath.ApfloatHolder();
            ApfloatMath.ApfloatHolder RU = new ApfloatMath.ApfloatHolder();
            ApfloatMath.ApfloatHolder RV = new ApfloatMath.ApfloatHolder();
            this.euler(a, m, LP, LQ, LR, LS, LT, LU, V != null ? LV : null);
            this.euler(m, b, P != null ? RP : null, RQ, RR, RS, T != null ? RT : null, RU, RV);
            if (P != null) {
                P.setApfloat(LP.getApfloat().multiply(RQ.getApfloat()).add(LQ.getApfloat().multiply(RP.getApfloat())));
            }
            Q.setApfloat(LQ.getApfloat().multiply(RQ.getApfloat()));
            R.setApfloat(LR.getApfloat().multiply(RS.getApfloat()).add(LT.getApfloat().multiply(RR.getApfloat())));
            S.setApfloat(LS.getApfloat().multiply(RS.getApfloat()));
            if (T != null) {
                T.setApfloat(LT.getApfloat().multiply(RT.getApfloat()));
            }
            U.setApfloat(LU.getApfloat().multiply(RV.getApfloat()).add(LP.getApfloat().multiply(LT.getApfloat()).multiply(RQ.getApfloat()).multiply(RR.getApfloat())).add(LQ.getApfloat().multiply(LT.getApfloat()).multiply(RU.getApfloat())));
            if (V != null) {
                V.setApfloat(LV.getApfloat().multiply(RV.getApfloat()));
            }
        }
    }
}

