/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.emfforms.utils;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.set.basis.DomainElementList;
import org.eclipse.set.basis.MediaInfo;
import org.eclipse.set.basis.commands.AddAttachmentData;

public class DomainElementListImpl<T, I extends MediaInfo<T>>
implements DomainElementList<T, I> {
    private Adapter adapter;
    private final EObject container;
    private final EStructuralFeature containingFeature;
    private final EStructuralFeature feature;
    final List<DomainElementList.ChangeListener<T>> changeListenerList = new LinkedList<DomainElementList.ChangeListener<T>>();

    public DomainElementListImpl(EObject container, EStructuralFeature feature, EStructuralFeature containingFeature) {
        this.container = container;
        this.feature = feature;
        this.containingFeature = containingFeature;
    }

    public void add(I mediaInfo) {
        EditingDomain editingDomain = AdapterFactoryEditingDomain.getEditingDomainFor((EObject)this.container);
        CompoundCommand compoundAddCommand = new CompoundCommand();
        Command addCommand = AddCommand.create((EditingDomain)editingDomain, (Object)this.container, (Object)this.feature, (Object)mediaInfo.getElement());
        compoundAddCommand.append(addCommand);
        if (mediaInfo.getToolboxFile().hasDetachedAttachments()) {
            AddAttachmentData addAttachmentDataCommand = AddAttachmentData.create(mediaInfo);
            compoundAddCommand.append((Command)addAttachmentDataCommand);
        }
        CommandStack commandStack = editingDomain.getCommandStack();
        commandStack.execute((Command)compoundAddCommand);
        this.refreshAdapter();
    }

    public void addChangeListener(DomainElementList.ChangeListener<T> changeListener) {
        if (this.adapter == null) {
            this.adapter = new EContentAdapter(){

                public void notifyChanged(Notification msg) {
                    if (msg.getEventType() != 8) {
                        for (DomainElementList.ChangeListener listener : DomainElementListImpl.this.changeListenerList) {
                            listener.listChanged(msg);
                        }
                    }
                }
            };
            this.container.eAdapters().add((Object)this.adapter);
        }
        this.changeListenerList.add(changeListener);
    }

    public EObject getContainer() {
        return this.container;
    }

    public EStructuralFeature getContainingFeature() {
        return this.containingFeature;
    }

    public List<T> getElements() {
        EList elements = (EList)this.container.eGet(this.feature);
        return elements;
    }

    public EStructuralFeature getFeature() {
        return this.feature;
    }

    public void remove(T element) {
        EditingDomain editingDomain = AdapterFactoryEditingDomain.getEditingDomainFor((EObject)this.container);
        Command removeCommand = RemoveCommand.create((EditingDomain)editingDomain, (Object)this.container, (Object)this.feature, element);
        CommandStack commandStack = editingDomain.getCommandStack();
        commandStack.execute(removeCommand);
    }

    public void removeChangeListener(DomainElementList.ChangeListener<T> changeListener) {
        this.changeListenerList.remove(changeListener);
        if (this.changeListenerList.isEmpty() && this.adapter != null) {
            this.container.eAdapters().remove((Object)this.adapter);
            this.adapter = null;
        }
    }

    private void refreshAdapter() {
        this.container.eAdapters().remove((Object)this.adapter);
        this.container.eAdapters().add((Object)this.adapter);
    }
}

