/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.utils.handler;

import jakarta.inject.Inject;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Path;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.core.services.nls.Translation;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.menu.MDirectMenuItem;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.set.basis.IModelSession;
import org.eclipse.set.basis.Wrapper;
import org.eclipse.set.basis.files.ToolboxFileRole;
import org.eclipse.set.core.services.dialog.DialogService;
import org.eclipse.set.core.services.part.ToolboxPartService;
import org.eclipse.set.core.services.session.SessionService;
import org.eclipse.set.core.services.update.ModelUpdateService;
import org.eclipse.set.utils.Messages;
import org.eclipse.set.utils.handler.AbstractHandler;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractOpenHandler
extends AbstractHandler {
    static final Logger logger = LoggerFactory.getLogger(AbstractOpenHandler.class);
    @Inject
    private DialogService dialogService;
    private MDirectMenuItem menuItem;
    @Inject
    private IEventBroker eventBroker;
    @Inject
    @Translation
    private Messages messages;
    @Inject
    @Optional
    protected IModelSession oldModelSession;
    @Inject
    private ToolboxPartService toolboxViewService;
    @Inject
    protected SessionService sessionService;
    @Inject
    ModelUpdateService modelUpdateService;

    public DialogService getDialogService() {
        return this.dialogService;
    }

    public MDirectMenuItem getMenuItem() {
        return this.menuItem;
    }

    protected void loadSession(Shell shell, MApplication application) {
        this.closeOldSession(shell);
        final Path path = this.chooseFile(shell);
        if (path == null) {
            return;
        }
        final Wrapper newSessionWrapper = new Wrapper();
        newSessionWrapper.setValue(null);
        IRunnableWithProgress loadFileThread = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                monitor.beginTask(AbstractOpenHandler.this.getTaskMessage(), -1);
                logger.trace("Loading session...");
                newSessionWrapper.setValue((Object)AbstractOpenHandler.this.createSession(path));
                ((IModelSession)newSessionWrapper.getValue()).getModels().forEach(m -> AbstractOpenHandler.this.modelUpdateService.add(m));
                monitor.done();
                logger.trace("Loading session done.");
            }
        };
        try {
            new ProgressMonitorDialog(shell).run(true, false, loadFileThread);
        }
        catch (InvocationTargetException ex) {
            Throwable cause = ex.getCause();
            logger.error("Validation error", cause);
            AbstractOpenHandler.reportError(shell, ex, this.dialogService, this.getErrorTitleMessage(), this.getErrorMessage(), this.getErrorCauseMessage());
            newSessionWrapper.setValue(null);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        newSessionWrapper.setValue((Object)this.validation((IModelSession)newSessionWrapper.getValue(), shell, path));
        if (newSessionWrapper.getValue() != null) {
            this.success((IModelSession)newSessionWrapper.getValue(), application);
        }
        logger.trace("Execute done.");
    }

    protected void closeOldSession(Shell shell) {
        if (this.oldModelSession != null && this.oldModelSession.isDirty() && !this.dialogService.confirmCloseUnsaved(shell)) {
            return;
        }
        if (this.oldModelSession != null) {
            this.oldModelSession.close();
        }
    }

    protected abstract Path chooseFile(Shell var1);

    protected abstract IModelSession createSession(Path var1);

    @Execute
    protected void execute(Shell shell, MApplication application, @Optional MDirectMenuItem item) {
        this.menuItem = item;
        this.loadSession(shell, application);
    }

    protected abstract String getErrorCauseMessage();

    protected abstract String getErrorMessage();

    protected abstract String getErrorTitleMessage();

    protected abstract String getTaskMessage();

    protected abstract ToolboxFileRole getRole();

    protected void success(IModelSession modelSession, MApplication application) {
        application.getContext().set(IModelSession.class, (Object)modelSession);
        this.eventBroker.send("modelsession/change/model", (Object)modelSession);
        this.toolboxViewService.showDefaultPart(null);
        this.toolboxViewService.showDefaultPart(modelSession);
    }

    protected abstract IModelSession validation(IModelSession var1, Shell var2, Path var3);
}

