/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.core.dialogservice;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public abstract class AbstractDialogWithIcon
extends MessageDialog {
    protected AbstractDialogWithIcon(Shell parentShell, String dialogTitle, String message, String ... buttonsLabel) {
        super(parentShell, dialogTitle, null, message, 3, buttonsLabel, 1);
    }

    protected abstract URI getIconURI() throws URISyntaxException;

    public Image getImage() {
        try {
            return ImageDescriptor.createFromURL((URL)this.getIconURI().toURL()).createImage();
        }
        catch (MalformedURLException | URISyntaxException e) {
            return null;
        }
    }

    protected Control createMessageArea(Composite composite) {
        Image image = this.getImage();
        GridLayout gridLayout = new GridLayout(2, false);
        composite.setLayout((Layout)gridLayout);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        if (image != null) {
            this.imageLabel = new Label(composite, 0);
            image.setBackground(this.imageLabel.getBackground());
            this.imageLabel.setImage(image);
        }
        if (this.message != null) {
            this.messageLabel = new Label(composite, this.getMessageLabelStyle());
            this.messageLabel.setText(this.message);
            GridDataFactory.fillDefaults().align(4, 1).grab(true, false).hint(this.convertHorizontalDLUsToPixels(300), -1).applyTo((Control)this.messageLabel);
        }
        return composite;
    }
}

