/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.feature.export.tm;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import org.eclipse.set.basis.FreeFieldInfo;
import org.eclipse.set.basis.OverwriteHandling;
import org.eclipse.set.basis.ToolboxPaths;
import org.eclipse.set.basis.constants.ExportType;
import org.eclipse.set.basis.constants.TableType;
import org.eclipse.set.basis.exceptions.FileExportException;
import org.eclipse.set.model.tablemodel.Table;
import org.eclipse.set.model.tablemodel.extensions.TableExtensions;
import org.eclipse.set.model.titlebox.Titlebox;
import org.eclipse.set.services.export.TableExport;
import org.eclipse.set.utils.ToolboxConfiguration;
import org.osgi.service.component.annotations.Component;

@Component(immediate=true)
public class TableModelExport
implements TableExport {
    public void export(Map<TableType, Table> tables, ExportType exportType, Titlebox titlebox, FreeFieldInfo freeFieldInfo, String shortcut, String outputDir, ToolboxPaths toolboxPaths, TableType tableType, OverwriteHandling overwriteHandling) throws FileExportException {
        if (!ToolboxConfiguration.isDevelopmentMode()) {
            return;
        }
        Path filepath = toolboxPaths.getTableExportPath(shortcut, Paths.get(outputDir, new String[0]), exportType, ToolboxPaths.ExportPathExtension.TABLE_MODEL_EXPORT_EXTENSION);
        Table finalTable = tables.get(TableType.FINAL);
        Table singleTable = tables.get(TableType.SINGLE);
        try {
            TableExtensions.save((Table)(finalTable != null ? finalTable : singleTable), (Path)filepath);
        }
        catch (IOException e) {
            throw new FileExportException(filepath, (Throwable)e);
        }
    }

    public void exportTitleboxImage(Titlebox titlebox, Path imagePath, OverwriteHandling overwriteHandling) throws Exception {
    }

    public void exportTitleboxPdf(Titlebox titlebox, Path pdfPath, OverwriteHandling overwriteHandling) throws Exception {
    }

    public String getTableShortcut() {
        throw new UnsupportedOperationException();
    }

    public TableExport.ExportFormat getExportFormat() {
        return TableExport.ExportFormat.TABLE_MODEL;
    }

    public void exportSiteplanPdf(List<BufferedImage> imagesData, Titlebox titleBox, FreeFieldInfo freeFieldInfo, double ppm, String outputDir, ToolboxPaths toolboxPaths, TableType tableType, OverwriteHandling overwriteHandling) {
    }
}

