/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.feature.export.pdf;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.pdfbox.io.MemoryUsageSetting;
import org.apache.pdfbox.multipdf.PDFMergerUtility;
import org.apache.poi.UnsupportedFileFormatException;
import org.eclipse.set.basis.FreeFieldInfo;
import org.eclipse.set.basis.OverwriteHandling;
import org.eclipse.set.basis.Pair;
import org.eclipse.set.basis.ToolboxPaths;
import org.eclipse.set.basis.constants.ExportType;
import org.eclipse.set.basis.constants.TableType;
import org.eclipse.set.basis.exceptions.FileExportException;
import org.eclipse.set.core.services.enumtranslation.EnumTranslationService;
import org.eclipse.set.feature.export.pdf.FopPdfExportBuilder;
import org.eclipse.set.feature.export.pdf.TableToTableDocument;
import org.eclipse.set.model.tablemodel.Table;
import org.eclipse.set.model.titlebox.Titlebox;
import org.eclipse.set.services.export.TableExport;
import org.eclipse.set.services.fop.FopService;
import org.eclipse.set.utils.ToolboxConfiguration;
import org.eclipse.set.utils.export.xsl.TransformTable;
import org.eclipse.set.utils.export.xsl.siteplan.SiteplanXSL;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

@Component(immediate=true, service={TableExport.class})
public class SiteplanPdfExportBuilder
extends FopPdfExportBuilder {
    private static final String SITEPLAN_EXPORT_NAME = "SI";
    private static final String SITEPLAN_TMP_DIR = "siteplanTmp";

    @Override
    @Reference(cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.STATIC, unbind="-")
    public void setEnumTranslationService(EnumTranslationService enumTranslationService) {
        this.enumTranslationService = enumTranslationService;
    }

    @Override
    @Reference(cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.STATIC, unbind="-")
    public void setFopService(FopService fopService) {
        this.fopService = fopService;
    }

    private static String createImageDocumentText(BufferedImage imageData, Titlebox titleBox, FreeFieldInfo freeFieldInfo, double ppm) throws ParserConfigurationException, TransformerException {
        TableToTableDocument tableToXmlFo = TableToTableDocument.createTransformation();
        Document document = tableToXmlFo.transformToDocument(imageData, titleBox, freeFieldInfo, ppm);
        Transformer documentToString = SiteplanPdfExportBuilder.newTransformerFactory().newTransformer();
        DOMSource source = new DOMSource(document);
        StringWriter writer = new StringWriter();
        StreamResult result = new StreamResult(writer);
        documentToString.transform(source, result);
        return writer.toString();
    }

    @Override
    public void exportTitleboxImage(Titlebox titlebox, Path imagePath, OverwriteHandling overwriteHandling) throws Exception {
    }

    @Override
    public void exportTitleboxPdf(Titlebox titlebox, Path pdfPath, OverwriteHandling overwriteHandling) throws Exception {
    }

    @Override
    public void export(Map<TableType, Table> tables, ExportType exportType, Titlebox titlebox, FreeFieldInfo freeFieldInfo, String shortcut, String outputDir, ToolboxPaths toolboxPaths, TableType tableType, OverwriteHandling overwriteHandling) throws FileExportException {
    }

    @Override
    public void exportSiteplanPdf(List<BufferedImage> imagesData, Titlebox titleBox, FreeFieldInfo freeFieldInfo, double ppm, String outputDir, ToolboxPaths toolboxPaths, TableType tableType, OverwriteHandling overwriteHandling) {
        File[] listFiles;
        Path exportTmpDir = Path.of(outputDir, SITEPLAN_TMP_DIR);
        if (!exportTmpDir.toFile().exists()) {
            exportTmpDir.toFile().mkdirs();
        } else if (exportTmpDir.toFile().isDirectory() && (listFiles = exportTmpDir.toFile().listFiles()) != null) {
            File[] fileArray = listFiles;
            int n = listFiles.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                file.delete();
                ++n2;
            }
        }
        PDFMergerUtility pdfMergerUtility = new PDFMergerUtility();
        pdfMergerUtility.setDestinationFileName(toolboxPaths.getTableExportPath(SITEPLAN_EXPORT_NAME, Paths.get(outputDir, new String[0]), ExportType.PLANNING_RECORDS, ToolboxPaths.ExportPathExtension.TABLE_PDF_EXPORT_EXTENSION).toString());
        try {
            int i = 0;
            while (i < imagesData.size()) {
                String imageDocumentText = SiteplanPdfExportBuilder.createImageDocumentText(imagesData.get(i), titleBox, freeFieldInfo, ppm);
                String siteplanExportName = "SI_" + i;
                if (ToolboxConfiguration.isDebugMode()) {
                    SiteplanPdfExportBuilder.exportTableDocument(Paths.get(exportTmpDir.toString(), SiteplanPdfExportBuilder.getFilename(siteplanExportName, "xml")), imageDocumentText);
                }
                ByteArrayInputStream tableDocumentStream = new ByteArrayInputStream(imageDocumentText.getBytes(StandardCharsets.UTF_8));
                StreamSource imageDocumentSource = new StreamSource(tableDocumentStream);
                String exportFileName = SiteplanPdfExportBuilder.getFilename(siteplanExportName, "xsl");
                String pagePostFix = i == imagesData.size() - 1 ? "-" : "+";
                Pair<String, StreamSource> xslStreamSource = this.getSiteplanXSLTemplate(imagesData.get(i), ppm, tableType, exportTmpDir.toString(), exportFileName, i + 1, pagePostFix);
                Path outputPath = toolboxPaths.getTableExportPath(String.format("%s_%s_%d", SITEPLAN_EXPORT_NAME, xslStreamSource.getFirst(), i), exportTmpDir, ExportType.PLANNING_RECORDS, ToolboxPaths.ExportPathExtension.TABLE_PDF_EXPORT_EXTENSION);
                this.fopService.fop(FopService.OutputFormat.PDF, (Source)xslStreamSource.getSecond(), (Source)imageDocumentSource, outputPath, FopService.PdfAMode.PDF_A_3a, overwriteHandling, null);
                pdfMergerUtility.addSource(outputPath.toFile());
                ++i;
            }
            pdfMergerUtility.mergeDocuments(MemoryUsageSetting.setupMainMemoryOnly());
        }
        catch (Exception e) {
            throw new FileExportException(Path.of(outputDir, SITEPLAN_EXPORT_NAME), (Throwable)e);
        }
        if (!ToolboxConfiguration.isDevelopmentMode() && exportTmpDir.toFile().exists()) {
            try {
                Throwable e = null;
                Object var13_17 = null;
                try (Stream<Path> paths = Files.walk(exportTmpDir, FileVisitOption.values());){
                    paths.sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
                }
                catch (Throwable throwable) {
                    if (e == null) {
                        e = throwable;
                    } else if (e != throwable) {
                        e.addSuppressed(throwable);
                    }
                    throw e;
                }
            }
            catch (IOException e) {
                throw new FileExportException(Path.of(outputDir, SITEPLAN_EXPORT_NAME), (Throwable)e);
            }
        }
    }

    private Pair<String, StreamSource> getSiteplanXSLTemplate(BufferedImage imageData, double ppm, TableType tableType, String outputDir, String exportFileName, int pagePosition, String pagePostfix) throws ParserConfigurationException, SAXException, IOException, NullPointerException, TransformerException, UnsupportedFileFormatException {
        SiteplanXSL siteplanXSL = new SiteplanXSL(imageData, ppm, this.translationTableType(tableType), pagePosition, pagePostfix);
        Document xslDoc = siteplanXSL.getXSLDocument();
        String pageDIN = siteplanXSL.getPageStyle().getPageDIN().toString();
        if (ToolboxConfiguration.isDebugMode()) {
            Transformer documentToString = SiteplanPdfExportBuilder.newTransformerFactory().newTransformer();
            DOMSource source = new DOMSource(xslDoc);
            StringWriter writer = new StringWriter();
            StreamResult result = new StreamResult(writer);
            documentToString.transform(source, result);
            SiteplanPdfExportBuilder.exportTableDocument(Path.of(outputDir, exportFileName), writer.toString());
        }
        return new Pair((Object)pageDIN, (Object)TransformTable.toStreamSource((Document)xslDoc));
    }
}

