/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.feature.plazmodel.check;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.eclipse.set.feature.plazmodel.check.AbstractPlazContainerCheck;
import org.eclipse.set.feature.plazmodel.check.PlazCheck;
import org.eclipse.set.model.plazmodel.PlazError;
import org.eclipse.set.model.plazmodel.PlazFactory;
import org.eclipse.set.model.validationreport.ValidationSeverity;
import org.eclipse.set.ppmodel.extensions.container.MultiContainer_AttributeGroup;
import org.osgi.service.component.annotations.Component;

@Component(service={PlazCheck.class})
public class MultiCRSCheck
extends AbstractPlazContainerCheck
implements PlazCheck {
    @Override
    public String checkType() {
        return "Mehrfache Koordinatensystem";
    }

    @Override
    public String getDescription() {
        return "Instanzen von GEO_Punkt_Allg haben ein konsistentes Koordinatensystem.";
    }

    @Override
    public String getGeneralErrMsg() {
        return "Es gibt Objekte in unterschiedlichen Koordinatensystemen. Der sicherungstechnische Lageplan kann unvollst\u00e4ndig sein.";
    }

    @Override
    protected List<PlazError> run(MultiContainer_AttributeGroup container) {
        Set crsList = StreamSupport.stream(container.getGEOPunkt().spliterator(), false).map(gp -> {
            try {
                return gp.getGEOPunktAllg().getGEOKoordinatensystem().getWert();
            }
            catch (NullPointerException e) {
                return null;
            }
        }).collect(Collectors.toSet());
        if (crsList.size() > 1) {
            PlazError error = PlazFactory.eINSTANCE.createPlazError();
            error.setMessage(this.getGeneralErrMsg());
            error.setSeverity(ValidationSeverity.WARNING);
            error.setType(this.checkType());
            error.setObject(null);
            return List.of(error);
        }
        return Collections.emptyList();
    }
}

