/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.application.parts;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.annotation.PreDestroy;
import jakarta.inject.Inject;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.e4.core.services.nls.Translation;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.set.application.Messages;
import org.eclipse.set.basis.IModelSession;
import org.eclipse.set.basis.Pair;
import org.eclipse.set.basis.constants.TableType;
import org.eclipse.set.basis.files.ToolboxFileRole;
import org.eclipse.set.browser.RequestHandler;
import org.eclipse.set.core.services.cache.CacheService;
import org.eclipse.set.core.services.font.FontService;
import org.eclipse.set.model.planpro.PlanPro.Container_AttributeGroup;
import org.eclipse.set.model.validationreport.ContainerContent;
import org.eclipse.set.model.validationreport.ObjectScope;
import org.eclipse.set.utils.BasePart;
import org.eclipse.set.utils.FileWebBrowser;
import org.eclipse.set.utils.SaveAndRefreshAction;
import org.eclipse.set.utils.SelectableAction;
import org.eclipse.set.utils.events.ContainerDataChanged;
import org.eclipse.set.utils.events.EventRegistration;
import org.eclipse.set.utils.events.JumpToSourceLineEvent;
import org.eclipse.set.utils.events.ProjectDataChanged;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.osgi.service.event.EventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SourceWebTextViewPart
extends BasePart {
    private static final String JUMP_TO_LINE_FUNCTION = "window.planproJumpToLine";
    private static final String JUMP_TO_GUID_FUNCTION = "window.planproJumpToGuid";
    private static final String UPDATE_PROBLEMS_FUNCTION = "window.planproUpdateProblems";
    private static final String SWITCH_MODEL_VIEW_FUNCTION = "window.planproSwitchModel";
    private static final Logger LOGGER = LoggerFactory.getLogger(SourceWebTextViewPart.class);
    @Inject
    @Translation
    private Messages messages;
    @Inject
    IModelSession session;
    @Inject
    @Translation
    org.eclipse.set.utils.Messages utilMessages;
    @Inject
    FontService fontService;
    @Inject
    CacheService cacheService;
    private FileWebBrowser browser;
    private EventRegistration eventRegistration;
    private final EventHandler problemsChangeEventHandler = event -> this.onProblemsChange();
    private static final String TEXT_VIEWER_PATH = "./web/textviewer";
    private static final String PROBLEMS_JSON = "problems.json";
    private static final String MODEL_PPXML = "model.ppxml";
    private static final String LAYOUT_XML = "layout.xml";

    private void onProblemsChange() {
        this.browser.executeJavascript(String.format("%s()", UPDATE_PROBLEMS_FUNCTION));
    }

    protected void createView(Composite parent) {
        parent.setLayout((Layout)new FillLayout());
        this.browser = new FileWebBrowser(parent);
        try {
            this.browser.serveRootDirectory(Path.of(TEXT_VIEWER_PATH, new String[0]));
            this.browser.serveFile(MODEL_PPXML, "text/plain", this.session.getToolboxFile().getModelPath());
            this.browser.serveUri(PROBLEMS_JSON, this::serveProblems);
            this.browser.serveFile(LAYOUT_XML, "text/plain", this.session.getToolboxFile().getLayoutPath());
            this.browser.serveUri("font", this::serveFont);
            this.browser.setToolboxUrl("index.html");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (this.session.isDirty()) {
            this.setOutdated(true);
        }
        this.eventRegistration = new EventRegistration(this.getBroker());
        this.eventRegistration.registerHandler(JumpToSourceLineEvent.class, this::handleJumpToSourceLineEvent);
        this.getBroker().subscribe("modelsession/change/problems", this.problemsChangeEventHandler);
    }

    private void serveFont(RequestHandler.Response response) throws IOException {
        response.setMimeType("application/x-font-ttf");
        response.setResponseData(Files.newInputStream(this.fontService.getDefaultFont(), new OpenOption[0]));
    }

    private void serveProblems(RequestHandler.Request request, RequestHandler.Response response) throws JsonProcessingException {
        Iterable problems = this.cacheService.getCache(ToolboxFileRole.SESSION, "toolbox.cache.problem-message").values();
        ArrayList problemMessages = new ArrayList();
        problems.forEach(problemContainer -> {
            boolean bl = problemMessages.addAll((List)problemContainer);
        });
        response.setMimeType("application/json;charset=UTF-8");
        response.setStatus(200);
        response.setResponseData(new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString(problemMessages));
    }

    private void handleJumpToSourceLineEvent(JumpToSourceLineEvent event) {
        Pair lineNumber = event.getLineNumber();
        String objectGuid = event.getObjectGuid();
        if ((Integer)lineNumber.getSecond() != -1) {
            this.jumpToLine((Pair<ObjectScope, Integer>)lineNumber);
        } else if (objectGuid != null && !objectGuid.isEmpty()) {
            this.jumpToGUID(objectGuid);
        } else {
            LOGGER.warn("Invalid jump to line event ignored.");
        }
    }

    private void jumpToLine(Pair<ObjectScope, Integer> lineNumber) {
        String modelName = "";
        modelName = lineNumber.getFirst() == ObjectScope.LAYOUT ? ContainerContent.LAYOUT.getLiteral() : ContainerContent.MODEL.getLiteral();
        String js = String.format("{\n\tlet intervalId = 0\n\tconst jumpToLineWrapper = () => {\n\t\tif(%s) {\n\t\t\t%s('%s')\n\t\t}\n\t\tif(%s) {\n\t\t\t%s(%d);\n\t\t\tclearInterval(intervalId);\n\t\t}\n\t}\n\tintervalId = setInterval(jumpToLineWrapper, 100);\n}\n", SWITCH_MODEL_VIEW_FUNCTION, SWITCH_MODEL_VIEW_FUNCTION, modelName, JUMP_TO_LINE_FUNCTION, JUMP_TO_LINE_FUNCTION, (int)((Integer)lineNumber.getSecond()));
        this.browser.executeJavascript(js);
    }

    private void jumpToGUID(String guid) {
        TableType tableType = this.getModelSession().getTableType();
        if (tableType == null) {
            tableType = this.getModelSession().getNature().getDefaultContainer().getTableTypeForTables();
        }
        String tableState = "";
        switch (tableType) {
            case INITIAL: {
                tableState = "initial";
                break;
            }
            case FINAL: {
                tableState = "final";
                break;
            }
            case DIFF: {
                tableState = "diff";
                break;
            }
            case SINGLE: {
                tableState = "single";
                break;
            }
        }
        String js = String.format("{\n\tlet intervalId = 0\n\tconst jumpToLineWrapper = () => {\n\t\tif(%s) {\n\t\t\t%s('%s', '%s');\n\t\t\tclearInterval(intervalId);\n\t\t}\n\t}\n\tintervalId = setInterval(jumpToLineWrapper, 100);\n}\n", JUMP_TO_GUID_FUNCTION, JUMP_TO_GUID_FUNCTION, guid, tableState);
        this.browser.executeJavascript(js);
    }

    @PreDestroy
    private void preDestroy() {
        this.eventRegistration.unsubscribeAll();
        this.getBroker().unsubscribe(this.problemsChangeEventHandler);
    }

    protected SelectableAction getOutdatedAction() {
        return new SaveAndRefreshAction((BasePart)this);
    }

    protected void handleContainerDataChanged(ContainerDataChanged e) {
        this.setOutdated(true);
    }

    protected void handleProjectDataChanged(ProjectDataChanged e) {
        this.setOutdated(true);
    }

    protected void updateViewContainerDataChanged(List<Container_AttributeGroup> container) {
        this.updateViewer();
    }

    protected void updateViewer() {
        if (this.isOutdated()) {
            this.browser.refresh();
            this.setOutdated(false);
        }
    }

    protected void updateViewProjectDataChanged(List<Notification> notifications) {
        this.updateViewer();
    }
}

