/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.utils.table.export;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import org.eclipse.set.basis.ConsumerThrowingException;
import org.eclipse.set.basis.extensions.ConsumerThrowingExceptionExtension;
import org.eclipse.set.utils.ToolboxConfiguration;
import org.eclipse.xtend.lib.annotations.Accessors;

public class ExportToCSV<T> {
    byte[] utf8Bom = new byte[]{-17, -69, -65};
    String headerPatter;

    public ExportToCSV(String headerPattern) {
        this.headerPatter = headerPattern;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void exportToCSV(Optional<Path> filePath, List<T> dataToExport, Function<T, String> transformDataToString) {
        if (!filePath.isPresent()) return;
        HeaderInfo headerInfo = new HeaderInfo(filePath.get().toString());
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try {
                FileOutputStream fos = new FileOutputStream(filePath.get().toString());
                try {
                    try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)fos, StandardCharsets.UTF_8);){
                        fos.write(this.utf8Bom);
                        writer.write(String.format(this.headerPatter, headerInfo.file, headerInfo.time, headerInfo.version));
                        ConsumerThrowingException consumerException = t -> writer.write((String)transformDataToString.apply(t));
                        dataToExport.forEach(ConsumerThrowingExceptionExtension.rethrowException((ConsumerThrowingException)consumerException)::accept);
                    }
                    if (fos == null) return;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (fos == null) throw throwable;
                    fos.close();
                    throw throwable;
                }
                fos.close();
                return;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void exportToCSV(Optional<Path> filePath, List<String> dataToExport) {
        if (!filePath.isPresent()) return;
        HeaderInfo headerInfo = new HeaderInfo(filePath.get().toString());
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try {
                FileOutputStream fos = new FileOutputStream(filePath.get().toString());
                try {
                    try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)fos, StandardCharsets.UTF_8);){
                        fos.write(this.utf8Bom);
                        writer.write(String.format(this.headerPatter, headerInfo.file, headerInfo.time, headerInfo.version));
                        ConsumerThrowingException consumerException = writer::write;
                        dataToExport.forEach(ConsumerThrowingExceptionExtension.rethrowException((ConsumerThrowingException)consumerException)::accept);
                    }
                    if (fos == null) return;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (fos == null) throw throwable;
                    fos.close();
                    throw throwable;
                }
                fos.close();
                return;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static class HeaderInfo {
        @Accessors
        private final String file;
        @Accessors
        private final String time;
        @Accessors
        private final String version;

        public HeaderInfo(String filePath) {
            this.file = Paths.get(filePath, new String[0]).getFileName().toString();
            this.time = LocalDateTime.now().format(DateTimeFormatter.ofPattern("uuuu-MM-dd HH:mm:ss"));
            this.version = ToolboxConfiguration.getToolboxVersion().getLongVersion();
        }
    }
}

