/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.model.tablemodel.extensions;

import com.google.common.base.Function;
import java.util.Collection;
import org.eclipse.set.basis.tables.Tables;
import org.eclipse.set.model.tablemodel.ColumnDescriptor;
import org.eclipse.set.model.tablemodel.extensions.ColumnDescriptorExtensions;
import org.eclipse.set.utils.ToolboxConfiguration;

public class Headings {
    public static float getMaxHeight(Collection<ColumnDescriptor> headings) {
        float result = 0.0f;
        for (ColumnDescriptor v : headings) {
            double h = v.getHeight();
            if (!(h > (double)result)) continue;
            result = (float)h;
        }
        if (result == 0.0f) {
            result = ToolboxConfiguration.getDefaultHeight();
        }
        return result;
    }

    public static String getTreeString(ColumnDescriptor heading) {
        return Headings.getTreeString(heading, 0);
    }

    public static String getWidthTestCsv(ColumnDescriptor heading, Function<Float, Integer> toPixel) {
        int columns = ColumnDescriptorExtensions.getColumns(heading).size();
        StringBuilder result = new StringBuilder((columns + 1) * 12);
        result.append("Column;WidthExpected;WidthActual\n");
        int i = 0;
        while (i < columns) {
            result.append(Integer.toString(i + 1)).append(";").append(toPixel.apply((Object)ColumnDescriptorExtensions.getColumnWidth(heading, i))).append(";0\n");
            ++i;
        }
        return result.toString();
    }

    private static String getTreeString(ColumnDescriptor heading, int level) {
        StringBuilder result = new StringBuilder();
        int i = 0;
        while (i < level) {
            result.append("  ");
            ++i;
        }
        int columnIndex = ColumnDescriptorExtensions.getColumns(heading).indexOf(heading);
        if (columnIndex >= 0) {
            result.append(String.format("Column %d (id=%s greyed=%b width=%.2f cm): ", columnIndex, Tables.getColumnIdentifier((int)columnIndex), heading.isGreyed(), ColumnDescriptorExtensions.getColumnWidth(heading, columnIndex)));
        }
        if (ColumnDescriptorExtensions.isGroup(heading)) {
            result.append("Group: ");
        }
        if (ColumnDescriptorExtensions.isGroupGroup(heading)) {
            result.append("Group group: ");
        }
        if (ColumnDescriptorExtensions.isGroupGroupGroup(heading)) {
            result.append("Group group group: ");
        }
        result.append(String.format("\"%s\"", heading.getLabel()));
        result.append("\n");
        for (ColumnDescriptor child : heading.getChildren()) {
            result.append(Headings.getTreeString(child, level + 1));
        }
        return result.toString();
    }
}

