/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.ui.internal.project;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.SequencedCollection;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.scout.sdk.core.java.apidef.ApiVersion;
import org.eclipse.scout.sdk.core.log.SdkLog;
import org.eclipse.scout.sdk.core.s.project.ScoutProjectNewHelper;
import org.eclipse.scout.sdk.s2e.environment.AbstractJob;
import org.eclipse.scout.sdk.s2e.ui.fields.FieldToolkit;
import org.eclipse.scout.sdk.s2e.ui.fields.proposal.ProposalTextField;
import org.eclipse.scout.sdk.s2e.ui.fields.proposal.content.AbstractContentProviderAdapter;
import org.eclipse.scout.sdk.s2e.ui.fields.resource.ResourceTextField;
import org.eclipse.scout.sdk.s2e.ui.fields.text.StyledTextField;
import org.eclipse.scout.sdk.s2e.ui.wizard.AbstractWizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

public class ScoutProjectNewWizardPage
extends AbstractWizardPage {
    public static final String PROP_GROUP_ID = "groupId";
    public static final String PROP_ARTIFACT_ID = "artifactId";
    public static final String PROP_DISPLAY_NAME = "displayName";
    public static final String PROP_DIR = "dir";
    public static final String PROP_USE_WORKSPACE_LOC = "useWorkspaceLoc";
    public static final String PROP_USE_JS_CLIENT = "useJsClient";
    public static final String PROP_SCOUT_VERSION = "scoutVersion";
    public static final String PROP_SHOW_PREVIEW_RELEASES = "showPreviewReleases";
    public static final String SETTINGS_TARGET_DIR = "targetDirSetting";
    protected StyledTextField m_groupIdField;
    protected StyledTextField m_artifactIdField;
    protected StyledTextField m_displayNameField;
    protected Button m_javaScriptButton;
    protected Button m_javaButton;
    protected ProposalTextField m_scoutVersionField;
    protected Button m_showPreviewReleases;
    protected Button m_useWsLoc;
    protected ResourceTextField m_targetDirectoryField;
    protected final List<String> m_scoutVersions = new ArrayList<String>();
    protected volatile boolean m_versionsLoading;

    public ScoutProjectNewWizardPage() {
        super(ScoutProjectNewWizardPage.class.getName());
        this.setTitle("Create a Scout Project");
        this.setDescription("Create a new Scout Project");
        this.initDefaultValues();
    }

    protected void initDefaultValues() {
        this.setGroupIdInternal("org.eclipse.scout.apps");
        this.setArtifactIdInternal("helloscout");
        this.setDisplayNameInternal("My Application");
        this.setUseJsClientInternal(false);
        this.resetVersionsToDefault();
        this.setShowPreviewReleases(false);
        this.setUseWorkspaceLocationInternal(true);
        this.updateTargetDirViewState();
    }

    @Override
    protected void createContent(Composite parent) {
        GridLayoutFactory.swtDefaults().applyTo(parent);
        int labelWidth = 120;
        this.createProjectNameGroup(parent, labelWidth);
        this.createClientLanguageGroup(parent);
        this.createScoutVersionGroup(parent, labelWidth);
        this.createProjectLocationGroup(parent, labelWidth);
        this.updateVersionsAsync();
    }

    protected void createProjectNameGroup(Composite parent, int labelWidth) {
        Group nameGroup = FieldToolkit.createGroupBox(parent, "Project Name");
        this.m_groupIdField = FieldToolkit.createStyledTextField((Composite)nameGroup, "Group Id", 1, labelWidth);
        this.m_groupIdField.setText(this.getGroupId());
        this.m_groupIdField.setSelection(new Point(0, this.m_groupIdField.getText().length()));
        this.m_groupIdField.setFocus();
        this.m_groupIdField.addModifyListener(e -> {
            this.setGroupIdInternal(this.m_groupIdField.getText());
            this.pingStateChanging();
        });
        this.m_artifactIdField = FieldToolkit.createStyledTextField((Composite)nameGroup, "Artifact Id", 1, labelWidth);
        this.m_artifactIdField.setText(this.getArtifactId());
        this.m_artifactIdField.addModifyListener(e -> {
            this.setArtifactIdInternal(this.m_artifactIdField.getText());
            this.pingStateChanging();
        });
        this.m_displayNameField = FieldToolkit.createStyledTextField((Composite)nameGroup, "Display Name", 1, labelWidth);
        this.m_displayNameField.setText(this.getDisplayName());
        this.m_displayNameField.addModifyListener(e -> {
            this.setDisplayNameInternal(this.m_displayNameField.getText());
            this.pingStateChanging();
        });
        GridLayoutFactory.swtDefaults().applyTo((Composite)nameGroup);
        GridDataFactory.defaultsFor((Control)nameGroup).align(4, 0x1000000).grab(true, false).applyTo((Control)nameGroup);
        GridDataFactory.defaultsFor((Control)this.m_groupIdField).align(4, 0x1000000).grab(true, false).applyTo((Control)this.m_groupIdField);
        GridDataFactory.defaultsFor((Control)this.m_artifactIdField).align(4, 0x1000000).grab(true, false).applyTo((Control)this.m_artifactIdField);
        GridDataFactory.defaultsFor((Control)this.m_displayNameField).align(4, 0x1000000).grab(true, false).applyTo((Control)this.m_displayNameField);
    }

    protected void createClientLanguageGroup(Composite parent) {
        Group uiLangBox = FieldToolkit.createGroupBox(parent, "Programming language of the user interface");
        this.m_javaButton = new Button((Composite)uiLangBox, 16);
        this.m_javaButton.setText("Java");
        this.m_javaButton.setSelection(!this.isUseJsClient());
        this.m_javaButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ScoutProjectNewWizardPage.this.setUseJsClientInternal(!ScoutProjectNewWizardPage.this.m_javaButton.getSelection());
                ScoutProjectNewWizardPage.this.updateVersionsAsync();
                ScoutProjectNewWizardPage.this.pingStateChanging();
            }
        });
        this.m_javaScriptButton = new Button((Composite)uiLangBox, 16);
        this.m_javaScriptButton.setText("TypeScript / JavaScript");
        this.m_javaScriptButton.setSelection(this.isUseJsClient());
        this.m_javaScriptButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ScoutProjectNewWizardPage.this.setUseJsClientInternal(ScoutProjectNewWizardPage.this.m_javaScriptButton.getSelection());
                ScoutProjectNewWizardPage.this.updateVersionsAsync();
                ScoutProjectNewWizardPage.this.pingStateChanging();
            }
        });
        GridLayoutFactory.swtDefaults().applyTo((Composite)uiLangBox);
        GridDataFactory.defaultsFor((Control)uiLangBox).align(4, 0x1000000).grab(true, false).indent(0, 10).applyTo((Control)uiLangBox);
        GridDataFactory.defaultsFor((Control)this.m_javaButton).indent(23, 2).applyTo((Control)this.m_javaButton);
        GridDataFactory.defaultsFor((Control)this.m_javaScriptButton).indent(23, 5).applyTo((Control)this.m_javaScriptButton);
    }

    protected void createScoutVersionGroup(Composite parent, int labelWidth) {
        Group scoutVersionBox = FieldToolkit.createGroupBox(parent, "Scout runtime version");
        P_ScoutVersionsContentProvider scoutVersionContentProvider = new P_ScoutVersionsContentProvider();
        this.m_scoutVersionField = FieldToolkit.createProposalField((Composite)scoutVersionBox, "Scout Version", 1, labelWidth);
        this.m_scoutVersionField.setContentProvider(scoutVersionContentProvider);
        this.m_scoutVersionField.setLabelProvider((IBaseLabelProvider)scoutVersionContentProvider);
        this.m_scoutVersionField.addModifyListener(item -> {
            this.setScoutVersionInternal(this.m_scoutVersionField.getText());
            this.pingStateChanging();
        });
        Composite checkboxParent = new Composite((Composite)scoutVersionBox, 0);
        Label checkboxLabel = new Label(checkboxParent, 0);
        this.m_showPreviewReleases = FieldToolkit.createCheckBox(checkboxParent, "Also show preview versions", false);
        this.m_showPreviewReleases.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ScoutProjectNewWizardPage.this.setShowPreviewReleasesInternal(ScoutProjectNewWizardPage.this.m_showPreviewReleases.getSelection());
                ScoutProjectNewWizardPage.this.updateVersionsAsync();
                ScoutProjectNewWizardPage.this.pingStateChanging();
            }
        });
        GridLayoutFactory.swtDefaults().applyTo((Composite)scoutVersionBox);
        GridDataFactory.defaultsFor((Control)scoutVersionBox).align(4, 0x1000000).grab(true, false).indent(0, 10).applyTo((Control)scoutVersionBox);
        GridDataFactory.defaultsFor((Control)this.m_scoutVersionField).align(4, 0x1000000).grab(true, false).applyTo((Control)this.m_scoutVersionField);
        checkboxParent.setLayout((Layout)new FormLayout());
        GridDataFactory.defaultsFor((Control)checkboxParent).align(4, 0x1000000).grab(true, false).applyTo((Control)checkboxParent);
        FormData labelData = new FormData();
        labelData.top = new FormAttachment(0, 4);
        labelData.left = new FormAttachment(0, 0);
        labelData.right = new FormAttachment(0, 100);
        labelData.bottom = new FormAttachment(100, 0);
        checkboxLabel.setLayoutData((Object)labelData);
        FormData textData = new FormData();
        textData.top = new FormAttachment(0, 0);
        textData.left = new FormAttachment((Control)checkboxLabel, 5);
        textData.right = new FormAttachment(100, 0);
        textData.bottom = new FormAttachment(100, 0);
        this.m_showPreviewReleases.setLayoutData((Object)textData);
    }

    protected void createProjectLocationGroup(Composite parent, int labelWidth) {
        Group locationGroup = FieldToolkit.createGroupBox(parent, "Project Location");
        this.createLocationCheckbox((Composite)locationGroup);
        this.m_targetDirectoryField = FieldToolkit.createResourceField((Composite)locationGroup, "Target Directory", 1, labelWidth);
        this.m_targetDirectoryField.setFile(this.getTargetDirectory());
        this.m_targetDirectoryField.setFolderMode(true);
        this.m_targetDirectoryField.setEnabled(!this.m_useWsLoc.getSelection());
        this.m_targetDirectoryField.addResourceChangedListener((newUrl, newFile) -> {
            this.setTargetDirectoryInternal(newFile);
            this.pingStateChanging();
        });
        GridLayoutFactory.swtDefaults().applyTo((Composite)locationGroup);
        GridDataFactory.defaultsFor((Control)locationGroup).align(4, 0x1000000).grab(true, false).indent(0, 10).applyTo((Control)locationGroup);
        GridDataFactory.defaultsFor((Control)this.m_targetDirectoryField).align(4, 0x1000000).grab(true, false).applyTo((Control)this.m_targetDirectoryField);
    }

    protected Composite createLocationCheckbox(Composite p) {
        Composite parent = new Composite(p, 0);
        Label lbl = new Label(parent, 0);
        this.m_useWsLoc = FieldToolkit.createCheckBox(parent, "Use default Workspace location", this.isUseWorkspaceLocation());
        this.m_useWsLoc.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ScoutProjectNewWizardPage.this.setUseWorkspaceLocationInternal(ScoutProjectNewWizardPage.this.m_useWsLoc.getSelection());
                ScoutProjectNewWizardPage.this.updateTargetDirViewState();
                ScoutProjectNewWizardPage.this.pingStateChanging();
            }
        });
        parent.setLayout((Layout)new FormLayout());
        GridDataFactory.defaultsFor((Control)parent).align(4, 0x1000000).grab(true, false).applyTo((Control)parent);
        FormData labelData = new FormData();
        labelData.top = new FormAttachment(0, 4);
        labelData.left = new FormAttachment(0, 0);
        labelData.right = new FormAttachment(0, 10);
        labelData.bottom = new FormAttachment(100, 0);
        lbl.setLayoutData((Object)labelData);
        FormData textData = new FormData();
        textData.top = new FormAttachment(0, 0);
        textData.left = new FormAttachment((Control)lbl, 5);
        textData.right = new FormAttachment(100, 0);
        textData.bottom = new FormAttachment(100, 0);
        this.m_useWsLoc.setLayoutData((Object)textData);
        return parent;
    }

    protected void updateVersionsAsync() {
        this.setVersionLoading(true);
        new AbstractJob("Load available Scout versions."){

            protected void execute(IProgressMonitor monitor) {
                try {
                    List availableVersions = ScoutProjectNewHelper.getSupportedArchetypeVersions((!ScoutProjectNewWizardPage.this.isUseJsClient() ? 1 : 0) != 0, (boolean)ScoutProjectNewWizardPage.this.isShowPreviewReleases());
                    if (availableVersions.isEmpty()) {
                        ScoutProjectNewWizardPage.this.resetVersionsToDefault();
                    } else {
                        ScoutProjectNewWizardPage.this.setAvailableVersions(availableVersions);
                    }
                }
                catch (Exception e) {
                    SdkLog.warning((CharSequence)"Error fetching available Scout versions from Maven central.", (Object[])new Object[]{e});
                    ScoutProjectNewWizardPage.this.resetVersionsToDefault();
                }
                finally {
                    PlatformUI.getWorkbench().getDisplay().asyncExec(() -> ScoutProjectNewWizardPage.this.setVersionLoading(false));
                }
            }
        }.schedule();
    }

    private void resetVersionsToDefault() {
        this.setAvailableVersions(Collections.singletonList("LATEST"));
    }

    private void setAvailableVersions(SequencedCollection<String> versions) {
        this.m_scoutVersions.clear();
        this.m_scoutVersions.addAll(versions);
        PlatformUI.getWorkbench().getDisplay().asyncExec(() -> this.updateVersionsFieldContent(versions));
    }

    protected void updateVersionsFieldContent(SequencedCollection<String> versions) {
        ProposalTextField versionsField = this.m_scoutVersionField;
        if (versionsField == null || versionsField.isDisposed()) {
            return;
        }
        String selected = versionsField.getText();
        P_ScoutVersionsContentProvider contentProvider = (P_ScoutVersionsContentProvider)versionsField.getContentProvider();
        contentProvider.clearCache();
        if (!versions.contains(selected)) {
            versionsField.acceptProposal(versions.getFirst());
        }
        versionsField.setSelection(0);
    }

    protected void setVersionLoading(boolean loading) {
        this.m_versionsLoading = loading;
        if (this.m_javaButton != null && !this.m_javaButton.isDisposed()) {
            this.m_javaButton.setEnabled(!loading);
            this.m_javaScriptButton.setEnabled(!loading);
            this.m_scoutVersionField.setEnabled(!loading);
            this.m_showPreviewReleases.setEnabled(!loading);
        }
        this.pingStateChanging();
    }

    protected void updateTargetDirViewState() {
        if (this.isControlCreated()) {
            this.m_targetDirectoryField.setEnabled(!this.isUseWorkspaceLocation());
        }
        Path file = null;
        if (this.isUseWorkspaceLocation()) {
            file = ScoutProjectNewWizardPage.getWorkspaceLocation();
        } else {
            Path wsLoc = ScoutProjectNewWizardPage.getWorkspaceLocation();
            if (this.getTargetDirectory() == null || wsLoc.equals(this.getTargetDirectory())) {
                String recentTargetDir = this.getDialogSettings().get(SETTINGS_TARGET_DIR);
                file = recentTargetDir != null ? Paths.get(recentTargetDir, new String[0]) : wsLoc;
            }
        }
        if (file != null) {
            this.setTargetDirectory(file);
        }
    }

    public static Path getWorkspaceLocation() {
        return ResourcesPlugin.getWorkspace().getRoot().getLocation().toFile().getAbsoluteFile().toPath();
    }

    @Override
    protected void validatePage(MultiStatus multiStatus) {
        multiStatus.add(this.getStatusGroupId());
        multiStatus.add(this.getStatusArtifactId());
        multiStatus.add(this.getStatusDisplayName());
        multiStatus.add(this.getStatusTargetDirectory());
        multiStatus.add(this.getStatusScoutVersion());
    }

    @Override
    protected void setStatus(IStatus status) {
        super.setStatus(status);
        boolean complete = status == null || !status.matches(4);
        this.setPageComplete(complete && !this.m_versionsLoading);
    }

    protected IStatus getStatusScoutVersion() {
        if (this.m_versionsLoading) {
            return new Status(1, "org.eclipse.scout.sdk.s2e.ui", "Loading available Scout versions...");
        }
        if ("LATEST".equals(this.getScoutVersion())) {
            return Status.OK_STATUS;
        }
        if (ApiVersion.parse((CharSequence)this.getScoutVersion()).isEmpty()) {
            return new Status(4, "org.eclipse.scout.sdk.s2e.ui", "Invalid Scout version.");
        }
        return Status.OK_STATUS;
    }

    protected IStatus getStatusGroupId() {
        String msg = ScoutProjectNewHelper.getMavenGroupIdErrorMessage((String)this.getGroupId());
        if (msg != null) {
            return new Status(4, "org.eclipse.scout.sdk.s2e.ui", msg);
        }
        return Status.OK_STATUS;
    }

    protected IStatus getStatusArtifactId() {
        String artifactId = this.getArtifactId();
        String msg = ScoutProjectNewHelper.getMavenArtifactIdErrorMessage((String)artifactId);
        if (msg != null) {
            return new Status(4, "org.eclipse.scout.sdk.s2e.ui", msg);
        }
        Path folder = this.isUseWorkspaceLocation() ? ScoutProjectNewWizardPage.getWorkspaceLocation() : this.getTargetDirectory();
        if (folder != null && Files.exists(folder.resolve(this.getArtifactId()), new LinkOption[0])) {
            return new Status(4, "org.eclipse.scout.sdk.s2e.ui", "A project with this Artifact Id already exists in this target directory.");
        }
        for (IProject p : ResourcesPlugin.getWorkspace().getRoot().getProjects()) {
            if (!p.getName().startsWith(artifactId + ".")) continue;
            return new Status(4, "org.eclipse.scout.sdk.s2e.ui", "A project with this Artifact Id already exists in the workspace.");
        }
        return Status.OK_STATUS;
    }

    protected IStatus getStatusDisplayName() {
        String msg = ScoutProjectNewHelper.getDisplayNameErrorMessage((CharSequence)this.getDisplayName());
        if (msg != null) {
            return new Status(4, "org.eclipse.scout.sdk.s2e.ui", msg);
        }
        return Status.OK_STATUS;
    }

    protected IStatus getStatusTargetDirectory() {
        if (this.isUseWorkspaceLocation()) {
            return Status.OK_STATUS;
        }
        if (this.getTargetDirectory() == null) {
            return new Status(4, "org.eclipse.scout.sdk.s2e.ui", "Please choose a target directory.");
        }
        return Status.OK_STATUS;
    }

    public String getDisplayName() {
        return this.getPropertyString(PROP_DISPLAY_NAME);
    }

    public void setDisplayName(String s) {
        this.setPropertyWithChangingControl(this.m_displayNameField, () -> this.setDisplayNameInternal(s), field -> field.setText(s));
    }

    protected boolean setDisplayNameInternal(String s) {
        return this.setPropertyString(PROP_DISPLAY_NAME, s);
    }

    public String getGroupId() {
        return this.getPropertyString(PROP_GROUP_ID);
    }

    public void setGroupId(String s) {
        this.setPropertyWithChangingControl(this.m_groupIdField, () -> this.setGroupIdInternal(s), field -> field.setText(s));
    }

    protected boolean setGroupIdInternal(String s) {
        return this.setPropertyString(PROP_GROUP_ID, s);
    }

    public String getArtifactId() {
        return this.getPropertyString(PROP_ARTIFACT_ID);
    }

    public void setArtifactId(String s) {
        this.setPropertyWithChangingControl(this.m_artifactIdField, () -> this.setArtifactIdInternal(s), field -> field.setText(s));
    }

    protected boolean setArtifactIdInternal(String s) {
        return this.setPropertyString(PROP_ARTIFACT_ID, s);
    }

    public String getScoutVersion() {
        return this.getPropertyString(PROP_SCOUT_VERSION);
    }

    public void setScoutVersion(String s) {
        this.setPropertyWithChangingControl(this.m_scoutVersionField, () -> this.setScoutVersionInternal(s), field -> field.setText(s));
    }

    protected boolean setScoutVersionInternal(String s) {
        return this.setPropertyString(PROP_SCOUT_VERSION, s);
    }

    public boolean isShowPreviewReleases() {
        return this.getPropertyBool(PROP_SHOW_PREVIEW_RELEASES);
    }

    public void setShowPreviewReleases(boolean f) {
        this.setPropertyWithChangingControl(this.m_showPreviewReleases, () -> this.setShowPreviewReleasesInternal(f), field -> field.setSelection(f));
    }

    protected boolean setShowPreviewReleasesInternal(boolean f) {
        return this.setPropertyBool(PROP_SHOW_PREVIEW_RELEASES, f);
    }

    public boolean isUseWorkspaceLocation() {
        return this.getPropertyBool(PROP_USE_WORKSPACE_LOC);
    }

    public void setUseWorkspaceLocation(boolean f) {
        this.setPropertyWithChangingControl(this.m_useWsLoc, () -> this.setUseWorkspaceLocationInternal(f), field -> field.setSelection(f));
    }

    protected boolean setUseWorkspaceLocationInternal(boolean f) {
        return this.setPropertyBool(PROP_USE_WORKSPACE_LOC, f);
    }

    public Path getTargetDirectory() {
        return this.getProperty(PROP_DIR, Path.class);
    }

    public void setTargetDirectory(Path f) {
        this.setPropertyWithChangingControl(this.m_targetDirectoryField, () -> this.setTargetDirectoryInternal(f), field -> field.setFile(f));
    }

    protected boolean setTargetDirectoryInternal(Path f) {
        return this.setProperty(PROP_DIR, f);
    }

    public boolean isUseJsClient() {
        return this.getPropertyBool(PROP_USE_JS_CLIENT);
    }

    public void setUseJsClient(boolean isUseJsClient) {
        try {
            this.setStateChanging(true);
            this.setUseJsClientInternal(isUseJsClient);
            if (this.isControlCreated()) {
                this.m_javaButton.setSelection(!isUseJsClient);
                this.m_javaScriptButton.setSelection(isUseJsClient);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    protected void setUseJsClientInternal(boolean isUseJsClient) {
        this.setPropertyBool(PROP_USE_JS_CLIENT, isUseJsClient);
    }

    private final class P_ScoutVersionsContentProvider
    extends AbstractContentProviderAdapter {
        private P_ScoutVersionsContentProvider() {
        }

        @Override
        public void clearCache() {
            super.clearCache();
        }

        public String getText(Object element) {
            return (String)element;
        }

        @Override
        protected Collection<?> loadProposals(IProgressMonitor monitor) {
            return new ArrayList<String>(ScoutProjectNewWizardPage.this.m_scoutVersions);
        }
    }
}

