/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.environment;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.text.Document;
import org.eclipse.scout.sdk.core.log.SdkLog;
import org.eclipse.scout.sdk.core.util.Ensure;
import org.eclipse.scout.sdk.core.util.SdkException;
import org.eclipse.scout.sdk.core.util.Strings;
import org.eclipse.scout.sdk.s2e.environment.EclipseProgress;
import org.eclipse.scout.sdk.s2e.environment.IResourceWriteOperation;
import org.eclipse.scout.sdk.s2e.environment.ResourceWriteOperation;
import org.eclipse.scout.sdk.s2e.environment.WorkingCopyManager;
import org.eclipse.scout.sdk.s2e.operation.OrganizeImportOperation;
import org.eclipse.scout.sdk.s2e.operation.SourceFormatOperation;
import org.eclipse.scout.sdk.s2e.util.JdtUtils;

public class CompilationUnitWriteOperation
implements IResourceWriteOperation {
    private final IJavaProject m_project;
    private final IPackageFragmentRoot m_root;
    private final String m_packageName;
    private final String m_fileName;
    private final CharSequence m_content;
    private ICompilationUnit m_createdCompilationUnit;

    public CompilationUnitWriteOperation(ICompilationUnit existingUnit, CharSequence content) {
        this(JdtUtils.getSourceFolder((IJavaElement)existingUnit), JdtUtils.getPackage(existingUnit), existingUnit.getElementName(), content);
    }

    public CompilationUnitWriteOperation(IPackageFragmentRoot srcFolder, String packageName, String fileName, CharSequence content) {
        this.m_root = (IPackageFragmentRoot)Ensure.notNull((Object)srcFolder);
        this.m_project = srcFolder.getJavaProject();
        this.m_packageName = Strings.isBlank((CharSequence)packageName) ? "" : packageName;
        this.m_fileName = (String)Ensure.notNull((Object)fileName);
        this.m_content = (CharSequence)Ensure.notNull((Object)content);
    }

    public ICompilationUnit getCreatedCompilationUnit() {
        return this.m_createdCompilationUnit;
    }

    public String getFormattedSource() {
        try {
            return this.getCreatedCompilationUnit().getSource();
        }
        catch (JavaModelException e) {
            throw new SdkException((CharSequence)"Source of created compilation unit '{}' cannot be computed.", new Object[]{this.getFileName(), e});
        }
    }

    @Override
    public IResource getAffectedResource() {
        IResource result = this.getSourceFolder().getResource();
        IPackageFragment packageFragment = this.getSourceFolder().getPackageFragment(this.getPackageName());
        if (JdtUtils.exists((IJavaElement)packageFragment)) {
            result = packageFragment.getResource();
            ICompilationUnit compilationUnit = packageFragment.getCompilationUnit(this.getFileName());
            if (compilationUnit.exists()) {
                result = compilationUnit.getResource();
            }
        }
        return result;
    }

    @Override
    public void accept(EclipseProgress progress) {
        progress.init(5, this.toString(), new Object[0]);
        try {
            String newSource = this.getSourceFormatted(this.getContent().toString(), this.m_project, progress.newChild(1));
            IPackageFragment pck = this.getSourceFolder().getPackageFragment(this.getPackageName());
            if (!JdtUtils.exists((IJavaElement)pck)) {
                pck = this.getSourceFolder().createPackageFragment(this.getPackageName(), true, (IProgressMonitor)progress.newChild(1).monitor());
            }
            this.m_createdCompilationUnit = pck.getCompilationUnit(this.getFileName());
            progress.setWorkRemaining(2);
            if (!this.m_createdCompilationUnit.exists()) {
                this.m_createdCompilationUnit = pck.createCompilationUnit(this.getFileName(), newSource, true, (IProgressMonitor)progress.newChild(1).monitor());
                WorkingCopyManager.currentWorkingCopyManager().register(this.m_createdCompilationUnit, (IProgressMonitor)progress.newChild(1).monitor());
                this.organizeImports(this.m_createdCompilationUnit, progress.newChild(1));
            } else {
                if (!ResourceWriteOperation.areContentsEqual((IFile)this.m_createdCompilationUnit.getResource(), newSource)) {
                    WorkingCopyManager.currentWorkingCopyManager().register(this.m_createdCompilationUnit, (IProgressMonitor)progress.newChild(1).monitor());
                    this.m_createdCompilationUnit.getBuffer().setContents(newSource);
                    this.organizeImports(this.m_createdCompilationUnit, progress.newChild(1));
                }
                progress.setWorkRemaining(0);
            }
        }
        catch (JavaModelException e) {
            SdkLog.error((CharSequence)"Could not {}", (Object[])new Object[]{this, e});
        }
    }

    protected String getSourceFormatted(String rawJavaSource, IJavaProject settings, EclipseProgress progress) {
        try {
            SourceFormatOperation op = new SourceFormatOperation(settings, new Document(rawJavaSource));
            op.accept(progress.newChild(10));
            return op.getDocument().get();
        }
        catch (RuntimeException e) {
            SdkLog.warning((CharSequence)"Unable to format source of compilation unit '{}'.", (Object[])new Object[]{this.getFileName(), e});
            return rawJavaSource;
        }
    }

    protected void organizeImports(ICompilationUnit icu, EclipseProgress progress) {
        try {
            new OrganizeImportOperation(icu).accept(progress.newChild(10));
        }
        catch (RuntimeException e) {
            SdkLog.warning((CharSequence)"Unable to organize imports of compilation unit '{}'.", (Object[])new Object[]{this.getFileName(), e});
        }
    }

    public IPackageFragmentRoot getSourceFolder() {
        return this.m_root;
    }

    public String getPackageName() {
        return this.m_packageName;
    }

    public String getFileName() {
        return this.m_fileName;
    }

    public CharSequence getContent() {
        return this.m_content;
    }

    @Override
    public IFile getFile() {
        if (!JdtUtils.exists((IJavaElement)this.m_createdCompilationUnit)) {
            return null;
        }
        IResource resource = this.m_createdCompilationUnit.getResource();
        if (resource == null || !resource.exists() || resource.getType() != 1) {
            return null;
        }
        return (IFile)resource;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Write ");
        sb.append(this.getSourceFolder().getPath()).append('/');
        if (!this.getPackageName().isEmpty()) {
            sb.append(this.getPackageName().replace('.', '/')).append('/');
        }
        sb.append(this.getFileName());
        return sb.toString();
    }
}

