/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.xml;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Queue;
import java.util.ServiceLoader;
import java.util.Set;
import org.eclipse.jetty.util.LazyList;
import org.eclipse.jetty.util.Loader;
import org.eclipse.jetty.util.MultiException;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.TypeUtil;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.xml.ConfigurationProcessor;
import org.eclipse.jetty.xml.ConfigurationProcessorFactory;
import org.eclipse.jetty.xml.XmlParser;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XmlConfiguration {
    private static final Logger LOG = Log.getLogger(XmlConfiguration.class);
    private static final Class<?>[] __primitives = new Class[]{Boolean.TYPE, Character.TYPE, Byte.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE, Void.TYPE};
    private static final Class<?>[] __boxedPrimitives = new Class[]{Boolean.class, Character.class, Byte.class, Short.class, Integer.class, Long.class, Float.class, Double.class, Void.class};
    private static final Class<?>[] __supportedCollections = new Class[]{ArrayList.class, HashSet.class, Queue.class, List.class, Set.class, Collection.class};
    private static final Iterable<ConfigurationProcessorFactory> __factoryLoader = ServiceLoader.load(ConfigurationProcessorFactory.class);
    private static final XmlParser __parser = XmlConfiguration.initParser();
    private final Map<String, Object> _idMap = new HashMap<String, Object>();
    private final Map<String, String> _propertyMap = new HashMap<String, String>();
    private final URL _url;
    private final String _dtd;
    private ConfigurationProcessor _processor;

    private static XmlParser initParser() {
        ClassLoader loader = XmlConfiguration.class.getClassLoader();
        XmlParser parser = new XmlParser();
        URL config60 = loader.getResource("org/eclipse/jetty/xml/configure_6_0.dtd");
        URL config76 = loader.getResource("org/eclipse/jetty/xml/configure_7_6.dtd");
        URL config90 = loader.getResource("org/eclipse/jetty/xml/configure_9_0.dtd");
        URL config93 = loader.getResource("org/eclipse/jetty/xml/configure_9_3.dtd");
        parser.redirectEntity("configure.dtd", config90);
        parser.redirectEntity("configure_1_0.dtd", config60);
        parser.redirectEntity("configure_1_1.dtd", config60);
        parser.redirectEntity("configure_1_2.dtd", config60);
        parser.redirectEntity("configure_1_3.dtd", config60);
        parser.redirectEntity("configure_6_0.dtd", config60);
        parser.redirectEntity("configure_7_6.dtd", config76);
        parser.redirectEntity("configure_9_0.dtd", config90);
        parser.redirectEntity("configure_9_3.dtd", config93);
        parser.redirectEntity("http://jetty.mortbay.org/configure.dtd", config93);
        parser.redirectEntity("http://jetty.eclipse.org/configure.dtd", config93);
        parser.redirectEntity("http://www.eclipse.org/jetty/configure.dtd", config93);
        parser.redirectEntity("-//Mort Bay Consulting//DTD Configure//EN", config93);
        parser.redirectEntity("-//Jetty//Configure//EN", config93);
        return parser;
    }

    public void setJettyStandardIdsAndProperties(Object server, Resource webapp) {
        try {
            if (server != null) {
                this.getIdMap().put("Server", server);
            }
            Path home = Paths.get(System.getProperty("jetty.home", "."), new String[0]);
            this.getProperties().put("jetty.home", home.toString());
            this.getProperties().put("jetty.home.uri", XmlConfiguration.normalizeURI(home.toUri().toASCIIString()));
            Path base = Paths.get(System.getProperty("jetty.base", home.toString()), new String[0]);
            this.getProperties().put("jetty.base", base.toString());
            this.getProperties().put("jetty.base.uri", XmlConfiguration.normalizeURI(base.toUri().toASCIIString()));
            if (webapp != null) {
                Path webappPath = webapp.getFile().toPath().toAbsolutePath();
                this.getProperties().put("jetty.webapp", webappPath.toString());
                this.getProperties().put("jetty.webapps", webappPath.getParent().toString());
                this.getProperties().put("jetty.webapps.uri", XmlConfiguration.normalizeURI(webapp.getURI().toString()));
            }
        }
        catch (Exception e) {
            LOG.warn((Throwable)e);
        }
    }

    public static String normalizeURI(String uri) {
        if (uri.endsWith("/")) {
            return uri.substring(0, uri.length() - 1);
        }
        return uri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XmlConfiguration(URL configuration) throws SAXException, IOException {
        XmlParser xmlParser = __parser;
        synchronized (xmlParser) {
            this._url = configuration;
            this.setConfig(__parser.parse(configuration.toString()));
            this._dtd = __parser.getDTD();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XmlConfiguration(String configuration) throws SAXException, IOException {
        configuration = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<!DOCTYPE Configure PUBLIC \"-//Jetty//Configure//EN\" \"http://eclipse.org/jetty/configure.dtd\">" + configuration;
        InputSource source = new InputSource(new StringReader(configuration));
        XmlParser xmlParser = __parser;
        synchronized (xmlParser) {
            this._url = null;
            this.setConfig(__parser.parse(source));
            this._dtd = __parser.getDTD();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XmlConfiguration(InputStream configuration) throws SAXException, IOException {
        InputSource source = new InputSource(configuration);
        XmlParser xmlParser = __parser;
        synchronized (xmlParser) {
            this._url = null;
            this.setConfig(__parser.parse(source));
            this._dtd = __parser.getDTD();
        }
    }

    private void setConfig(XmlParser.Node config) {
        if ("Configure".equals(config.getTag())) {
            this._processor = new JettyXmlConfiguration();
        } else if (__factoryLoader != null) {
            for (ConfigurationProcessorFactory factory : __factoryLoader) {
                this._processor = factory.getConfigurationProcessor(this._dtd, config.getTag());
                if (this._processor == null) continue;
                break;
            }
            if (this._processor == null) {
                throw new IllegalStateException("Unknown configuration type: " + config.getTag() + " in " + this);
            }
        } else {
            throw new IllegalArgumentException("Unknown XML tag:" + config.getTag());
        }
        this._processor.init(this._url, config, this);
    }

    public Map<String, Object> getIdMap() {
        return this._idMap;
    }

    public Map<String, String> getProperties() {
        return this._propertyMap;
    }

    public Object configure(Object obj) throws Exception {
        return this._processor.configure(obj);
    }

    public Object configure() throws Exception {
        return this._processor.configure();
    }

    public void initializeDefaults(Object object) {
    }

    public static void main(final String ... args) throws Exception {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    Properties properties = null;
                    if (properties == null) {
                        properties = new Properties();
                        properties.putAll((Map<?, ?>)System.getProperties());
                    }
                    for (String string : args) {
                        if (string.indexOf(61) >= 0) {
                            int i = string.indexOf(61);
                            properties.put(string.substring(0, i), string.substring(i + 1));
                            continue;
                        }
                        if (!string.toLowerCase(Locale.ENGLISH).endsWith(".properties")) continue;
                        properties.load(Resource.newResource((String)string).getInputStream());
                    }
                    XmlConfiguration last = null;
                    ArrayList<Object> objects = new ArrayList<Object>(args.length);
                    for (int i = 0; i < args.length; ++i) {
                        Object obj;
                        if (args[i].toLowerCase(Locale.ENGLISH).endsWith(".properties") || args[i].indexOf(61) >= 0) continue;
                        XmlConfiguration xmlConfiguration = new XmlConfiguration(Resource.newResource((String)args[i]).getURI().toURL());
                        if (last != null) {
                            xmlConfiguration.getIdMap().putAll(last.getIdMap());
                        }
                        if (properties.size() > 0) {
                            HashMap<String, String> props = new HashMap<String, String>();
                            for (Object key : properties.keySet()) {
                                props.put(key.toString(), String.valueOf(properties.get(key)));
                            }
                            xmlConfiguration.getProperties().putAll(props);
                        }
                        if ((obj = xmlConfiguration.configure()) != null && !objects.contains(obj)) {
                            objects.add(obj);
                        }
                        last = xmlConfiguration;
                    }
                    for (Object e : objects) {
                        LifeCycle lc;
                        if (!(e instanceof LifeCycle) || (lc = (LifeCycle)e).isRunning()) continue;
                        lc.start();
                    }
                    return null;
                }
            });
        }
        catch (Error | Exception e) {
            LOG.warn(e);
            throw e;
        }
    }

    private static class JettyXmlConfiguration
    implements ConfigurationProcessor {
        private String _url;
        XmlParser.Node _root;
        XmlConfiguration _configuration;

        private JettyXmlConfiguration() {
        }

        @Override
        public void init(URL url, XmlParser.Node root, XmlConfiguration configuration) {
            this._url = url == null ? null : url.toString();
            this._root = root;
            this._configuration = configuration;
        }

        @Override
        public Object configure(Object obj) throws Exception {
            Class<?> oClass = JettyXmlConfiguration.nodeClass(this._root);
            if (oClass != null && !oClass.isInstance(obj)) {
                String loaders = oClass.getClassLoader() == obj.getClass().getClassLoader() ? "" : "Object Class and type Class are from different loaders.";
                throw new IllegalArgumentException("Object of class '" + obj.getClass().getCanonicalName() + "' is not of type '" + oClass.getCanonicalName() + "'. " + loaders + " in " + this._url);
            }
            String id = this._root.getAttribute("id");
            if (id != null) {
                this._configuration.getIdMap().put(id, obj);
            }
            this.configure(obj, this._root, 0);
            return obj;
        }

        @Override
        public Object configure() throws Exception {
            Class<?> oClass = JettyXmlConfiguration.nodeClass(this._root);
            String id = this._root.getAttribute("id");
            Object obj = id == null ? null : this._configuration.getIdMap().get(id);
            int index = 0;
            if (obj == null && oClass != null) {
                index = this._root.size();
                HashMap<String, Object> namedArgMap = new HashMap<String, Object>();
                LinkedList<Object> arguments = new LinkedList<Object>();
                for (int i = 0; i < this._root.size(); ++i) {
                    Object o = this._root.get(i);
                    if (o instanceof String) continue;
                    XmlParser.Node node = (XmlParser.Node)o;
                    if (!node.getTag().equals("Arg")) {
                        index = i;
                        break;
                    }
                    String namedAttribute = node.getAttribute("name");
                    Object value = this.value(obj, (XmlParser.Node)o);
                    if (namedAttribute != null) {
                        namedArgMap.put(namedAttribute, value);
                    }
                    arguments.add(value);
                }
                try {
                    obj = namedArgMap.size() > 0 ? TypeUtil.construct(oClass, (Object[])arguments.toArray(), namedArgMap) : TypeUtil.construct(oClass, (Object[])arguments.toArray());
                }
                catch (NoSuchMethodException x) {
                    throw new IllegalStateException(String.format("No constructor %s(%s,%s) in %s", oClass, arguments, namedArgMap, this._url));
                }
            }
            if (id != null) {
                this._configuration.getIdMap().put(id, obj);
            }
            this._configuration.initializeDefaults(obj);
            this.configure(obj, this._root, index);
            return obj;
        }

        private static Class<?> nodeClass(XmlParser.Node node) throws ClassNotFoundException {
            String className = node.getAttribute("class");
            if (className == null) {
                return null;
            }
            return Loader.loadClass((String)className);
        }

        public void configure(Object obj, XmlParser.Node cfg, int i) throws Exception {
            XmlParser.Node node;
            Object o;
            while (i < cfg.size()) {
                o = cfg.get(i);
                if (!(o instanceof String)) {
                    node = (XmlParser.Node)o;
                    if (!"Arg".equals(node.getTag())) break;
                    LOG.warn("Ignored arg: " + node, new Object[0]);
                }
                ++i;
            }
            while (i < cfg.size()) {
                o = cfg.get(i);
                if (!(o instanceof String)) {
                    node = (XmlParser.Node)o;
                    try {
                        String tag;
                        switch (tag = node.getTag()) {
                            case "Set": {
                                this.set(obj, node);
                                break;
                            }
                            case "Put": {
                                this.put(obj, node);
                                break;
                            }
                            case "Call": {
                                this.call(obj, node);
                                break;
                            }
                            case "Get": {
                                this.get(obj, node);
                                break;
                            }
                            case "New": {
                                this.newObj(obj, node);
                                break;
                            }
                            case "Array": {
                                this.newArray(obj, node);
                                break;
                            }
                            case "Map": {
                                this.newMap(obj, node);
                                break;
                            }
                            case "Ref": {
                                this.refObj(obj, node);
                                break;
                            }
                            case "Property": {
                                this.propertyObj(node);
                                break;
                            }
                            case "SystemProperty": {
                                this.systemPropertyObj(node);
                                break;
                            }
                            case "Env": {
                                this.envObj(node);
                                break;
                            }
                            default: {
                                throw new IllegalStateException("Unknown tag: " + tag + " in " + this._url);
                            }
                        }
                    }
                    catch (Exception e) {
                        LOG.warn("Config error at " + node, new Object[]{e.toString() + " in " + this._url});
                        throw e;
                    }
                }
                ++i;
            }
        }

        private void set(Object obj, XmlParser.Node node) throws Exception {
            String attr = node.getAttribute("name");
            String name = "set" + attr.substring(0, 1).toUpperCase(Locale.ENGLISH) + attr.substring(1);
            Object value = this.value(obj, node);
            Object[] arg = new Object[]{value};
            Class<?> oClass = JettyXmlConfiguration.nodeClass(node);
            if (oClass != null) {
                obj = null;
            } else {
                oClass = obj.getClass();
            }
            Class[] vClass = new Class[]{Object.class};
            if (value != null) {
                vClass[0] = value.getClass();
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("XML " + (obj != null ? obj.toString() : oClass.getName()) + "." + name + "(" + value + ")", new Object[0]);
            }
            final MultiException me = new MultiException();
            try {
                Method set = oClass.getMethod(name, vClass);
                set.invoke(obj, arg);
                return;
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException e) {
                LOG.ignore((Throwable)e);
                me.add((Throwable)e);
                try {
                    Field type = vClass[0].getField("TYPE");
                    vClass[0] = (Class)type.get(null);
                    Method set = oClass.getMethod(name, vClass);
                    set.invoke(obj, arg);
                    return;
                }
                catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | NoSuchMethodException e2) {
                    LOG.ignore((Throwable)e2);
                    me.add((Throwable)e2);
                    try {
                        Field field = oClass.getField(attr);
                        if (Modifier.isPublic(field.getModifiers())) {
                            field.set(obj, value);
                            return;
                        }
                    }
                    catch (NoSuchFieldException e3) {
                        LOG.ignore((Throwable)e3);
                        me.add((Throwable)e3);
                    }
                    Method[] sets = oClass.getMethods();
                    Method set = null;
                    String types = null;
                    for (int s = 0; sets != null && s < sets.length; ++s) {
                        if (sets[s].getParameterCount() != 1) continue;
                        Class<?>[] paramTypes = sets[s].getParameterTypes();
                        if (!name.equals(sets[s].getName())) continue;
                        types = types == null ? paramTypes[0].getName() : types + "," + paramTypes[0].getName();
                        try {
                            set = sets[s];
                            sets[s].invoke(obj, arg);
                            return;
                        }
                        catch (IllegalAccessException | IllegalArgumentException e4) {
                            LOG.ignore((Throwable)e4);
                            me.add((Throwable)e4);
                            try {
                                for (Class c : __supportedCollections) {
                                    if (!paramTypes[0].isAssignableFrom(c)) continue;
                                    sets[s].invoke(obj, JettyXmlConfiguration.convertArrayToCollection(value, c));
                                    return;
                                }
                                continue;
                            }
                            catch (IllegalAccessException e5) {
                                LOG.ignore((Throwable)e5);
                                me.add((Throwable)e5);
                            }
                        }
                    }
                    if (set != null) {
                        try {
                            Class sClass = set.getParameterTypes()[0];
                            if (sClass.isPrimitive()) {
                                for (int t = 0; t < __primitives.length; ++t) {
                                    if (!sClass.equals(__primitives[t])) continue;
                                    sClass = __boxedPrimitives[t];
                                    break;
                                }
                            }
                            Constructor<?> cons = sClass.getConstructor(vClass);
                            arg[0] = cons.newInstance(arg);
                            this._configuration.initializeDefaults(arg[0]);
                            set.invoke(obj, arg);
                            return;
                        }
                        catch (IllegalAccessException | InstantiationException | NoSuchMethodException e6) {
                            LOG.ignore((Throwable)e6);
                            me.add((Throwable)e6);
                        }
                    }
                    String message = oClass + "." + name + "(" + vClass[0] + ")";
                    if (types != null) {
                        message = message + ". Found setters for " + types;
                    }
                    throw new NoSuchMethodException(message){
                        {
                            super(x0);
                            for (int i = 0; i < me.size(); ++i) {
                                this.addSuppressed(me.getThrowable(i));
                            }
                        }
                    };
                }
            }
        }

        private static Collection<?> convertArrayToCollection(Object array, Class<?> collectionType) {
            AbstractCollection collection = null;
            if (array.getClass().isArray()) {
                if (collectionType.isAssignableFrom(ArrayList.class)) {
                    collection = JettyXmlConfiguration.convertArrayToArrayList(array);
                } else if (collectionType.isAssignableFrom(HashSet.class)) {
                    collection = new HashSet<Object>(JettyXmlConfiguration.convertArrayToArrayList(array));
                }
            }
            if (collection == null) {
                throw new IllegalArgumentException("Can't convert \"" + array.getClass() + "\" to " + collectionType);
            }
            return collection;
        }

        private static ArrayList<Object> convertArrayToArrayList(Object array) {
            int length = Array.getLength(array);
            ArrayList<Object> list = new ArrayList<Object>(length);
            for (int i = 0; i < length; ++i) {
                list.add(Array.get(array, i));
            }
            return list;
        }

        private void put(Object obj, XmlParser.Node node) throws Exception {
            if (!(obj instanceof Map)) {
                throw new IllegalArgumentException("Object for put is not a Map: " + obj);
            }
            Map map = (Map)obj;
            String name = node.getAttribute("name");
            Object value = this.value(obj, node);
            map.put(name, value);
            if (LOG.isDebugEnabled()) {
                LOG.debug("XML " + obj + ".put(" + name + "," + value + ")", new Object[0]);
            }
        }

        private Object get(Object obj, XmlParser.Node node) throws Exception {
            Class<?> oClass = JettyXmlConfiguration.nodeClass(node);
            if (oClass != null) {
                obj = null;
            } else {
                oClass = obj.getClass();
            }
            String name = node.getAttribute("name");
            String id = node.getAttribute("id");
            if (LOG.isDebugEnabled()) {
                LOG.debug("XML get " + name, new Object[0]);
            }
            try {
                if ("class".equalsIgnoreCase(name)) {
                    obj = oClass;
                } else {
                    Method method = oClass.getMethod("get" + name.substring(0, 1).toUpperCase(Locale.ENGLISH) + name.substring(1), null);
                    obj = method.invoke(obj, (Object[])null);
                }
                if (id != null) {
                    this._configuration.getIdMap().put(id, obj);
                }
                this.configure(obj, node, 0);
            }
            catch (NoSuchMethodException nsme) {
                try {
                    Field field = oClass.getField(name);
                    obj = field.get(obj);
                    this.configure(obj, node, 0);
                }
                catch (NoSuchFieldException nsfe) {
                    throw nsme;
                }
            }
            return obj;
        }

        private Object call(Object obj, XmlParser.Node node) throws Exception {
            Class<?> oClass;
            AttrOrElementNode aoeNode = new AttrOrElementNode(obj, node, "Id", "Name", "Class", "Arg");
            String id = aoeNode.getString("Id");
            String name = aoeNode.getString("Name");
            String clazz = aoeNode.getString("Class");
            List<Object> args = aoeNode.getList("Arg");
            if (clazz != null) {
                oClass = Loader.loadClass((String)clazz);
                obj = null;
            } else if (obj != null) {
                oClass = obj.getClass();
            } else {
                throw new IllegalArgumentException(node.toString());
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("XML call " + name, new Object[0]);
            }
            try {
                Object nobj = TypeUtil.call(oClass, (String)name, (Object)obj, (Object[])args.toArray(new Object[args.size()]));
                if (id != null) {
                    this._configuration.getIdMap().put(id, nobj);
                }
                this.configure(nobj, node, aoeNode.getNext());
                return nobj;
            }
            catch (NoSuchMethodException e) {
                IllegalStateException ise = new IllegalStateException("No Method: " + node + " on " + oClass);
                ise.initCause(e);
                throw ise;
            }
        }

        private Object newObj(Object obj, XmlParser.Node node) throws Exception {
            Object nobj;
            AttrOrElementNode aoeNode = new AttrOrElementNode(obj, node, "Id", "Class", "Arg");
            String id = aoeNode.getString("Id");
            String clazz = aoeNode.getString("Class");
            List<XmlParser.Node> argNodes = aoeNode.getNodes("Arg");
            if (LOG.isDebugEnabled()) {
                LOG.debug("XML new " + clazz, new Object[0]);
            }
            Class oClass = Loader.loadClass((String)clazz);
            HashMap<String, Object> namedArgMap = new HashMap<String, Object>();
            LinkedList<Object> arguments = new LinkedList<Object>();
            for (XmlParser.Node child : argNodes) {
                String namedAttribute = child.getAttribute("name");
                Object value = this.value(obj, child);
                if (namedAttribute != null) {
                    namedArgMap.put(namedAttribute, value);
                }
                arguments.add(value);
            }
            try {
                if (namedArgMap.size() > 0) {
                    LOG.debug("using named mapping", new Object[0]);
                    nobj = TypeUtil.construct((Class)oClass, (Object[])arguments.toArray(), namedArgMap);
                } else {
                    LOG.debug("using normal mapping", new Object[0]);
                    nobj = TypeUtil.construct((Class)oClass, (Object[])arguments.toArray());
                }
            }
            catch (NoSuchMethodException e) {
                throw new IllegalStateException("No suitable constructor: " + node + " on " + obj);
            }
            if (id != null) {
                this._configuration.getIdMap().put(id, nobj);
            }
            this._configuration.initializeDefaults(nobj);
            this.configure(nobj, node, aoeNode.getNext());
            return nobj;
        }

        private Object refObj(Object obj, XmlParser.Node node) throws Exception {
            String refid = node.getAttribute("refid");
            if (refid == null) {
                refid = node.getAttribute("id");
            }
            if ((obj = this._configuration.getIdMap().get(refid)) == null && node.size() > 0) {
                throw new IllegalStateException("No object for refid=" + refid);
            }
            this.configure(obj, node, 0);
            return obj;
        }

        private Object newArray(Object obj, XmlParser.Node node) throws Exception {
            AttrOrElementNode aoeNode = new AttrOrElementNode(obj, node, "Id", "Type", "Item");
            String id = aoeNode.getString("Id");
            String type = aoeNode.getString("Type");
            List<XmlParser.Node> items = aoeNode.getNodes("Item");
            Class aClass = Object.class;
            if (type != null && (aClass = TypeUtil.fromName((String)type)) == null) {
                switch (type) {
                    case "String": {
                        aClass = String.class;
                        break;
                    }
                    case "URL": {
                        aClass = URL.class;
                        break;
                    }
                    case "InetAddress": {
                        aClass = InetAddress.class;
                        break;
                    }
                    default: {
                        aClass = Loader.loadClass((String)type);
                    }
                }
            }
            Object al = null;
            for (XmlParser.Node item : items) {
                String nid = item.getAttribute("id");
                Object v = this.value(obj, item);
                al = LazyList.add(al, (Object)(v == null && aClass.isPrimitive() ? Integer.valueOf(0) : v));
                if (nid == null) continue;
                this._configuration.getIdMap().put(nid, v);
            }
            Object array = LazyList.toArray(al, (Class)aClass);
            if (id != null) {
                this._configuration.getIdMap().put(id, array);
            }
            return array;
        }

        private Object newMap(Object obj, XmlParser.Node node) throws Exception {
            AttrOrElementNode aoeNode = new AttrOrElementNode(node, "Id", "Entry");
            String id = aoeNode.getString("Id");
            List<XmlParser.Node> entries = aoeNode.getNodes("Entry");
            HashMap<Object, Object> map = new HashMap<Object, Object>();
            if (id != null) {
                this._configuration.getIdMap().put(id, map);
            }
            for (XmlParser.Node entry : entries) {
                if (!entry.getTag().equals("Entry")) {
                    throw new IllegalStateException("Not an Entry");
                }
                XmlParser.Node key = null;
                XmlParser.Node value = null;
                for (Object object : entry) {
                    if (object instanceof String) continue;
                    XmlParser.Node item = (XmlParser.Node)object;
                    if (!item.getTag().equals("Item")) {
                        throw new IllegalStateException("Not an Item");
                    }
                    if (key == null) {
                        key = item;
                        continue;
                    }
                    value = item;
                }
                if (key == null || value == null) {
                    throw new IllegalStateException("Missing Item in Entry");
                }
                String kid = key.getAttribute("id");
                String vid = value.getAttribute("id");
                Object k = this.value(obj, key);
                Object v = this.value(obj, value);
                map.put(k, v);
                if (kid != null) {
                    this._configuration.getIdMap().put(kid, k);
                }
                if (vid == null) continue;
                this._configuration.getIdMap().put(vid, v);
            }
            return map;
        }

        private Object propertyObj(XmlParser.Node node) throws Exception {
            AttrOrElementNode aoeNode = new AttrOrElementNode(node, "Id", "Name", "Deprecated", "Default");
            String id = aoeNode.getString("Id");
            String name = aoeNode.getString("Name", true);
            List<Object> deprecated = aoeNode.getList("Deprecated");
            String dftValue = aoeNode.getString("Default");
            Map<String, String> properties = this._configuration.getProperties();
            String value = properties.get(name);
            String alternate = null;
            if (!deprecated.isEmpty()) {
                for (Object d : deprecated) {
                    String v = properties.get(StringUtil.valueOf((Object)d));
                    if (v != null) {
                        if (value == null) {
                            LOG.warn("Property '{}' is deprecated, use '{}' instead", new Object[]{d, name});
                        } else {
                            LOG.warn("Property '{}' is deprecated, value from '{}' used", new Object[]{d, name});
                        }
                    }
                    if (alternate != null) continue;
                    alternate = v;
                }
            }
            if (value == null) {
                value = alternate;
            }
            if (value == null) {
                value = dftValue;
            }
            if (id != null) {
                this._configuration.getIdMap().put(id, value);
            }
            return value;
        }

        private Object systemPropertyObj(XmlParser.Node node) throws Exception {
            AttrOrElementNode aoeNode = new AttrOrElementNode(node, "Id", "Name", "Deprecated", "Default");
            String id = aoeNode.getString("Id");
            String name = aoeNode.getString("Name", true);
            List<Object> deprecated = aoeNode.getList("Deprecated");
            String dftValue = aoeNode.getString("Default");
            String value = System.getProperty(name);
            String alternate = null;
            if (!deprecated.isEmpty()) {
                for (Object d : deprecated) {
                    String v = System.getProperty(StringUtil.valueOf((Object)d));
                    if (v != null) {
                        if (value == null) {
                            LOG.warn("SystemProperty '{}' is deprecated, use '{}' instead", new Object[]{d, name});
                        } else {
                            LOG.warn("SystemProperty '{}' is deprecated, value from '{}' used", new Object[]{d, name});
                        }
                    }
                    if (alternate != null) continue;
                    alternate = v;
                }
            }
            if (value == null) {
                value = alternate;
            }
            if (value == null) {
                value = dftValue;
            }
            if (id != null) {
                this._configuration.getIdMap().put(id, value);
            }
            return value;
        }

        private Object envObj(XmlParser.Node node) throws Exception {
            AttrOrElementNode aoeNode = new AttrOrElementNode(node, "Id", "Name", "Deprecated", "Default");
            String id = aoeNode.getString("Id");
            String name = aoeNode.getString("Name", true);
            List<Object> deprecated = aoeNode.getList("Deprecated");
            String dftValue = aoeNode.getString("Default");
            String value = System.getenv(name);
            if (value == null && !deprecated.isEmpty()) {
                for (Object d : deprecated) {
                    value = System.getenv(StringUtil.valueOf((Object)d));
                    if (value == null) continue;
                    LOG.warn("Property '{}' is deprecated, use '{}' instead", new Object[]{d, name});
                    break;
                }
            }
            if (value == null) {
                value = dftValue;
            }
            if (id != null) {
                this._configuration.getIdMap().put(id, value);
            }
            return value;
        }

        private Object value(Object obj, XmlParser.Node node) throws Exception {
            Object value;
            String type = node.getAttribute("type");
            String ref = node.getAttribute("ref");
            if (ref != null) {
                value = this._configuration.getIdMap().get(ref);
            } else {
                int first;
                if (node.size() == 0) {
                    if ("String".equals(type)) {
                        return "";
                    }
                    return null;
                }
                int last = node.size() - 1;
                if (type == null || !"String".equals(type)) {
                    Object item;
                    for (first = 0; first <= last && (item = node.get(first)) instanceof String && ((String)(item = ((String)item).trim())).length() <= 0; ++first) {
                    }
                    while (first < last && (item = node.get(last)) instanceof String && ((String)(item = ((String)item).trim())).length() <= 0) {
                        --last;
                    }
                    if (first > last) {
                        return null;
                    }
                }
                if (first == last) {
                    value = this.itemValue(obj, node.get(first));
                } else {
                    StringBuilder buf = new StringBuilder();
                    for (int i = first; i <= last; ++i) {
                        Object item = node.get(i);
                        buf.append(this.itemValue(obj, item));
                    }
                    value = buf.toString();
                }
            }
            if (value == null) {
                if ("String".equals(type)) {
                    return "";
                }
                return null;
            }
            if (type == null) {
                if (value instanceof String) {
                    return ((String)value).trim();
                }
                return value;
            }
            if (JettyXmlConfiguration.isTypeMatchingClass(type, String.class)) {
                return value.toString();
            }
            Class pClass = TypeUtil.fromName((String)type);
            if (pClass != null) {
                return TypeUtil.valueOf((Class)pClass, (String)value.toString());
            }
            if (JettyXmlConfiguration.isTypeMatchingClass(type, URL.class)) {
                if (value instanceof URL) {
                    return value;
                }
                try {
                    return new URL(value.toString());
                }
                catch (MalformedURLException e) {
                    throw new InvocationTargetException(e);
                }
            }
            if (JettyXmlConfiguration.isTypeMatchingClass(type, InetAddress.class)) {
                if (value instanceof InetAddress) {
                    return value;
                }
                try {
                    return InetAddress.getByName(value.toString());
                }
                catch (UnknownHostException e) {
                    throw new InvocationTargetException(e);
                }
            }
            for (Class collectionClass : __supportedCollections) {
                if (!JettyXmlConfiguration.isTypeMatchingClass(type, collectionClass)) continue;
                return JettyXmlConfiguration.convertArrayToCollection(value, collectionClass);
            }
            throw new IllegalStateException("Unknown type " + type);
        }

        private static boolean isTypeMatchingClass(String type, Class<?> classToMatch) {
            return classToMatch.getSimpleName().equalsIgnoreCase(type) || classToMatch.getName().equals(type);
        }

        private Object itemValue(Object obj, Object item) throws Exception {
            if (item instanceof String) {
                return item;
            }
            XmlParser.Node node = (XmlParser.Node)item;
            String tag = node.getTag();
            if ("Call".equals(tag)) {
                return this.call(obj, node);
            }
            if ("Get".equals(tag)) {
                return this.get(obj, node);
            }
            if ("New".equals(tag)) {
                return this.newObj(obj, node);
            }
            if ("Ref".equals(tag)) {
                return this.refObj(obj, node);
            }
            if ("Array".equals(tag)) {
                return this.newArray(obj, node);
            }
            if ("Map".equals(tag)) {
                return this.newMap(obj, node);
            }
            if ("Property".equals(tag)) {
                return this.propertyObj(node);
            }
            if ("SystemProperty".equals(tag)) {
                return this.systemPropertyObj(node);
            }
            if ("Env".equals(tag)) {
                return this.envObj(node);
            }
            LOG.warn("Unknown value tag: " + node, new Throwable());
            return null;
        }

        private class AttrOrElementNode {
            final Object _obj;
            final XmlParser.Node _node;
            final Set<String> _elements = new HashSet<String>();
            final int _next;

            AttrOrElementNode(XmlParser.Node node, String ... elements) {
                this(null, node, elements);
            }

            AttrOrElementNode(Object obj, XmlParser.Node node, String ... elements) {
                this._obj = obj;
                this._node = node;
                for (String e : elements) {
                    this._elements.add(e);
                }
                int next = 0;
                for (Object o : this._node) {
                    XmlParser.Node n;
                    if (o instanceof String) {
                        if (((String)o).trim().length() != 0) break;
                        ++next;
                        continue;
                    }
                    if (!(o instanceof XmlParser.Node) || !this._elements.contains((n = (XmlParser.Node)o).getTag())) break;
                    ++next;
                }
                this._next = next;
            }

            public int getNext() {
                return this._next;
            }

            public String getString(String elementName) throws Exception {
                return StringUtil.valueOf((Object)this.get(elementName, false));
            }

            public String getString(String elementName, boolean manditory) throws Exception {
                return StringUtil.valueOf((Object)this.get(elementName, manditory));
            }

            public Object get(String elementName, boolean manditory) throws Exception {
                String attrName = StringUtil.asciiToLowerCase((String)elementName);
                String attr = this._node.getAttribute(attrName);
                Object value = attr;
                for (int i = 0; i < this._next; ++i) {
                    XmlParser.Node n;
                    Object o = this._node.get(i);
                    if (!(o instanceof XmlParser.Node) || !elementName.equals((n = (XmlParser.Node)o).getTag())) continue;
                    if (attr != null) {
                        throw new IllegalStateException("Cannot have attr '" + attrName + "' and element '" + elementName + "'");
                    }
                    value = JettyXmlConfiguration.this.value(this._obj, n);
                    break;
                }
                if (manditory && value == null) {
                    throw new IllegalStateException("Must have attr '" + attrName + "' or element '" + elementName + "'");
                }
                return value;
            }

            public List<Object> getList(String elementName) throws Exception {
                return this.getList(elementName, false);
            }

            public List<Object> getList(String elementName, boolean manditory) throws Exception {
                String attrName = StringUtil.asciiToLowerCase((String)elementName);
                ArrayList<Object> values = new ArrayList<Object>();
                String attr = this._node.getAttribute(attrName);
                if (attr != null) {
                    values.addAll(StringUtil.csvSplit(null, (String)attr, (int)0, (int)attr.length()));
                }
                for (int i = 0; i < this._next; ++i) {
                    XmlParser.Node n;
                    Object o = this._node.get(i);
                    if (!(o instanceof XmlParser.Node) || !elementName.equals((n = (XmlParser.Node)o).getTag())) continue;
                    if (attr != null) {
                        throw new IllegalStateException("Cannot have attr '" + attrName + "' and element '" + elementName + "'");
                    }
                    values.add(JettyXmlConfiguration.this.value(this._obj, n));
                }
                if (manditory && values.isEmpty()) {
                    throw new IllegalStateException("Must have attr '" + attrName + "' or element '" + elementName + "'");
                }
                return values;
            }

            public List<XmlParser.Node> getNodes(String elementName) throws Exception {
                XmlParser.Node n;
                String attrName = StringUtil.asciiToLowerCase((String)elementName);
                ArrayList<XmlParser.Node> values = new ArrayList<XmlParser.Node>();
                String attr = this._node.getAttribute(attrName);
                if (attr != null) {
                    for (String a : StringUtil.csvSplit(null, (String)attr, (int)0, (int)attr.length())) {
                        n = new XmlParser.Node(null, elementName, null);
                        n.add(a);
                        values.add(n);
                    }
                }
                for (int i = 0; i < this._next; ++i) {
                    Object o = this._node.get(i);
                    if (!(o instanceof XmlParser.Node) || !elementName.equals((n = (XmlParser.Node)o).getTag())) continue;
                    if (attr != null) {
                        throw new IllegalStateException("Cannot have attr '" + attrName + "' and element '" + elementName + "'");
                    }
                    values.add(n);
                }
                return values;
            }
        }
    }
}

