/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.tools.launch.rwt.internal.shortcut;

import java.util.Arrays;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.debug.ui.launchConfigurations.JavaLaunchShortcut;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.rap.tools.launch.rwt.internal.config.RWTLaunchConfig;
import org.eclipse.rap.tools.launch.rwt.internal.shortcut.ApplicationSearchEngine;
import org.eclipse.rap.tools.launch.rwt.internal.shortcut.JavaElementUtil;
import org.eclipse.rap.tools.launch.rwt.internal.shortcut.LaunchConfigCreator;
import org.eclipse.rap.tools.launch.rwt.internal.shortcut.LaunchConfigFinder;
import org.eclipse.rap.tools.launch.rwt.internal.shortcut.ServletPathInputDialog;
import org.eclipse.rap.tools.launch.rwt.internal.shortcut.TypeInspector;
import org.eclipse.rap.tools.launch.rwt.internal.util.StatusUtil;

public class RWTLaunchShortcut
extends JavaLaunchShortcut {
    protected ILaunchConfigurationType getConfigurationType() {
        return RWTLaunchConfig.getType();
    }

    protected ILaunchConfiguration createConfiguration(IType type) {
        try {
            return new TypeInspector(type).isEntryPointType() ? this.createEntryPointLaunchConfig(type) : this.createAppConfigLaunchConfig(type);
        }
        catch (CoreException ce) {
            StatusUtil.showCoreException(ce);
            return null;
        }
    }

    private ILaunchConfiguration createEntryPointLaunchConfig(IType type) throws CoreException {
        return LaunchConfigCreator.create(type, RWTLaunchConfig.LaunchTarget.ENTRY_POINT, null);
    }

    private ILaunchConfiguration createAppConfigLaunchConfig(IType type) throws CoreException {
        String servletPath = this.askForServletPath();
        return servletPath == null ? null : LaunchConfigCreator.create(type, RWTLaunchConfig.LaunchTarget.APP_CONFIG, servletPath);
    }

    protected String askForServletPath() {
        ServletPathInputDialog dialog = new ServletPathInputDialog(this.getShell());
        return dialog.open() == 0 ? dialog.getValue() : null;
    }

    protected ILaunchConfiguration findLaunchConfiguration(IType type, ILaunchConfigurationType configType) {
        LaunchConfigFinder.LaunchConfigSelector launchConfigSelector = new LaunchConfigFinder.LaunchConfigSelector(){

            public ILaunchConfiguration select(ILaunchConfiguration[] launchConfigs) {
                return RWTLaunchShortcut.this.chooseConfiguration(Arrays.asList(launchConfigs));
            }
        };
        LaunchConfigFinder launchConfigFinder = new LaunchConfigFinder(launchConfigSelector);
        ILaunchConfiguration result = null;
        try {
            result = launchConfigFinder.forType(type);
        }
        catch (CoreException ce) {
            StatusUtil.showCoreException(ce);
        }
        return result;
    }

    protected IType[] findTypes(Object[] elements, IRunnableContext context) throws InterruptedException, CoreException {
        IJavaElement[] javaElements = JavaElementUtil.adapt(elements);
        ApplicationSearchEngine engine = new ApplicationSearchEngine(context);
        return engine.search(javaElements);
    }

    protected String getTypeSelectionTitle() {
        return "Select RWT Application";
    }

    protected String getEditorEmptyMessage() {
        return "Editor does not contain an entry point or application configuration.";
    }

    protected String getSelectionEmptyMessage() {
        return "Selection does not contain an entry point or application configuration.";
    }
}

