/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.internal.util;

import java.text.MessageFormat;

public final class ParamCheck {
    private static final String NOT_NULL_TEXT = "The parameter ''{0}'' must not be null.";
    private static final String NOT_EMPTY_TEXT = "The parameter ''{0}'' must not be empty.";

    private ParamCheck() {
    }

    public static void notNull(Object param, String paramName) {
        if (param == null) {
            String msg = MessageFormat.format(NOT_NULL_TEXT, paramName);
            throw new NullPointerException(msg);
        }
    }

    public static void notNullOrEmpty(String param, String paramName) {
        ParamCheck.notNull(param, paramName);
        if (param.trim().length() == 0) {
            String msg = MessageFormat.format(NOT_EMPTY_TEXT, paramName);
            throw new IllegalArgumentException(msg);
        }
    }
}

