/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.databaseaccess;

import java.lang.reflect.Type;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.persistence.internal.databaseaccess.FieldTypeDefinition;

public interface DatabaseJsonPlatform {
    default public <T> T getJsonDataFromResultSet(ResultSet resultSet, int columnNumber, Class<T> type) throws SQLException {
        return type.cast(resultSet.getString(columnNumber));
    }

    default public void updateFieldTypes(Hashtable<Class<?>, FieldTypeDefinition> fieldTypeMapping) {
    }

    default public void updateClassTypes(Map<String, Class<?>> classTypeMapping) {
    }

    default public boolean isJsonType(Type type) {
        return false;
    }

    default public String customParameterMarker() {
        return "?";
    }

    default public <T> T unwrap(Class<T> type) {
        if (type.isAssignableFrom(this.getClass())) {
            return type.cast(this);
        }
        throw new IllegalArgumentException("Cannot unwrap to " + type.getName());
    }
}

