/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.mgmt.framework;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Map;
import org.eclipse.ecf.mgmt.PropertiesUtil;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BundleMTO
implements Serializable {
    private static final long serialVersionUID = -8261289274590963132L;
    private final long id;
    private final long lastModified;
    private final int state;
    private final String symbolicName;
    private final String version;
    private final Map<String, String> manifest;
    private final String location;

    public static BundleMTO createMTO(Bundle bundle) {
        if (bundle == null) {
            return null;
        }
        return new BundleMTO(bundle);
    }

    public static BundleMTO[] createMTOs(Bundle[] bundles) {
        ArrayList<BundleMTO> results = new ArrayList<BundleMTO>();
        Bundle[] bundleArray = bundles;
        int n = bundles.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle b = bundleArray[n2];
            results.add(BundleMTO.createMTO(b));
            ++n2;
        }
        return results.toArray(new BundleMTO[results.size()]);
    }

    BundleMTO(Bundle bundle) {
        this.id = bundle.getBundleId();
        this.lastModified = bundle.getLastModified();
        this.state = bundle.getState();
        this.symbolicName = bundle.getSymbolicName();
        this.version = bundle.getVersion().toString();
        this.manifest = PropertiesUtil.convertHeadersToMap((Dictionary)bundle.getHeaders());
        this.location = bundle.getLocation();
    }

    public long getId() {
        return this.id;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public int getState() {
        return this.state;
    }

    public String getSymbolicName() {
        return this.symbolicName;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean isFragment() {
        if (this.manifest == null) {
            return false;
        }
        String result = this.manifest.get("Fragment-Host");
        return result instanceof String;
    }

    public Map<String, String> getManifest() {
        return this.manifest;
    }

    public String getLocation() {
        return this.location;
    }

    public String toString() {
        return "BundleMTO [id=" + this.id + ", lastModified=" + this.lastModified + ", state=" + this.state + ", symbolicName=" + this.symbolicName + ", version=" + this.version + ", manifest=" + this.manifest + ", location=" + this.location + "]";
    }
}

