/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.remoteservice.provider;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.ecf.core.ContainerTypeDescription;
import org.eclipse.ecf.core.identity.Namespace;
import org.eclipse.ecf.core.provider.IContainerInstantiator;
import org.eclipse.ecf.remoteservice.provider.AdapterConfig;
import org.eclipse.ecf.remoteservice.provider.IRemoteServiceDistributionProvider;

public class RemoteServiceDistributionProvider
implements IRemoteServiceDistributionProvider {
    private String name;
    private IContainerInstantiator instantiator;
    private String description;
    private boolean server;
    private boolean hidden;
    private Dictionary<String, ?> ctdProperties;
    private Namespace namespace;
    private Dictionary<String, ?> nsProperties;
    private List<AdapterConfig> adapterConfigs = new ArrayList<AdapterConfig>();

    protected RemoteServiceDistributionProvider() {
    }

    protected RemoteServiceDistributionProvider(String name) {
        this.setName(name);
    }

    protected RemoteServiceDistributionProvider(String name, IContainerInstantiator instantiator) {
        this.setName(name).setInstantiator(instantiator);
    }

    protected RemoteServiceDistributionProvider(String name, IContainerInstantiator instantiator, String description) {
        this.setName(name).setInstantiator(instantiator).setDescription(description);
    }

    protected RemoteServiceDistributionProvider(String name, IContainerInstantiator instantiator, String description, boolean server) {
        this.setName(name).setInstantiator(instantiator).setDescription(description).setServer(server);
    }

    protected String getName() {
        return this.name;
    }

    protected RemoteServiceDistributionProvider setName(String name) {
        Assert.isNotNull((Object)name);
        this.name = name;
        return this;
    }

    protected IContainerInstantiator getInstantiator() {
        return this.instantiator;
    }

    protected RemoteServiceDistributionProvider setInstantiator(IContainerInstantiator instantiator) {
        Assert.isNotNull((Object)instantiator);
        this.instantiator = instantiator;
        return this;
    }

    protected String getDescription() {
        return this.description;
    }

    protected RemoteServiceDistributionProvider setDescription(String desc) {
        this.description = desc;
        return this;
    }

    protected boolean isServer() {
        return this.server;
    }

    protected RemoteServiceDistributionProvider setServer(boolean server) {
        this.server = server;
        return this;
    }

    protected boolean isHidden() {
        return this.hidden;
    }

    protected RemoteServiceDistributionProvider setHidden(boolean hidden) {
        this.hidden = hidden;
        return this;
    }

    protected RemoteServiceDistributionProvider setNamespace(Namespace ns) {
        this.namespace = ns;
        Assert.isNotNull((Object)ns);
        return this;
    }

    protected RemoteServiceDistributionProvider setContainerTypeDescriptionProperties(Dictionary<String, ?> props) {
        this.ctdProperties = props;
        Assert.isNotNull(this.ctdProperties);
        return this;
    }

    protected RemoteServiceDistributionProvider setNamespaceProperties(Dictionary<String, ?> props) {
        this.nsProperties = props;
        Assert.isNotNull(this.nsProperties);
        return this;
    }

    protected RemoteServiceDistributionProvider addAdapterConfig(AdapterConfig adapterConfig) {
        Assert.isNotNull((Object)adapterConfig);
        this.adapterConfigs.add(adapterConfig);
        return this;
    }

    protected RemoteServiceDistributionProvider setAdapterConfig(AdapterConfig adapterConfig) {
        this.addAdapterConfig(adapterConfig);
        return this;
    }

    protected void validateComplete() throws NullPointerException {
        String ctdName = this.getName();
        if (ctdName == null) {
            throw new NullPointerException("Container type description name cannot be null");
        }
        IContainerInstantiator ctdInstantiator = this.getInstantiator();
        if (ctdInstantiator == null) {
            throw new NullPointerException("Container type description instantiator cannot be null");
        }
    }

    @Override
    public ContainerTypeDescription getContainerTypeDescription() {
        this.validateComplete();
        return new ContainerTypeDescription(this.getName(), this.getInstantiator(), this.getDescription(), this.isServer(), this.isHidden());
    }

    @Override
    public Dictionary<String, ?> getContainerTypeDescriptionProperties() {
        return this.ctdProperties;
    }

    @Override
    public Namespace getNamespace() {
        return this.namespace;
    }

    @Override
    public Dictionary<String, ?> getNamespaceProperties() {
        return this.nsProperties;
    }

    @Override
    public AdapterConfig[] getAdapterConfigs() {
        return this.adapterConfigs.toArray(new AdapterConfig[this.adapterConfigs.size()]);
    }

    public static class Builder {
        private final RemoteServiceDistributionProvider instance = new RemoteServiceDistributionProvider();

        public Builder setName(String name) {
            this.instance.setName(name);
            return this;
        }

        public Builder setInstantiator(IContainerInstantiator instantiator) {
            this.instance.setInstantiator(instantiator);
            return this;
        }

        public Builder setDescription(String desc) {
            this.instance.setDescription(desc);
            return this;
        }

        public Builder setServer(boolean server) {
            this.instance.setServer(server);
            return this;
        }

        public Builder setHidden(boolean hidden) {
            this.instance.setHidden(hidden);
            return this;
        }

        public Builder setNamespace(Namespace ns) {
            this.instance.setNamespace(ns);
            return this;
        }

        public Builder setContainerTypeDescriptionProperties(Dictionary<String, ?> props) {
            this.instance.setContainerTypeDescriptionProperties(props);
            return this;
        }

        public Builder setNamespaceProperties(Dictionary<String, ?> props) {
            this.instance.setNamespaceProperties(props);
            return this;
        }

        public Builder setAdapterConfig(AdapterConfig adapterConfig) {
            this.instance.setAdapterConfig(adapterConfig);
            return this;
        }

        public Builder addAdapterConfig(AdapterConfig adapterConfig) {
            this.instance.addAdapterConfig(adapterConfig);
            return this;
        }

        public RemoteServiceDistributionProvider build() {
            this.instance.validateComplete();
            return this.instance;
        }
    }
}

