/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wildwebdeveloper.debug;

import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.lsp4e.debug.launcher.DSPLaunchDelegate;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wildwebdeveloper.embedder.node.NodeJSManager;

public class AbstractHTMLDebugDelegate
extends DSPLaunchDelegate {
    public static final String ARGUMENTS = "runtimeArgs";
    public static final String WEBROOT = "webRoot";
    public static final String FILE_RADIO_BUTTON_SELECTED = "fileRadioButtonSelected";

    public void launchWithParameters(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor, Map<String, Object> param, File debugAdapter) throws CoreException {
        try {
            List<String> debugCmdArgs = Collections.singletonList(debugAdapter.getAbsolutePath());
            DSPLaunchDelegate.DSPLaunchDelegateLaunchBuilder builder = new DSPLaunchDelegate.DSPLaunchDelegateLaunchBuilder(configuration, mode, launch, monitor);
            builder.setLaunchDebugAdapter(NodeJSManager.getNodeJsLocation().getAbsolutePath(), debugCmdArgs);
            builder.setMonitorDebugAdapter(configuration.getAttribute("org.eclipse.lsp4e.debug.model.ATTR_DSP_MONITOR_ADAPTER", false));
            if (!configuration.getAttribute(WEBROOT, "").isBlank()) {
                param.put(WEBROOT, VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(configuration.getAttribute(WEBROOT, "")));
            }
            builder.setDspParameters(param);
            super.launch(builder);
        }
        catch (Exception e) {
            IStatus errorStatus = Status.error((String)e.getMessage(), (Throwable)e);
            ILog.get().log(errorStatus);
            Display.getDefault().asyncExec(() -> {
                int n = ErrorDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Debug error", (String)e.getMessage(), (IStatus)errorStatus);
            });
        }
    }
}

