/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.dbgp.internal.packets;

import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.dltk.dbgp.DbgpRequest;
import org.eclipse.dltk.dbgp.internal.packets.IDbgpRawLogger;

public class DbgpPacketSender {
    private final Object lock = new Object();
    private final OutputStream output;
    private IDbgpRawLogger logger;

    public DbgpPacketSender(OutputStream output) {
        if (output == null) {
            throw new IllegalArgumentException();
        }
        this.output = output;
    }

    public void setLogger(IDbgpRawLogger logger) {
        this.logger = logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendCommand(DbgpRequest command) throws IOException {
        if (this.logger != null) {
            this.logger.log(command);
        }
        Object object = this.lock;
        synchronized (object) {
            command.writeTo(this.output);
            this.output.write(0);
            this.output.flush();
        }
    }
}

