/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.transport.sshd.pkcs11;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import java.util.function.Supplier;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.ChoiceCallback;
import javax.security.auth.callback.ConfirmationCallback;
import javax.security.auth.callback.LanguageCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.TextInputCallback;
import javax.security.auth.callback.TextOutputCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.apache.sshd.common.PropertyResolver;
import org.apache.sshd.common.session.SessionContext;
import org.apache.sshd.core.CoreModuleProperties;
import org.eclipse.jgit.internal.transport.sshd.AuthenticationCanceledException;
import org.eclipse.jgit.internal.transport.sshd.JGitClientSession;
import org.eclipse.jgit.internal.transport.sshd.SshdText;
import org.eclipse.jgit.transport.CredentialItem;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.jgit.transport.sshd.KeyPasswordProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecurityCallback
implements CallbackHandler {
    private static final Logger LOG = LoggerFactory.getLogger(SecurityCallback.class);
    private final URIish uri;
    private KeyPasswordProvider passwordProvider;
    private CredentialsProvider credentialsProvider;
    private int attempts = 0;

    public SecurityCallback(URIish uri) {
        this.uri = uri;
    }

    public int init(SessionContext session) {
        int numberOfAttempts = (Integer)CoreModuleProperties.PASSWORD_PROMPTS.getRequired((PropertyResolver)session);
        Supplier factory = (Supplier)session.getAttribute(JGitClientSession.KEY_PASSWORD_PROVIDER_FACTORY);
        if (factory == null) {
            this.passwordProvider = null;
        } else {
            this.passwordProvider = (KeyPasswordProvider)factory.get();
            this.passwordProvider.setAttempts(numberOfAttempts);
        }
        this.attempts = 0;
        this.credentialsProvider = session instanceof JGitClientSession ? ((JGitClientSession)session).getCredentialsProvider() : null;
        return numberOfAttempts;
    }

    public boolean passwordTried(Exception error) throws IOException, GeneralSecurityException {
        if (this.attempts > 0 && this.passwordProvider != null) {
            return this.passwordProvider.keyLoaded(this.uri, this.attempts, error);
        }
        return true;
    }

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        if (callbacks.length == 1 && callbacks[0] instanceof PasswordCallback && this.passwordProvider != null) {
            char[] password;
            PasswordCallback p = (PasswordCallback)callbacks[0];
            if ((password = this.passwordProvider.getPassphrase(this.uri, this.attempts++)) == null || password.length == 0) {
                throw new AuthenticationCanceledException();
            }
            p.setPassword(password);
            Arrays.fill(password, '\u0000');
        } else {
            this.handleGeneral(callbacks);
        }
    }

    private void handleGeneral(Callback[] callbacks) throws UnsupportedCallbackException {
        ArrayList<Object> items = new ArrayList<Object>();
        ArrayList<Runnable> updaters = new ArrayList<Runnable>();
        int i = 0;
        while (i < callbacks.length) {
            Callback t;
            Callback c = callbacks[i];
            if (c instanceof TextOutputCallback) {
                t = (TextOutputCallback)c;
                String msg = this.getText(((TextOutputCallback)t).getMessageType(), ((TextOutputCallback)t).getMessage());
                if (this.credentialsProvider == null) {
                    LOG.warn("{}", (Object)MessageFormat.format(SshdText.get().pkcs11GeneralMessage, this.uri, msg));
                } else {
                    CredentialItem.InformationalMessage item = new CredentialItem.InformationalMessage(msg);
                    items.add(item);
                }
            } else if (c instanceof TextInputCallback) {
                if (this.credentialsProvider == null) {
                    throw new UnsupportedOperationException("No CredentialsProvider " + this.uri);
                }
                t = (TextInputCallback)c;
                CredentialItem.StringType item = new CredentialItem.StringType(((TextInputCallback)t).getPrompt(), false);
                String defaultValue = ((TextInputCallback)t).getDefaultText();
                if (defaultValue != null) {
                    item.setValue(defaultValue);
                }
                items.add(item);
                updaters.add(() -> SecurityCallback.lambda$0((TextInputCallback)t, item));
            } else if (c instanceof PasswordCallback) {
                if (this.credentialsProvider == null) {
                    throw new UnsupportedOperationException("No CredentialsProvider " + this.uri);
                }
                PasswordCallback p = (PasswordCallback)c;
                CredentialItem.Password item = new CredentialItem.Password(p.getPrompt());
                items.add(item);
                updaters.add(() -> {
                    char[] password2 = item.getValue();
                    if (password2 == null || password2.length == 0) {
                        throw new AuthenticationCanceledException();
                    }
                    p.setPassword(password2);
                    item.clear();
                });
            } else if (c instanceof ConfirmationCallback) {
                if (this.credentialsProvider == null) {
                    throw new UnsupportedOperationException("No CredentialsProvider " + this.uri);
                }
                ConfirmationCallback conf = (ConfirmationCallback)c;
                int options = conf.getOptionType();
                int defaultOption = conf.getDefaultOption();
                CredentialItem.YesNoType item = new CredentialItem.YesNoType(this.getText(conf.getMessageType(), conf.getPrompt()));
                switch (options) {
                    case 0: {
                        if (defaultOption == 0) {
                            item.setValue(true);
                        }
                        updaters.add(() -> conf.setSelectedIndex(item.getValue() ? 0 : 1));
                        break;
                    }
                    case 2: {
                        if (defaultOption == 3) {
                            item.setValue(true);
                        }
                        updaters.add(() -> conf.setSelectedIndex(item.getValue() ? 3 : 2));
                        break;
                    }
                    default: {
                        throw new UnsupportedCallbackException(c);
                    }
                }
                items.add(item);
            } else {
                if (c instanceof ChoiceCallback) {
                    throw new UnsupportedCallbackException(c);
                }
                if (c instanceof LanguageCallback) {
                    ((LanguageCallback)c).setLocale(Locale.getDefault());
                } else {
                    throw new UnsupportedCallbackException(c);
                }
            }
            ++i;
        }
        if (!items.isEmpty()) {
            if (this.credentialsProvider.get(this.uri, items)) {
                updaters.forEach(Runnable::run);
            } else {
                throw new AuthenticationCanceledException();
            }
        }
    }

    private String getText(int messageType, String text) {
        if (messageType == 1) {
            return MessageFormat.format(SshdText.get().pkcs11Warning, text);
        }
        if (messageType == 2) {
            return MessageFormat.format(SshdText.get().pkcs11Error, text);
        }
        return text;
    }

    private static /* synthetic */ void lambda$0(TextInputCallback textInputCallback, CredentialItem.StringType stringType) {
        textInputCallback.setText(stringType.getValue());
    }
}

