/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqlbuilder.actions;

import org.eclipse.datatools.modelbase.sql.query.QueryExpressionBody;
import org.eclipse.datatools.modelbase.sql.query.QueryExpressionRoot;
import org.eclipse.datatools.modelbase.sql.query.QuerySelect;
import org.eclipse.datatools.modelbase.sql.query.QuerySelectStatement;
import org.eclipse.datatools.modelbase.sql.query.WithTableSpecification;
import org.eclipse.datatools.modelbase.sql.query.helper.StatementHelper;
import org.eclipse.datatools.sqltools.sqlbuilder.Messages;
import org.eclipse.datatools.sqltools.sqlbuilder.model.SQLDomainModel;
import org.eclipse.datatools.sqltools.sqlbuilder.model.SelectHelper;
import org.eclipse.datatools.sqltools.sqlbuilder.util.TString;
import org.eclipse.jface.action.Action;

public class CreateWithTableAction
extends Action {
    QuerySelectStatement withStatement;
    SQLDomainModel domainModel;

    public CreateWithTableAction(SQLDomainModel domainModel) {
        super(Messages._UI_ACTION_ADD_COMMON_TABLE);
        this.domainModel = domainModel;
    }

    public void setElement(Object obj) {
        if (obj instanceof QuerySelectStatement) {
            this.withStatement = (QuerySelectStatement)obj;
        } else if (obj instanceof QueryExpressionRoot) {
            this.withStatement = ((QueryExpressionRoot)obj).getSelectStatement();
        }
    }

    public void run() {
        this.createWithTable();
    }

    private void createWithTable() {
        WithTableSpecification withTable = SelectHelper.createWithTableSpecification();
        QuerySelect qSelect = StatementHelper.createQuerySelect();
        withTable.setWithTableQueryExpr((QueryExpressionBody)qSelect);
        if (this.withStatement.getQueryExpr() == null) {
            StatementHelper.createQueryExpressionRoot((QuerySelectStatement)this.withStatement);
        }
        withTable.setName(this.getNewName());
        this.withStatement.getQueryExpr().getWithClause().add((Object)withTable);
        SelectHelper.refresh(this.withStatement);
    }

    public String getNewName() {
        boolean done = false;
        String retVal = "";
        int suff = 1;
        while (!done) {
            String msg = Messages._UI_WITH_TABLE_NAME;
            retVal = TString.change(msg, "%1", Integer.toString(suff));
            done = !this.isDupWithTableName(retVal);
            ++suff;
        }
        return retVal;
    }

    private boolean isDupWithTableName(String name) {
        for (WithTableSpecification wt : this.withStatement.getQueryExpr().getWithClause()) {
            String sname = wt.getName();
            if (sname == null || !sname.trim().equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }
}

