/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.digester3;

import org.apache.commons.digester3.RuleMatcher;
import org.xml.sax.Attributes;

final class PatternRuleMatcher
implements RuleMatcher {
    private final String pattern;
    private String namespaceURI;

    public PatternRuleMatcher(String pattern) {
        this(pattern, null);
    }

    public PatternRuleMatcher(String pattern, String namespaceURI) {
        if (pattern == null) {
            throw new IllegalArgumentException("Input pattern must be not null");
        }
        this.pattern = pattern;
        this.namespaceURI = namespaceURI;
    }

    public boolean match(String namespace, String pattern, String name, Attributes attributes) {
        if (this.namespaceURI != null && !namespace.equals(this.namespaceURI)) {
            return false;
        }
        return this.pattern.equals(pattern);
    }

    public String getPattern() {
        return this.pattern;
    }

    public String getNamespaceURI() {
        return this.namespaceURI;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.namespaceURI == null ? 0 : this.namespaceURI.hashCode());
        result = 31 * result + this.pattern.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PatternRuleMatcher other = (PatternRuleMatcher)obj;
        if (this.namespaceURI == null ? other.getNamespaceURI() != null : !this.namespaceURI.equals(other.getNamespaceURI())) {
            return false;
        }
        return this.pattern.equals(other.getPattern());
    }

    public String toString() {
        return String.format("%s (%s)", this.pattern, this.namespaceURI);
    }
}

