/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.cdt.libhover.devhelp.preferences;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.Collection;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.preference.DirectoryFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.linuxtools.cdt.libhover.LibHoverInfo;
import org.eclipse.linuxtools.cdt.libhover.LibhoverPlugin;
import org.eclipse.linuxtools.internal.cdt.libhover.LibHover;
import org.eclipse.linuxtools.internal.cdt.libhover.LibHoverLibrary;
import org.eclipse.linuxtools.internal.cdt.libhover.devhelp.DevHelpPlugin;
import org.eclipse.linuxtools.internal.cdt.libhover.devhelp.ParseDevHelp;
import org.eclipse.linuxtools.internal.cdt.libhover.devhelp.preferences.LabelFieldEditor;
import org.eclipse.linuxtools.internal.cdt.libhover.devhelp.preferences.LibHoverMessages;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class LibHoverPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private static final String DEVHELP_DIR = "Libhover.Devhelp.Directory";
    private static final String GENERATE = "Libhover.Devhelp.Generate.lbl";
    private static final String REGENERATE_MSG = "Libhover.Devhelp.Regenerate.msg";
    private static final String TITLE = "Libhover.Devhelp.Preference.title";
    private Button generateButton;

    public LibHoverPreferencePage() {
        super(1);
        this.setPreferenceStore(DevHelpPlugin.getDefault().getPreferenceStore());
    }

    private synchronized void regenerate() {
        this.generateButton.setEnabled(false);
        Job k = new Job(LibHoverMessages.getString(REGENERATE_MSG)){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            protected IStatus run(IProgressMonitor monitor) {
                IPreferenceStore ps = DevHelpPlugin.getDefault().getPreferenceStore();
                ParseDevHelp.DevHelpParser p = new ParseDevHelp.DevHelpParser(ps.getString("org.eclipse.linuxtools.cdt.libhover.devhelp.directory"));
                LibHoverInfo hover = p.parse(monitor);
                Collection libs = LibHover.getLibraries();
                for (LibHoverLibrary l : libs) {
                    if (!l.getName().equals("devhelp")) continue;
                    l.setHoverinfo(hover);
                    break;
                }
                try {
                    block16: {
                        IPath location = LibhoverPlugin.getDefault().getStateLocation().append("C");
                        File ldir = new File(location.toOSString());
                        ldir.mkdir();
                        location = location.append("devhelp.libhover");
                        Throwable throwable = null;
                        Object var9_11 = null;
                        try {
                            FileOutputStream f = new FileOutputStream(location.toOSString());
                            try {
                                try (ObjectOutputStream out = new ObjectOutputStream(f);){
                                    out.writeObject(hover);
                                }
                                if (f == null) break block16;
                            }
                            catch (Throwable throwable2) {
                                if (throwable == null) {
                                    throwable = throwable2;
                                } else if (throwable != throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                if (f == null) throw throwable;
                                f.close();
                                throw throwable;
                            }
                            f.close();
                        }
                        catch (Throwable throwable3) {
                            if (throwable == null) {
                                throwable = throwable3;
                                throw throwable;
                            }
                            if (throwable == throwable3) throw throwable;
                            throwable.addSuppressed(throwable3);
                            throw throwable;
                        }
                    }
                    monitor.done();
                    return Status.OK_STATUS;
                }
                catch (IOException e) {
                    monitor.done();
                    return Status.error((String)e.getLocalizedMessage(), (Throwable)e);
                }
            }
        };
        k.setUser(true);
        k.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                Display.getDefault().syncExec(() -> {
                    if (LibHoverPreferencePage.this.generateButton != null) {
                        LibHoverPreferencePage.this.generateButton.setEnabled(true);
                    }
                });
            }
        });
        k.schedule();
    }

    protected void contributeButtons(Composite parent) {
        ++((GridLayout)parent.getLayout()).numColumns;
        this.generateButton = new Button(parent, 0);
        this.generateButton.setFont(parent.getFont());
        this.generateButton.setText(LibHoverMessages.getString(GENERATE));
        this.generateButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.regenerate()));
        this.generateButton.addDisposeListener(event -> {
            Button button = this.generateButton = null;
        });
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        int widthHint = this.convertHorizontalDLUsToPixels(61);
        gd.widthHint = Math.max(widthHint, this.generateButton.computeSize((int)-1, (int)-1, (boolean)true).x);
        this.generateButton.setLayoutData((Object)gd);
    }

    public void createFieldEditors() {
        this.addField(new LabelFieldEditor(this.getFieldEditorParent(), LibHoverMessages.getString(TITLE)));
        this.addField((FieldEditor)new DevhelpStringFieldEditor("org.eclipse.linuxtools.cdt.libhover.devhelp.directory", LibHoverMessages.getString(DEVHELP_DIR), this.getFieldEditorParent()));
    }

    public void init(IWorkbench workbench) {
    }

    private static class DevhelpStringFieldEditor
    extends DirectoryFieldEditor {
        public DevhelpStringFieldEditor(String name, String labelText, Composite parent) {
            super(name, labelText, parent);
            this.setFilterPath(new File(DevHelpPlugin.getDefault().getPreferenceStore().getString(name)));
        }
    }
}

