/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.os.linux.ui.views.cpuusage;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.internal.provisional.tmf.ui.viewers.xychart.BaseXYPresentationProvider;
import org.eclipse.tracecompass.tmf.core.model.OutputElementStyle;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;

public class CPUUsagePresentationProvider
extends BaseXYPresentationProvider {
    private static final int DEFAULT_SERIES_WIDTH = 1;
    private Set<Long> fTotalSeries = new TreeSet<Long>();
    private static Map<ITmfTrace, CPUUsagePresentationProvider> INSTANCES = new HashMap<ITmfTrace, CPUUsagePresentationProvider>();

    public static CPUUsagePresentationProvider getForTrace(ITmfTrace trace) {
        return INSTANCES.computeIfAbsent(trace, t -> new CPUUsagePresentationProvider());
    }

    public void addTotalSeries(long id) {
        this.fTotalSeries.add(id);
    }

    public @NonNull OutputElementStyle getSeriesStyle(@NonNull Long seriesId) {
        if (this.fTotalSeries.contains(seriesId)) {
            return this.getSeriesStyle(seriesId, "line", 1);
        }
        return this.getSeriesStyle(seriesId, "area", 1);
    }
}

